/*
 * Decompiled with CFR 0.152.
 */
package net.jackson.simplegui;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jackson.simplegui.SimpleGuiScreen;
import net.jackson.simplegui.widget.ButtonWidget;
import net.jackson.simplegui.widget.LabelWidget;
import net.jackson.simplegui.widget.ScrollMenuWidget;
import net.jackson.simplegui.widget.SearchableDropdownWidget;
import net.jackson.simplegui.widget.TextBoxWidget;
import net.minecraft.class_173;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1935;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8567;
import net.minecraft.class_9288;
import net.minecraft.class_9334;
import net.minecraft.class_9383;

@Environment(value=EnvType.CLIENT)
public class ContainerEditorGui
extends SimpleGuiScreen {
    private final Consumer<class_9288> onSave;
    private final Consumer<class_2960> onLootTableSave;
    private final class_1799[] containerSlots = new class_1799[27];
    private ScrollMenuWidget itemList;
    private TextBoxWidget searchBox;
    private SearchableDropdownWidget lootTableDropdown;
    private final List<class_1792> allItems = new ArrayList<class_1792>();
    private final List<class_1792> filteredItems = new ArrayList<class_1792>();
    private class_1799 draggedItem = null;
    private int selectedSlot = -1;
    private String lastSearch = "";
    private class_2960 selectedLootTable;
    private static final int SLOT_SIZE = 18;
    private static final int SLOTS_PER_ROW = 9;
    private static final int SLOT_ROWS = 3;

    public ContainerEditorGui(class_437 parent, class_9288 initialContents, Consumer<class_9288> onSave) {
        this(parent, initialContents, onSave, null, null);
    }

    public ContainerEditorGui(class_437 parent, class_9288 initialContents, Consumer<class_9288> onSave, class_2960 initialLootTable, Consumer<class_2960> onLootTableSave) {
        super("Container Editor", parent);
        this.onSave = onSave;
        this.onLootTableSave = onLootTableSave;
        this.selectedLootTable = initialLootTable;
        this.loadItems();
        this.loadInitialContents(initialContents);
    }

    private void loadItems() {
        for (class_1792 item2 : class_7923.field_41178) {
            if (item2 == class_1802.field_8162) continue;
            this.allItems.add(item2);
        }
        this.allItems.sort(Comparator.comparing(item -> class_7923.field_41178.method_10221(item).toString()));
        this.filteredItems.addAll(this.allItems);
    }

    private void loadInitialContents(class_9288 contents) {
        Arrays.fill(this.containerSlots, class_1799.field_8037);
        if (contents != null) {
            List items = contents.method_57489().toList();
            for (int i = 0; i < Math.min(items.size(), this.containerSlots.length); ++i) {
                this.containerSlots[i] = ((class_1799)items.get(i)).method_7972();
            }
        }
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        boolean widgetsExist = this.getWidget("title") != null;
        int centerX = this.field_22789 / 2;
        int leftPanelWidth = 250;
        int leftPanelX = 20;
        int rightPanelX = leftPanelX + leftPanelWidth + 20;
        if (!widgetsExist) {
            LabelWidget title = new LabelWidget("title", centerX, 10, "\u00a76\u00a7lContainer Editor", -1, true, true);
            this.addWidget(title);
            LabelWidget itemListLabel = new LabelWidget("item_list_label", leftPanelX, 35, "\u00a7eItem List:", -1, false, false);
            this.addWidget(itemListLabel);
            this.searchBox = new TextBoxWidget("search", leftPanelX, 50, leftPanelWidth, 20, -14671840, -8355712, -1, -10461088);
            this.searchBox.setHint("Type to search items...");
            this.searchBox.setMaxLength(64);
            this.addWidget(this.searchBox);
            this.itemList = new ScrollMenuWidget("item_list", leftPanelX, 80, leftPanelWidth, this.field_22790 - 150, -15066598, -14013910, -12632257, -1, -10461088);
            this.itemList.setItemHeight(24);
            this.updateItemList("");
            this.addWidget(this.itemList);
            LabelWidget lootTableLabel = new LabelWidget("loot_table_label", leftPanelX, this.field_22790 - 60, "\u00a7eOr select a Loot Table:", -1, false, false);
            this.addWidget(lootTableLabel);
            this.lootTableDropdown = new SearchableDropdownWidget("loot_table_dropdown", leftPanelX, this.field_22790 - 45, leftPanelWidth - 60, 20, -14671840, -13619152, -1);
            this.populateLootTables();
            this.addWidget(this.lootTableDropdown);
            ButtonWidget loadLootBtn = new ButtonWidget("load_loot", leftPanelX + leftPanelWidth - 55, this.field_22790 - 45, 55, 20, "Load", -14001521, -12948833, -1);
            loadLootBtn.setOnPress(this::loadLootTableContents);
            this.addWidget(loadLootBtn);
            LabelWidget slotsLabel = new LabelWidget("slots_label", rightPanelX, 35, "\u00a7eContainer Slots (drag items here):", -1, false, false);
            this.addWidget(slotsLabel);
            LabelWidget instructionsLabel = new LabelWidget("instructions_label", rightPanelX, 50, "\u00a77Left-click to drag, Right-click to change count", -5592406, false, false);
            this.addWidget(instructionsLabel);
            ButtonWidget saveBtn = new ButtonWidget("save", centerX - 105, this.field_22790 - 35, 100, 20, "Apply", -13996502, -13004999, -1);
            saveBtn.setOnPress(() -> {
                if (this.onSave != null) {
                    ArrayList<class_1799> items = new ArrayList<class_1799>();
                    for (class_1799 stack : this.containerSlots) {
                        if (!stack.method_7960() && stack.method_7947() > 0) {
                            items.add(stack.method_7972());
                            continue;
                        }
                        items.add(class_1799.field_8037);
                    }
                    this.onSave.accept(class_9288.method_57493(items));
                }
                if (this.onLootTableSave != null && this.selectedLootTable != null) {
                    this.onLootTableSave.accept(this.selectedLootTable);
                }
                this.method_25419();
            });
            this.addWidget(saveBtn);
            ButtonWidget cancelBtn = new ButtonWidget("cancel", centerX + 5, this.field_22790 - 35, 100, 20, "Cancel", -9737365, -7697782, -1);
            cancelBtn.setOnPress(this::method_25419);
            this.addWidget(cancelBtn);
        } else {
            this.searchBox = (TextBoxWidget)this.getWidget("search");
            this.itemList = (ScrollMenuWidget)this.getWidget("item_list");
        }
    }

    public void method_25393() {
        super.method_25393();
        if (this.searchBox != null) {
            String searchText = this.searchBox.getValue();
            this.updateItemList(searchText);
        }
    }

    private void updateItemList(String searchText) {
        String itemName;
        if (searchText.equals(this.lastSearch)) {
            return;
        }
        this.lastSearch = searchText;
        this.filteredItems.clear();
        String search = searchText.toLowerCase();
        for (class_1792 item : this.allItems) {
            itemName = class_7923.field_41178.method_10221((Object)item).toString();
            if (!itemName.toLowerCase().contains(search)) continue;
            this.filteredItems.add(item);
        }
        this.itemList.clearItems();
        for (class_1792 item : this.filteredItems) {
            itemName = class_7923.field_41178.method_10221((Object)item).toString();
            this.itemList.addItem(itemName);
            this.itemList.setItemOverlay(this.itemList.getItemCount() - 1, new class_1799((class_1935)item));
        }
    }

    private void populateLootTables() {
        String lootTableStr;
        int index2;
        ArrayList<String> lootTables = new ArrayList<String>();
        lootTables.add("(None)");
        lootTables.add("minecraft:chests/abandoned_mineshaft");
        lootTables.add("minecraft:chests/ancient_city");
        lootTables.add("minecraft:chests/ancient_city_ice_box");
        lootTables.add("minecraft:chests/bastion_bridge");
        lootTables.add("minecraft:chests/bastion_hoglin_stable");
        lootTables.add("minecraft:chests/bastion_other");
        lootTables.add("minecraft:chests/bastion_treasure");
        lootTables.add("minecraft:chests/buried_treasure");
        lootTables.add("minecraft:chests/desert_pyramid");
        lootTables.add("minecraft:chests/end_city_treasure");
        lootTables.add("minecraft:chests/igloo_chest");
        lootTables.add("minecraft:chests/jungle_temple");
        lootTables.add("minecraft:chests/jungle_temple_dispenser");
        lootTables.add("minecraft:chests/nether_bridge");
        lootTables.add("minecraft:chests/pillager_outpost");
        lootTables.add("minecraft:chests/ruined_portal");
        lootTables.add("minecraft:chests/shipwreck_map");
        lootTables.add("minecraft:chests/shipwreck_supply");
        lootTables.add("minecraft:chests/shipwreck_treasure");
        lootTables.add("minecraft:chests/simple_dungeon");
        lootTables.add("minecraft:chests/spawn_bonus_chest");
        lootTables.add("minecraft:chests/stronghold_corridor");
        lootTables.add("minecraft:chests/stronghold_crossing");
        lootTables.add("minecraft:chests/stronghold_library");
        lootTables.add("minecraft:chests/trial_chambers/corridor");
        lootTables.add("minecraft:chests/trial_chambers/entrance");
        lootTables.add("minecraft:chests/trial_chambers/intersection");
        lootTables.add("minecraft:chests/trial_chambers/reward");
        lootTables.add("minecraft:chests/trial_chambers/reward_rare");
        lootTables.add("minecraft:chests/trial_chambers/supply");
        lootTables.add("minecraft:chests/underwater_ruin_big");
        lootTables.add("minecraft:chests/underwater_ruin_small");
        lootTables.add("minecraft:chests/village/village_armorer");
        lootTables.add("minecraft:chests/village/village_butcher");
        lootTables.add("minecraft:chests/village/village_cartographer");
        lootTables.add("minecraft:chests/village/village_desert_house");
        lootTables.add("minecraft:chests/village/village_fisher");
        lootTables.add("minecraft:chests/village/village_fletcher");
        lootTables.add("minecraft:chests/village/village_mason");
        lootTables.add("minecraft:chests/village/village_plains_house");
        lootTables.add("minecraft:chests/village/village_savanna_house");
        lootTables.add("minecraft:chests/village/village_shepherd");
        lootTables.add("minecraft:chests/village/village_snowy_house");
        lootTables.add("minecraft:chests/village/village_taiga_house");
        lootTables.add("minecraft:chests/village/village_tannery");
        lootTables.add("minecraft:chests/village/village_temple");
        lootTables.add("minecraft:chests/village/village_toolsmith");
        lootTables.add("minecraft:chests/village/village_weaponsmith");
        lootTables.add("minecraft:chests/woodland_mansion");
        this.lootTableDropdown.setOptions(lootTables);
        if (this.selectedLootTable != null && (index2 = lootTables.indexOf(lootTableStr = this.selectedLootTable.toString())) >= 0) {
            this.lootTableDropdown.setSelectedIndex(index2);
        }
        this.lootTableDropdown.setOnChanged(index -> {
            if (index == 0) {
                this.selectedLootTable = null;
            } else {
                String selected = (String)lootTables.get((int)index);
                this.selectedLootTable = class_2960.method_60654((String)selected);
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadLootTableContents() {
        if (this.selectedLootTable == null) {
            return;
        }
        if (this.field_22787 != null && this.field_22787.field_1687 != null && this.field_22787.method_1576() != null) {
            try {
                class_3218 serverLevel = this.field_22787.method_1576().method_30002();
                class_9383.class_9385 registries = serverLevel.method_8503().method_58576();
                class_5321 lootTableKey = class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)this.selectedLootTable);
                class_52 lootTable = registries.method_58295(lootTableKey);
                if (lootTable == class_52.field_948) return;
                class_8567.class_8568 builder = new class_8567.class_8568(serverLevel).method_51874(class_181.field_24424, (Object)class_243.field_1353);
                class_8567 params = builder.method_51875(class_173.field_1179);
                ObjectArrayList generatedLoot = lootTable.method_51878(params);
                Arrays.fill(this.containerSlots, class_1799.field_8037);
                Random random = new Random();
                ArrayList<Integer> availableSlots = new ArrayList<Integer>();
                for (int i = 0; i < this.containerSlots.length; ++i) {
                    availableSlots.add(i);
                }
                for (class_1799 stack : generatedLoot) {
                    if (availableSlots.isEmpty()) return;
                    if (stack.method_7960()) continue;
                    int randomIndex = random.nextInt(availableSlots.size());
                    int slotIndex = (Integer)availableSlots.remove(randomIndex);
                    this.containerSlots[slotIndex] = new class_1799((class_1935)stack.method_7909(), stack.method_7947());
                }
                return;
            }
            catch (Exception e) {
                System.err.println("Could not load loot table: " + e.getMessage());
                e.printStackTrace();
                Arrays.fill(this.containerSlots, class_1799.field_8037);
                class_1799 placeholder = new class_1799((class_1935)class_1802.field_8407);
                placeholder.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"\u00a7cLoot Preview Unavailable"));
                this.containerSlots[0] = placeholder;
                return;
            }
        } else {
            Arrays.fill(this.containerSlots, class_1799.field_8037);
            class_1799 placeholder = new class_1799((class_1935)class_1802.field_8407);
            placeholder.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"\u00a7cOnly works in singleplayer"));
            this.containerSlots[0] = placeholder;
        }
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        int leftPanelWidth = 250;
        int leftPanelX = 20;
        int rightPanelX = leftPanelX + leftPanelWidth + 20;
        int slotGridX = rightPanelX + 10;
        int slotGridY = 80;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int slotIndex = row * 9 + col;
                int slotX = slotGridX + col * 18;
                int slotY = slotGridY + row * 18;
                int slotColor = slotIndex == this.selectedSlot ? -11908465 : -12961222;
                graphics.method_25294(slotX, slotY, slotX + 18, slotY + 18, slotColor);
                graphics.method_25294(slotX, slotY, slotX + 18, slotY + 1, -7631989);
                graphics.method_25294(slotX, slotY, slotX + 1, slotY + 18, -7631989);
                graphics.method_25294(slotX + 18 - 1, slotY, slotX + 18, slotY + 18, -13158601);
                graphics.method_25294(slotX, slotY + 18 - 1, slotX + 18, slotY + 18, -13158601);
                class_1799 stack = this.containerSlots[slotIndex];
                if (stack.method_7960()) continue;
                graphics.method_51427(stack, slotX + 1, slotY + 1);
                graphics.method_51431(this.field_22793, stack, slotX + 1, slotY + 1);
                if (stack.method_7947() <= 1) continue;
                String countText = String.valueOf(stack.method_7947());
                graphics.method_51433(this.field_22793, countText, slotX + 18 - 2 - this.field_22793.method_1727(countText), slotY + 18 - 9, -1, true);
            }
        }
        if (this.draggedItem != null && !this.draggedItem.method_7960()) {
            graphics.method_51427(this.draggedItem, mouseX - 8, mouseY - 8);
            graphics.method_51431(this.field_22793, this.draggedItem, mouseX - 8, mouseY - 8);
        }
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        class_1792 item;
        int selectedIndex;
        int leftPanelWidth = 250;
        int leftPanelX = 20;
        int rightPanelX = leftPanelX + leftPanelWidth + 20;
        int slotGridX = rightPanelX + 10;
        int slotGridY = 80;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int slotIndex = row * 9 + col;
                int slotX = slotGridX + col * 18;
                int slotY = slotGridY + row * 18;
                if (!(mouseX >= (double)slotX) || !(mouseX < (double)(slotX + 18)) || !(mouseY >= (double)slotY) || !(mouseY < (double)(slotY + 18))) continue;
                if (button == 0) {
                    if (this.draggedItem != null && !this.draggedItem.method_7960()) {
                        this.containerSlots[slotIndex] = this.draggedItem.method_7972();
                        this.draggedItem = null;
                    } else if (!this.containerSlots[slotIndex].method_7960()) {
                        this.draggedItem = this.containerSlots[slotIndex].method_7972();
                        this.containerSlots[slotIndex] = class_1799.field_8037;
                    }
                    this.selectedSlot = slotIndex;
                    return true;
                }
                if (button != 1 || this.containerSlots[slotIndex].method_7960()) continue;
                this.openCountEditor(slotIndex);
                return true;
            }
        }
        boolean handled = super.method_25402(mouseX, mouseY, button);
        if (this.itemList != null && button == 0 && handled && mouseX >= (double)leftPanelX && mouseX < (double)(leftPanelX + leftPanelWidth) && mouseY >= 80.0 && mouseY < (double)(this.field_22790 - 70) && (selectedIndex = this.itemList.getSelectedIndex()) >= 0 && selectedIndex < this.filteredItems.size() && (item = this.filteredItems.get(selectedIndex)) != null) {
            this.draggedItem = new class_1799((class_1935)item, 1);
        }
        return handled;
    }

    private void openCountEditor(int slotIndex) {
        final class_1799 stack = this.containerSlots[slotIndex];
        if (stack.method_7960()) {
            return;
        }
        SimpleGuiScreen countEditorScreen = new SimpleGuiScreen(this, "Edit Item Count", this){
            private TextBoxWidget countInput;

            @Override
            protected void method_25426() {
                super.method_25426();
                int centerX = this.field_22789 / 2;
                int centerY = this.field_22790 / 2;
                this.countInput = new TextBoxWidget("count_input", centerX - 50, centerY - 10, 100, 20, -14671840, -8355712, -1, -10461088);
                this.countInput.setValue(String.valueOf(stack.method_7947()));
                this.countInput.setMaxLength(2);
                this.countInput.setHint("1-99");
                this.addWidget(this.countInput);
                ButtonWidget okBtn = new ButtonWidget("ok", centerX - 55, centerY + 25, 50, 20, "OK", -13996502, -13004999, -1);
                okBtn.setOnPress(() -> {
                    try {
                        int count = Integer.parseInt(this.countInput.getValue());
                        if (count > 0 && count <= 99) {
                            stack.method_7939(count);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    this.method_25419();
                });
                this.addWidget(okBtn);
                ButtonWidget cancelBtn = new ButtonWidget("cancel", centerX + 5, centerY + 25, 50, 20, "Cancel", -9737365, -7697782, -1);
                cancelBtn.setOnPress(this::method_25419);
                this.addWidget(cancelBtn);
            }

            @Override
            public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
                this.method_25420(graphics, mouseX, mouseY, partialTick);
                int centerX = this.field_22789 / 2;
                int centerY = this.field_22790 / 2;
                graphics.method_25294(centerX - 100, centerY - 50, centerX + 100, centerY + 60, -299884512);
                graphics.method_25294(centerX - 100, centerY - 50, centerX + 100, centerY - 49, -11908465);
                graphics.method_25300(this.field_22793, "\u00a7eEdit Item Count", centerX, centerY - 40, -1);
                super.method_25394(graphics, mouseX, mouseY, partialTick);
            }
        };
        if (this.field_22787 != null) {
            this.field_22787.method_1507((class_437)countEditorScreen);
        }
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && this.draggedItem != null && !this.draggedItem.method_7960()) {
            this.draggedItem = null;
            return true;
        }
        if (!(keyCode != 261 && keyCode != 259 || this.selectedSlot < 0 || this.selectedSlot >= this.containerSlots.length || this.containerSlots[this.selectedSlot].method_7960())) {
            this.containerSlots[this.selectedSlot] = class_1799.field_8037;
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }
}

