/*
 * Decompiled with CFR 0.152.
 */
package net.jackson.simplegui;

import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jackson.simplegui.SimpleGuiScreen;
import net.jackson.simplegui.widget.ButtonWidget;
import net.jackson.simplegui.widget.LabelWidget;
import net.jackson.simplegui.widget.TextBoxWidget;
import net.minecraft.class_437;
import net.minecraft.class_9282;

@Environment(value=EnvType.CLIENT)
public class DyedColorEditorGui
extends SimpleGuiScreen {
    private final Consumer<class_9282> onSave;
    private TextBoxWidget redInput;
    private TextBoxWidget greenInput;
    private TextBoxWidget blueInput;
    private ButtonWidget previewButton;
    private int currentColor = 0xFFFFFF;

    public DyedColorEditorGui(class_437 parent, int initialColor, Consumer<class_9282> onSave) {
        super("Dyed Color Editor", parent);
        this.onSave = onSave;
        this.currentColor = initialColor;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        int panelWidth = 300;
        int panelX = centerX - panelWidth / 2;
        LabelWidget title = new LabelWidget("title", centerX, 10, "\u00a76\u00a7lDyed Color Editor", -1, true, true);
        this.addWidget(title);
        LabelWidget redLabel = new LabelWidget("red_label", panelX, 40, "\u00a7cRed (0-255):", -1, false, false);
        this.addWidget(redLabel);
        this.redInput = new TextBoxWidget("red_input", panelX, 55, panelWidth, 20, -14671840, -8355712, -1, -10461088);
        this.redInput.setValue(String.valueOf(this.currentColor >> 16 & 0xFF));
        this.redInput.setMaxLength(3);
        this.redInput.setHint("0-255");
        this.addWidget(this.redInput);
        LabelWidget greenLabel = new LabelWidget("green_label", panelX, 85, "\u00a7aGreen (0-255):", -1, false, false);
        this.addWidget(greenLabel);
        this.greenInput = new TextBoxWidget("green_input", panelX, 100, panelWidth, 20, -14671840, -8355712, -1, -10461088);
        this.greenInput.setValue(String.valueOf(this.currentColor >> 8 & 0xFF));
        this.greenInput.setMaxLength(3);
        this.greenInput.setHint("0-255");
        this.addWidget(this.greenInput);
        LabelWidget blueLabel = new LabelWidget("blue_label", panelX, 130, "\u00a79Blue (0-255):", -1, false, false);
        this.addWidget(blueLabel);
        this.blueInput = new TextBoxWidget("blue_input", panelX, 145, panelWidth, 20, -14671840, -8355712, -1, -10461088);
        this.blueInput.setValue(String.valueOf(this.currentColor & 0xFF));
        this.blueInput.setMaxLength(3);
        this.blueInput.setHint("0-255");
        this.addWidget(this.blueInput);
        LabelWidget previewLabel = new LabelWidget("preview_label", panelX, 175, "\u00a7eColor Preview:", -1, false, false);
        this.addWidget(previewLabel);
        this.previewButton = new ButtonWidget("preview", panelX, 190, panelWidth, 30, "     ", 0xFF000000 | this.currentColor, 0xFF000000 | this.currentColor, -1);
        this.addWidget(this.previewButton);
        Runnable updatePreview = () -> {
            try {
                int r = Math.min(255, Math.max(0, Integer.parseInt(this.redInput.getValue())));
                int g = Math.min(255, Math.max(0, Integer.parseInt(this.greenInput.getValue())));
                int b = Math.min(255, Math.max(0, Integer.parseInt(this.blueInput.getValue())));
                this.currentColor = r << 16 | g << 8 | b;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        };
        LabelWidget presetsLabel = new LabelWidget("presets_label", panelX, 230, "\u00a7ePresets:", -1, false, false);
        this.addWidget(presetsLabel);
        int presetY = 245;
        int presetSize = 30;
        int presetSpacing = 5;
        int[] presetColors = new int[]{0xFF0000, 65280, 255, 0xFFFF00, 0xFF00FF, 65535, 0xFFFFFF, 0x808080, 0};
        for (int i = 0; i < presetColors.length; ++i) {
            int col = presetColors[i];
            int presetX = panelX + i * (presetSize + presetSpacing);
            ButtonWidget presetBtn = new ButtonWidget("preset_" + i, presetX, presetY, presetSize, presetSize, "", 0xFF000000 | col, 0xFF000000 | col, -1);
            presetBtn.setOnPress(() -> {
                this.currentColor = col;
                this.redInput.setValue(String.valueOf(col >> 16 & 0xFF));
                this.greenInput.setValue(String.valueOf(col >> 8 & 0xFF));
                this.blueInput.setValue(String.valueOf(col & 0xFF));
                updatePreview.run();
            });
            this.addWidget(presetBtn);
        }
        ButtonWidget saveBtn = new ButtonWidget("save", centerX - 105, this.field_22790 - 35, 100, 20, "Apply", -13996502, -13004999, -1);
        saveBtn.setOnPress(() -> {
            updatePreview.run();
            if (this.onSave != null) {
                this.onSave.accept(new class_9282(this.currentColor, true));
            }
            this.method_25419();
        });
        this.addWidget(saveBtn);
        ButtonWidget cancelBtn = new ButtonWidget("cancel", centerX + 5, this.field_22790 - 35, 100, 20, "Cancel", -9737365, -7697782, -1);
        cancelBtn.setOnPress(this::method_25419);
        this.addWidget(cancelBtn);
    }
}

