/*
 * Decompiled with CFR 0.152.
 */
package net.jackson.simplegui;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jackson.simplegui.SimpleGuiScreen;
import net.jackson.simplegui.widget.ButtonWidget;
import net.jackson.simplegui.widget.DropdownWidget;
import net.jackson.simplegui.widget.LabelWidget;
import net.jackson.simplegui.widget.ScrollMenuWidget;
import net.jackson.simplegui.widget.TextBoxWidget;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2378;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9334;

@Environment(value=EnvType.CLIENT)
public class EnchantmentEditorGui
extends SimpleGuiScreen {
    private final class_1799 itemStack;
    private final boolean isStoredEnchantments;
    private final Consumer<class_9304> onSave;
    private ScrollMenuWidget enchantmentList;
    private TextBoxWidget levelInput;
    private final Map<class_6880<class_1887>, Integer> enchantments = new LinkedHashMap<class_6880<class_1887>, Integer>();
    private final List<class_6880<class_1887>> allEnchants = new ArrayList<class_6880<class_1887>>();

    public EnchantmentEditorGui(class_437 parent, class_1799 itemStack, boolean isStoredEnchantments, Consumer<class_9304> onSave) {
        super(isStoredEnchantments ? "Stored Enchantments Editor" : "Enchantments Editor", parent);
        this.itemStack = itemStack;
        this.isStoredEnchantments = isStoredEnchantments;
        this.onSave = onSave;
        this.loadExistingEnchantments();
    }

    private void loadExistingEnchantments() {
        class_9304 existing = this.isStoredEnchantments ? (class_9304)this.itemStack.method_57825(class_9334.field_49643, (Object)class_9304.field_49385) : class_1890.method_57532((class_1799)this.itemStack);
        for (Object2IntMap.Entry entry : existing.method_57539()) {
            this.enchantments.put((class_6880<class_1887>)((class_6880)entry.getKey()), entry.getIntValue());
        }
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        int panelWidth = 350;
        int panelX = centerX - panelWidth / 2;
        LabelWidget title = new LabelWidget("title", centerX, 10, "\u00a76\u00a7l" + (this.isStoredEnchantments ? "Stored Enchantments" : "Enchantments"), -1, true, true);
        this.addWidget(title);
        LabelWidget currentLabel = new LabelWidget("current_label", panelX, 30, "\u00a7eCurrent Enchantments:", -1, false, false);
        this.addWidget(currentLabel);
        this.enchantmentList = new ScrollMenuWidget("enchant_list", panelX, 45, panelWidth, 120, -15066598, -14013910, -12632257, -1, -10461088);
        this.enchantmentList.setItemHeight(20);
        this.updateEnchantmentList();
        this.addWidget(this.enchantmentList);
        LabelWidget addLabel = new LabelWidget("add_label", panelX, 175, "\u00a7eAdd/Modify Enchantment:", -1, false, false);
        this.addWidget(addLabel);
        DropdownWidget enchantDropdown = new DropdownWidget("enchant_dropdown", panelX, 190, panelWidth - 80, 20);
        if (this.itemStack != null && !this.itemStack.method_7960() && this.field_22787 != null && this.field_22787.field_1687 != null) {
            try {
                class_2378 levelRegistry = this.field_22787.field_1687.method_30349().method_30530(class_7924.field_41265);
                for (class_6880.class_6883 entry : levelRegistry.method_42017().toList()) {
                    this.allEnchants.add((class_6880<class_1887>)entry);
                    Optional key = entry.method_40230();
                    String name = key.isPresent() ? ((class_5321)key.get()).method_29177().method_12832().replace("_", " ") : "unknown";
                    enchantDropdown.addOption(name);
                }
            }
            catch (Exception e) {
                this.addCommonEnchantments(enchantDropdown);
            }
        } else {
            this.addCommonEnchantments(enchantDropdown);
        }
        this.addWidget(enchantDropdown);
        this.levelInput = new TextBoxWidget("level_input", panelX + panelWidth - 70, 190, 70, 20);
        this.levelInput.setValue("1");
        this.levelInput.setMaxLength(3);
        this.levelInput.setHint("Level");
        this.addWidget(this.levelInput);
        ButtonWidget addBtn = new ButtonWidget("add_btn", panelX, 215, 100, 20, "Add/Update", -13996502, -13004999, -1);
        addBtn.setOnPress(() -> {
            try {
                int selectedIndex = enchantDropdown.getSelectedIndex();
                if (selectedIndex >= 0 && selectedIndex < this.allEnchants.size()) {
                    class_6880<class_1887> enchant = this.allEnchants.get(selectedIndex);
                    int level = Integer.parseInt(this.levelInput.getValue());
                    if (level > 0 && level <= 255) {
                        this.enchantments.put(enchant, level);
                        this.updateEnchantmentList();
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        this.addWidget(addBtn);
        ButtonWidget removeBtn = new ButtonWidget("remove_btn", panelX + 110, 215, 100, 20, "Remove", -9557462, -7390919, -1);
        removeBtn.setOnPress(() -> {
            ArrayList<class_6880<class_1887>> keys;
            int selectedIndex = this.enchantmentList.getSelectedIndex();
            if (selectedIndex >= 0 && selectedIndex < (keys = new ArrayList<class_6880<class_1887>>(this.enchantments.keySet())).size()) {
                this.enchantments.remove(keys.get(selectedIndex));
                this.updateEnchantmentList();
            }
        });
        this.addWidget(removeBtn);
        ButtonWidget clearBtn = new ButtonWidget("clear_btn", panelX + 220, 215, 100, 20, "Clear All", -9557462, -7390919, -1);
        clearBtn.setOnPress(() -> {
            this.enchantments.clear();
            this.updateEnchantmentList();
        });
        this.addWidget(clearBtn);
        ButtonWidget saveBtn = new ButtonWidget("save", centerX - 105, this.field_22790 - 35, 100, 20, "Save", -13996502, -13004999, -1);
        saveBtn.setOnPress(() -> {
            this.saveEnchantments();
            this.method_25419();
        });
        this.addWidget(saveBtn);
        ButtonWidget cancelBtn = new ButtonWidget("cancel", centerX + 5, this.field_22790 - 35, 100, 20, "Cancel", -9737365, -7697782, -1);
        cancelBtn.setOnPress(this::method_25419);
        this.addWidget(cancelBtn);
    }

    private void updateEnchantmentList() {
        this.enchantmentList.clearItems();
        for (Map.Entry<class_6880<class_1887>, Integer> entry : this.enchantments.entrySet()) {
            String name = this.getEnchantmentName(entry.getKey());
            this.enchantmentList.addItem(name + " " + String.valueOf(entry.getValue()));
        }
    }

    private String getEnchantmentName(class_6880<class_1887> enchant) {
        Optional key = enchant.method_40230();
        if (key.isPresent()) {
            return ((class_5321)key.get()).method_29177().method_12832().replace("_", " ");
        }
        return "unknown";
    }

    private void saveEnchantments() {
        class_9304.class_9305 mutable = new class_9304.class_9305(class_9304.field_49385);
        for (Map.Entry<class_6880<class_1887>, Integer> entry : this.enchantments.entrySet()) {
            mutable.method_57547(entry.getKey(), entry.getValue().intValue());
        }
        if (this.onSave != null) {
            this.onSave.accept(mutable.method_57549());
        }
    }

    private void addCommonEnchantments(DropdownWidget dropdown) {
        String[] commonEnchants;
        for (String name : commonEnchants = new String[]{"sharpness", "protection", "efficiency", "unbreaking", "fortune", "looting", "silk touch", "mending", "thorns", "fire aspect", "knockback", "smite", "bane of arthropods", "power", "punch", "flame", "infinity", "luck of the sea", "lure", "frost walker", "depth strider", "respiration", "aqua affinity", "feather falling", "blast protection", "fire protection", "projectile protection"}) {
            dropdown.addOption(name);
        }
    }
}

