/*
 * Decompiled with CFR 0.152.
 */
package net.jackson.simplegui;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jackson.simplegui.FireworkExplosionEditorGui;
import net.jackson.simplegui.SimpleGuiScreen;
import net.jackson.simplegui.widget.ButtonWidget;
import net.jackson.simplegui.widget.LabelWidget;
import net.jackson.simplegui.widget.ScrollMenuWidget;
import net.jackson.simplegui.widget.TextBoxWidget;
import net.minecraft.class_437;
import net.minecraft.class_9283;
import net.minecraft.class_9284;

@Environment(value=EnvType.CLIENT)
public class FireworksEditorGui
extends SimpleGuiScreen {
    private final Consumer<class_9284> onSave;
    private TextBoxWidget flightDurationInput;
    private ScrollMenuWidget explosionList;
    private final List<class_9283> explosions = new ArrayList<class_9283>();

    public FireworksEditorGui(class_437 parent, class_9284 initial, Consumer<class_9284> onSave) {
        super("Fireworks Editor", parent);
        this.onSave = onSave;
        if (initial != null) {
            this.explosions.addAll(initial.comp_2392());
        }
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        int panelWidth = 350;
        int panelX = centerX - panelWidth / 2;
        LabelWidget title = new LabelWidget("title", centerX, 10, "\u00a76\u00a7lFireworks Editor", -1, true, true);
        this.addWidget(title);
        LabelWidget durationLabel = new LabelWidget("duration_label", panelX, 35, "\u00a7eFlight Duration:", -1, false, false);
        this.addWidget(durationLabel);
        this.flightDurationInput = new TextBoxWidget("duration_input", panelX, 50, panelWidth, 20, -14671840, -8355712, -1, -10461088);
        this.flightDurationInput.setValue("1");
        this.flightDurationInput.setMaxLength(2);
        this.flightDurationInput.setHint("1-3");
        this.addWidget(this.flightDurationInput);
        LabelWidget explosionsLabel = new LabelWidget("explosions_label", panelX, 80, "\u00a7eExplosions:", -1, false, false);
        this.addWidget(explosionsLabel);
        this.explosionList = new ScrollMenuWidget("explosion_list", panelX, 95, panelWidth, 120, -15066598, -14013910, -12632257, -1, -10461088);
        this.explosionList.setItemHeight(20);
        this.updateExplosionList();
        this.addWidget(this.explosionList);
        ButtonWidget addBtn = new ButtonWidget("add_explosion", panelX, 225, 110, 20, "Add", -13996502, -13004999, -1);
        addBtn.setOnPress(() -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507((class_437)new FireworkExplosionEditorGui(this, null, explosion -> {
                    this.explosions.add((class_9283)explosion);
                    this.updateExplosionList();
                }));
            }
        });
        this.addWidget(addBtn);
        ButtonWidget editBtn = new ButtonWidget("edit_explosion", panelX + 120, 225, 110, 20, "Edit", -12961170, -11908465, -1);
        editBtn.setOnPress(() -> {
            int selected = this.explosionList.getSelectedIndex();
            if (selected >= 0 && selected < this.explosions.size() && this.field_22787 != null) {
                class_9283 explosion = this.explosions.get(selected);
                this.field_22787.method_1507((class_437)new FireworkExplosionEditorGui(this, explosion, newExplosion -> {
                    this.explosions.set(selected, (class_9283)newExplosion);
                    this.updateExplosionList();
                }));
            }
        });
        this.addWidget(editBtn);
        ButtonWidget removeBtn = new ButtonWidget("remove_explosion", panelX + 240, 225, 110, 20, "Remove", -9557462, -7390919, -1);
        removeBtn.setOnPress(() -> {
            int selected = this.explosionList.getSelectedIndex();
            if (selected >= 0 && selected < this.explosions.size()) {
                this.explosions.remove(selected);
                this.updateExplosionList();
            }
        });
        this.addWidget(removeBtn);
        ButtonWidget saveBtn = new ButtonWidget("save", centerX - 105, this.field_22790 - 35, 100, 20, "Apply", -13996502, -13004999, -1);
        saveBtn.setOnPress(() -> {
            this.saveFireworks();
            this.method_25419();
        });
        this.addWidget(saveBtn);
        ButtonWidget cancelBtn = new ButtonWidget("cancel", centerX + 5, this.field_22790 - 35, 100, 20, "Cancel", -9737365, -7697782, -1);
        cancelBtn.setOnPress(this::method_25419);
        this.addWidget(cancelBtn);
    }

    private void updateExplosionList() {
        this.explosionList.clearItems();
        for (int i = 0; i < this.explosions.size(); ++i) {
            class_9283 explosion = this.explosions.get(i);
            String shape = explosion.comp_2386().toString();
            String colors = explosion.comp_2387().size() + " colors";
            this.explosionList.addItem("Explosion " + (i + 1) + ": " + shape + ", " + colors);
        }
    }

    private void saveFireworks() {
        int duration = 1;
        try {
            duration = Integer.parseInt(this.flightDurationInput.getValue());
            duration = Math.max(1, Math.min(3, duration));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        class_9284 fireworks = new class_9284(duration, this.explosions);
        if (this.onSave != null) {
            this.onSave.accept(fireworks);
        }
    }
}

