/*
 * Decompiled with CFR 0.152.
 */
package net.jackson.simplegui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jackson.simplegui.ArmorTrimEditorGui;
import net.jackson.simplegui.AttributeModifierEditorGui;
import net.jackson.simplegui.BannerPatternsEditorGui;
import net.jackson.simplegui.BaseColorEditorGui;
import net.jackson.simplegui.BlockListEditorGui;
import net.jackson.simplegui.ConsumableEditorGui;
import net.jackson.simplegui.ContainerEditorGui;
import net.jackson.simplegui.DyedColorEditorGui;
import net.jackson.simplegui.EnchantmentEditorGui;
import net.jackson.simplegui.FoodPropertiesEditorGui;
import net.jackson.simplegui.InstrumentEditorGui;
import net.jackson.simplegui.ItemListEditorGui;
import net.jackson.simplegui.ItemSelectorGui;
import net.jackson.simplegui.JukeboxPlayableEditorGui;
import net.jackson.simplegui.LockEditorGui;
import net.jackson.simplegui.LodestoneTrackerEditorGui;
import net.jackson.simplegui.NoteBlockSoundEditorGui;
import net.jackson.simplegui.PotDecorationsEditorGui;
import net.jackson.simplegui.PotionContentsEditorGui;
import net.jackson.simplegui.SimpleGuiScreen;
import net.jackson.simplegui.SuspiciousStewEditorGui;
import net.jackson.simplegui.ToolPropertiesEditorGui;
import net.jackson.simplegui.UseCooldownEditorGui;
import net.jackson.simplegui.widget.ButtonWidget;
import net.jackson.simplegui.widget.GuiWidget;
import net.jackson.simplegui.widget.LabelWidget;
import net.jackson.simplegui.widget.ScrollMenuWidget;
import net.jackson.simplegui.widget.SearchableDropdownWidget;
import net.jackson.simplegui.widget.TextBoxWidget;
import net.minecraft.class_10124;
import net.minecraft.class_10129;
import net.minecraft.class_10130;
import net.minecraft.class_10131;
import net.minecraft.class_10192;
import net.minecraft.class_10215;
import net.minecraft.class_10216;
import net.minecraft.class_124;
import net.minecraft.class_1273;
import net.minecraft.class_1304;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_1844;
import net.minecraft.class_1890;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2873;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3902;
import net.minecraft.class_4174;
import net.minecraft.class_437;
import net.minecraft.class_4482;
import net.minecraft.class_4550;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6538;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7444;
import net.minecraft.class_746;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8053;
import net.minecraft.class_8526;
import net.minecraft.class_9276;
import net.minecraft.class_9279;
import net.minecraft.class_9280;
import net.minecraft.class_9282;
import net.minecraft.class_9285;
import net.minecraft.class_9288;
import net.minecraft.class_9290;
import net.minecraft.class_9291;
import net.minecraft.class_9298;
import net.minecraft.class_9300;
import net.minecraft.class_9304;
import net.minecraft.class_9307;
import net.minecraft.class_9334;
import net.minecraft.class_9424;
import net.minecraft.class_9792;
import net.minecraft.class_9889;
import net.minecraft.class_9890;

@Environment(value=EnvType.CLIENT)
public class ItemEditorGui
extends SimpleGuiScreen {
    private final Map<String, CategoryPanel> categoryPanels = new HashMap<String, CategoryPanel>();
    private int selectedCategoryIndex = 0;
    private static final String[] CATEGORIES = new String[]{"Basic", "Display", "Enchantments", "Restrictions", "Combat", "Consumable", "Container", "Special", "Block Data"};
    private static final Set<String> HANDLED_COMPONENT_IDS = Set.of("max_stack_size", "max_damage", "damage", "custom_name", "item_name", "custom_model_data", "repair_cost", "ominous_bottle_amplifier", "item_model", "tooltip_style", "enchantable", "damage_resistant", "lock", "unbreakable", "hide_tooltip", "hide_additional_tooltip", "creative_slot_lock", "enchantment_glint_override", "intangible_projectile", "glider", "death_protection", "rarity", "equippable", "enchantments", "stored_enchantments", "attribute_modifiers", "dyed_color", "food", "potion_contents", "use_remainder", "trim", "consumable", "jukebox_playable", "tool", "repairable", "suspicious_stew_effects", "instrument", "note_block_sound", "base_color", "use_cooldown", "lodestone_tracker", "pot_decorations", "banner_patterns", "bees", "lore", "can_place_on", "can_break");

    public ItemEditorGui(class_437 parent) {
        super("Item Editor", parent);
    }

    @Override
    protected void method_25426() {
        boolean widgetsExist;
        super.method_25426();
        boolean bl = widgetsExist = this.getWidget("title") != null;
        if (!widgetsExist) {
            this.closeAllOverlays();
            int centerX = this.field_22789 / 2;
            int leftPanelWidth = 120;
            int rightPanelX = 10 + leftPanelWidth + 10;
            int rightPanelWidth = this.field_22789 - rightPanelX - 10;
            LabelWidget title = new LabelWidget("title", centerX, 10, "\u00a76\u00a7lItem Editor", -1, true, true);
            this.addWidget(title);
            ScrollMenuWidget categoryMenu = new ScrollMenuWidget("category_menu", 10, 30, leftPanelWidth, this.field_22790 - 70, -15066598, -14013910, -12632257, -1, -10461088);
            categoryMenu.setItemHeight(24);
            for (String category : CATEGORIES) {
                categoryMenu.addItem(category);
            }
            this.addWidget(categoryMenu);
            this.initializeCategoryPanels(rightPanelX, 30, rightPanelWidth, this.field_22790 - 110);
            this.loadExistingItemData();
            ButtonWidget applyBtn = new ButtonWidget("apply", centerX - 105, this.field_22790 - 35, 100, 20, "Apply Changes", -13996502, -13004999, -1);
            applyBtn.setOnPress(this::applyChanges);
            this.addWidget(applyBtn);
            ButtonWidget closeBtn = new ButtonWidget("close", centerX + 5, this.field_22790 - 35, 100, 20, "Close", -9737365, -7697782, -1);
            closeBtn.setOnPress(this::method_25419);
            this.addWidget(closeBtn);
            int index = this.selectedCategoryIndex >= 0 && this.selectedCategoryIndex < CATEGORIES.length ? this.selectedCategoryIndex : 0;
            this.switchCategory(index);
        }
        this.repositionWidgets();
    }

    private void repositionWidgets() {
        ButtonWidget closeBtn;
        ScrollMenuWidget categoryMenu;
        int centerX = this.field_22789 / 2;
        int leftPanelWidth = 120;
        int rightPanelX = 10 + leftPanelWidth + 10;
        int rightPanelWidth = this.field_22789 - rightPanelX - 10;
        LabelWidget title = (LabelWidget)this.getWidget("title");
        if (title != null) {
            title.setPosition(centerX, 10);
        }
        if ((categoryMenu = (ScrollMenuWidget)this.getWidget("category_menu")) != null) {
            categoryMenu.setPosition(10, 30);
            categoryMenu.setHeight(this.field_22790 - 70);
        }
        for (CategoryPanel panel : this.categoryPanels.values()) {
            panel.repositionWidgets(rightPanelX, 30, rightPanelWidth, this.field_22790 - 110);
        }
        ButtonWidget applyBtn = (ButtonWidget)this.getWidget("apply");
        if (applyBtn != null) {
            applyBtn.setPosition(centerX - 105, this.field_22790 - 35);
        }
        if ((closeBtn = (ButtonWidget)this.getWidget("close")) != null) {
            closeBtn.setPosition(centerX + 5, this.field_22790 - 35);
        }
    }

    private void initializeCategoryPanels(int x, int y, int width, int height) {
        CategoryPanel basic = new CategoryPanel("Basic", x, y, width, height);
        basic.addTextField("max_stack_size", "Max Stack Size", "64", 2);
        basic.addTextField("max_damage", "Max Damage", "0", 10);
        basic.addTextField("damage", "Damage", "0", 10);
        basic.addCheckbox("unbreakable", "Unbreakable", false);
        basic.addTextField("custom_model_data", "Custom Model Data", "0", 9);
        basic.addTextField("repair_cost", "Repair Cost", "0", 6);
        this.categoryPanels.put("Basic", basic);
        CategoryPanel display = new CategoryPanel("Display", x, y, width, height);
        display.addTextField("custom_name", "Custom Name", "", 64);
        display.addTextField("item_name", "Item Name", "", 64);
        display.addTextField("item_model", "Item Model (ResourceLocation)", "", 128);
        display.addTextArea("lore", "Lore (one line per entry)", 5);
        display.addDropdown("rarity", "Rarity", new String[]{"common", "uncommon", "rare", "epic"}, 0);
        display.addCheckbox("hide_tooltip", "Hide Tooltip", false);
        display.addCheckbox("hide_additional_tooltip", "Hide Additional Tooltip", false);
        display.addCheckbox("enchantment_glint_override", "Enchantment Glint Override", false);
        display.addTextField("tooltip_style", "Tooltip Style (ResourceLocation)", "", 128);
        this.categoryPanels.put("Display", display);
        CategoryPanel enchantments = new CategoryPanel("Enchantments", x, y, width, height);
        enchantments.addEnchantmentList("enchantments", "Enchantments");
        enchantments.addEnchantmentList("stored_enchantments", "Stored Enchantments");
        enchantments.addTextField("enchantable", "Enchantability Value", "0", 6);
        this.categoryPanels.put("Enchantments", enchantments);
        CategoryPanel restrictions = new CategoryPanel("Restrictions", x, y, width, height);
        restrictions.addButtonEditor("can_place_on", "Can Place On Blocks", "Edit Blocks...");
        restrictions.addButtonEditor("can_break", "Can Break Blocks", "Edit Blocks...");
        restrictions.addCheckbox("creative_slot_lock", "Creative Slot Lock", false);
        restrictions.addCheckbox("intangible_projectile", "Intangible Projectile", false);
        this.categoryPanels.put("Restrictions", restrictions);
        CategoryPanel combat = new CategoryPanel("Combat", x, y, width, height);
        combat.addAttributeModifierList("attribute_modifiers", "Attribute Modifiers");
        combat.addButtonEditor("tool", "Tool Properties", "Edit Tool...");
        combat.addDamageTypeDropdown("damage_resistant", "Damage Resistant Type");
        combat.addCheckbox("death_protection", "Death Protection", false);
        this.categoryPanels.put("Combat", combat);
        CategoryPanel consumable = new CategoryPanel("Consumable", x, y, width, height);
        consumable.addButtonEditor("food", "Food Properties", "Edit Food...");
        consumable.addButtonEditor("potion_contents", "Potion Contents", "Edit Potion...");
        consumable.addButtonEditor("use_remainder", "Use Remainder Item", "Select Item...");
        consumable.addButtonEditor("consumable", "Consumable Properties", "Edit Consumable...");
        consumable.addButtonEditor("use_cooldown", "Use Cooldown", "Edit Cooldown...");
        consumable.addButtonEditor("suspicious_stew_effects", "Suspicious Stew Effects", "Edit Effects...");
        consumable.addConditionalField("ominous_bottle_amplifier", "Ominous Bottle Amplifier", "0", 3);
        this.categoryPanels.put("Consumable", consumable);
        CategoryPanel container = new CategoryPanel("Container", x, y, width, height);
        container.addButtonEditor("container", "Container Contents", "Edit Container...");
        container.addButtonEditor("bundle_contents", "Bundle Contents", "Edit Bundle...");
        this.categoryPanels.put("Container", container);
        CategoryPanel special = new CategoryPanel("Special", x, y, width, height);
        special.addDropdown("equippable", "Equippable Slot", new String[]{"none", "head", "chest", "legs", "feet", "body", "mainhand", "offhand"}, 0);
        special.addButtonEditor("repairable", "Repairable Items", "Edit Items...");
        special.addCheckbox("glider", "Glider", false);
        special.addButtonEditor("dyed_color", "Dyed Color", "Edit Color...");
        special.addButtonEditor("trim", "Armor Trim", "Edit Trim...");
        special.addButtonEditor("instrument", "Instrument", "Select Instrument...");
        special.addButtonEditor("jukebox_playable", "Jukebox Playable", "Edit Music...");
        special.addTextField("recipes", "Recipes (JSON)", "", 256);
        special.addButtonEditor("lodestone_tracker", "Lodestone Tracker", "Edit Tracker...");
        this.categoryPanels.put("Special", special);
        CategoryPanel blockData = new CategoryPanel("Block Data", x, y, width, height);
        blockData.addButtonEditor("note_block_sound", "Note Block Sound", "Select Sound...");
        blockData.addButtonEditor("base_color", "Base Color", "Select Color...");
        blockData.addConditionalButtonEditor("pot_decorations", "Pot Decorations", "Edit Decorations...", "decorated_pot");
        blockData.addConditionalButtonEditor("banner_patterns", "Banner Patterns", "Edit Patterns...", "banner");
        blockData.addConditionalButtonEditor("lock", "Lock", "Edit Lock...", "lockable");
        blockData.addConditionalIntField("bees", "Number of Bees", "0", "beehive");
        this.categoryPanels.put("Block Data", blockData);
        for (CategoryPanel panel : this.categoryPanels.values()) {
            panel.createWidgets(this);
        }
    }

    private void switchCategory(int index) {
        CategoryPanel panel2;
        if (index < 0 || index >= CATEGORIES.length) {
            return;
        }
        for (CategoryPanel panel2 : this.categoryPanels.values()) {
            panel2.setVisible(false);
        }
        String categoryName = CATEGORIES[index];
        panel2 = this.categoryPanels.get(categoryName);
        if (panel2 != null) {
            panel2.setVisible(true);
            this.selectedCategoryIndex = index;
        }
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        ScrollMenuWidget categoryMenu = (ScrollMenuWidget)this.getWidget("category_menu");
        if (categoryMenu != null && button == 0) {
            int oldIndex = categoryMenu.getSelectedIndex();
            boolean handled = super.method_25402(mouseX, mouseY, button);
            int newIndex = categoryMenu.getSelectedIndex();
            if (newIndex != oldIndex && newIndex >= 0) {
                this.switchCategory(newIndex);
            }
            return handled;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private void loadExistingItemData() {
        if (this.field_22787 == null || this.field_22787.field_1724 == null) {
            return;
        }
        class_1799 stack = this.field_22787.field_1724.method_6047();
        if (stack.method_7960()) {
            return;
        }
        for (CategoryPanel panel : this.categoryPanels.values()) {
            panel.loadFromItemStack(stack);
        }
    }

    private void applyChanges() {
        class_746 player = this.field_22787.field_1724;
        if (player == null) {
            return;
        }
        if (!player.method_31549().field_7477) {
            player.method_7353((class_2561)class_2561.method_43470((String)"You must be in creative mode!").method_27692(class_124.field_1061), false);
            return;
        }
        class_1799 mainHandStack = player.method_6047();
        if (mainHandStack.method_7960()) {
            player.method_7353((class_2561)class_2561.method_43470((String)"You must hold an item!").method_27692(class_124.field_1061), false);
            return;
        }
        class_1799 newStack = mainHandStack.method_7972();
        for (CategoryPanel panel : this.categoryPanels.values()) {
            panel.applyToItemStack(newStack, player);
        }
        int slot = 36 + player.method_31548().field_7545;
        player.field_3944.method_52787((class_2596)new class_2873(slot, newStack));
        player.method_31548().method_5447(player.method_31548().field_7545, newStack);
        this.closeAllOverlays();
        player.method_7353((class_2561)class_2561.method_43470((String)"Item updated successfully!").method_27692(class_124.field_1060), false);
    }

    private void warnForUnimplementedComponents(class_746 player) {
        ArrayList<String> missing = new ArrayList<String>();
        for (Map.Entry<String, CategoryPanel> entry : this.categoryPanels.entrySet()) {
            CategoryPanel panel = entry.getValue();
            for (String key : panel.editors.keySet()) {
                if (HANDLED_COMPONENT_IDS.contains(key)) continue;
                missing.add(key);
            }
        }
        if (!missing.isEmpty()) {
            int show = Math.min(6, missing.size());
            String list = String.join((CharSequence)", ", missing.subList(0, show));
            String suffix = missing.size() > show ? " and +" + (missing.size() - show) + " more" : "";
            player.method_7353((class_2561)class_2561.method_43470((String)("Note: components not yet implemented: " + list + suffix)).method_27692(class_124.field_1054), false);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class CategoryPanel {
        private final String name;
        private final int x;
        private final int y;
        private final int width;
        private final int height;
        private final Map<String, ComponentEditor> editors = new LinkedHashMap<String, ComponentEditor>();
        private ScrollMenuWidget scrollWidget;
        private boolean visible = false;

        public CategoryPanel(String name, int x, int y, int width, int height) {
            this.name = name;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public void addTextField(String id, String label, String defaultValue, int maxLength) {
            this.editors.put(id, new TextFieldEditor(label, defaultValue, maxLength));
        }

        public void addTextArea(String id, String label, int lines) {
            this.editors.put(id, new TextAreaEditor(label, lines));
        }

        public void addCheckbox(String id, String label, boolean defaultValue) {
            this.editors.put(id, new CheckboxEditor(label, defaultValue));
        }

        public void addDropdown(String id, String label, String[] options, int defaultIndex) {
            this.editors.put(id, new DropdownEditor(label, options, defaultIndex));
        }

        public void addEnchantmentList(String id, String label) {
            this.editors.put(id, new EnchantmentListEditor(label));
        }

        public void addAttributeModifierList(String id, String label) {
            this.editors.put(id, new AttributeModifierListEditor(label));
        }

        public void addButtonEditor(String id, String label, String buttonText) {
            this.editors.put(id, new ButtonEditor(label, buttonText));
        }

        public void addDamageTypeDropdown(String id, String label) {
            this.editors.put(id, new DamageTypeDropdownEditor(label));
        }

        public void addConditionalField(String id, String label, String defaultValue, int maxLength) {
            this.editors.put(id, new ConditionalTextFieldEditor(label, defaultValue, maxLength));
        }

        public void addConditionalButtonEditor(String id, String label, String buttonText, String itemType) {
            this.editors.put(id, new ConditionalButtonEditor(label, buttonText, itemType));
        }

        public void addConditionalIntField(String id, String label, String defaultValue, String itemType) {
            this.editors.put(id, new ConditionalIntFieldEditor(label, defaultValue, itemType));
        }

        public void createWidgets(SimpleGuiScreen screen) {
            int yOffset = this.y + 5;
            int contentHeight = 0;
            for (ComponentEditor componentEditor : this.editors.values()) {
                contentHeight += componentEditor.getHeight() + 5;
            }
            if (contentHeight > this.height - 10) {
                this.scrollWidget = new ScrollMenuWidget(this.name + "_scroll", this.x, this.y, this.width, this.height);
                this.scrollWidget.setVisible(this.visible);
            }
            for (Map.Entry entry : this.editors.entrySet()) {
                String id = this.name + "_" + (String)entry.getKey();
                ComponentEditor editor = (ComponentEditor)entry.getValue();
                if (editor instanceof EnchantmentListEditor) {
                    EnchantmentListEditor enchEditor = (EnchantmentListEditor)editor;
                    enchEditor.setParentScreen(screen);
                } else if (editor instanceof AttributeModifierListEditor) {
                    AttributeModifierListEditor attrEditor = (AttributeModifierListEditor)editor;
                    attrEditor.setParentScreen(screen);
                } else if (editor instanceof ButtonEditor) {
                    ButtonEditor btnEditor = (ButtonEditor)editor;
                    btnEditor.setParentScreen(screen);
                } else if (editor instanceof ConditionalButtonEditor) {
                    ConditionalButtonEditor condBtnEditor = (ConditionalButtonEditor)editor;
                    condBtnEditor.setParentScreen(screen);
                }
                LabelWidget label = new LabelWidget(id + "_label", this.x + 5, yOffset, editor.getLabel(), -5592406, false, false);
                label.setVisible(this.visible);
                screen.addWidget(label);
                editor.setLabelWidget(label);
                GuiWidget inputWidget = editor.createWidget(id, this.x + 5, yOffset += 18, this.width - 15);
                inputWidget.setVisible(this.visible);
                screen.addWidget(inputWidget);
                editor.setInputWidget(inputWidget);
                yOffset += editor.getHeight() - 10;
            }
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
            for (ComponentEditor editor : this.editors.values()) {
                editor.setVisible(visible);
            }
            if (this.scrollWidget != null) {
                this.scrollWidget.setVisible(visible);
            }
        }

        public void repositionWidgets(int newX, int newY, int newWidth, int newHeight) {
            int yOffset = newY + 5;
            for (Map.Entry<String, ComponentEditor> entry : this.editors.entrySet()) {
                ComponentEditor editor = entry.getValue();
                if (editor.labelWidget != null) {
                    editor.labelWidget.setPosition(newX + 5, yOffset + 8);
                }
                yOffset += 20;
                if (editor.inputWidget != null) {
                    editor.inputWidget.setPosition(newX + 5, yOffset);
                    if (editor.getOriginalWidth() > 0) {
                        editor.inputWidget.setWidth(editor.getOriginalWidth());
                    }
                }
                yOffset += editor.getHeight() - 10;
            }
            if (this.scrollWidget != null) {
                this.scrollWidget.setPosition(newX, newY);
                this.scrollWidget.setWidth(newWidth);
                this.scrollWidget.setHeight(newHeight);
            }
        }

        public void loadFromItemStack(class_1799 stack) {
            for (Map.Entry<String, ComponentEditor> entry : this.editors.entrySet()) {
                String componentName = entry.getKey();
                ComponentEditor editor = entry.getValue();
                editor.loadFromItemStack(stack, componentName);
            }
        }

        public void applyToItemStack(class_1799 stack, class_746 player) {
            for (Map.Entry<String, ComponentEditor> entry : this.editors.entrySet()) {
                String componentName = entry.getKey();
                ComponentEditor editor = entry.getValue();
                try {
                    editor.applyToItemStack(stack, componentName, player);
                }
                catch (Exception e) {
                    player.method_7353((class_2561)class_2561.method_43470((String)("Error applying " + componentName + ": " + e.getMessage())).method_27692(class_124.field_1054), false);
                }
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class ConditionalIntFieldEditor
    extends ComponentEditor {
        private final String defaultValue;
        private final String itemType;

        public ConditionalIntFieldEditor(String label, String defaultValue, String itemType) {
            super(label);
            this.defaultValue = defaultValue;
            this.itemType = itemType;
        }

        @Override
        public GuiWidget createWidget(String id, int x, int y, int width) {
            TextBoxWidget textBox = new TextBoxWidget(id, x, y, 100, 20, -14671840, -8355712, -1, -10461088);
            textBox.setValue(this.defaultValue);
            textBox.setMaxLength(2);
            textBox.setHint("0-3");
            return textBox;
        }

        @Override
        public int getHeight() {
            return 25;
        }

        private boolean isItemTypeMatch(class_1799 stack) {
            if (stack.method_7960()) {
                return false;
            }
            String itemId = class_7923.field_41178.method_10221((Object)stack.method_7909()).toString();
            return itemId.contains("beehive") || itemId.contains("bee_nest");
        }

        @Override
        public void applyToItemStack(class_1799 stack, String componentName, class_746 player) {
            GuiWidget guiWidget = this.inputWidget;
            if (!(guiWidget instanceof TextBoxWidget)) {
                return;
            }
            TextBoxWidget textBox = (TextBoxWidget)guiWidget;
            String value = textBox.getValue().trim();
            if (componentName.equals("bees")) {
                try {
                    int beeCount = Integer.parseInt(value);
                    if (beeCount < 0 || beeCount > 3) {
                        player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cBee count must be 0-3!").method_27692(class_124.field_1054), false);
                        return;
                    }
                    ArrayList<class_4482.class_9309> bees = new ArrayList<class_4482.class_9309>();
                    for (int i = 0; i < beeCount; ++i) {
                        class_2487 beeData = new class_2487();
                        beeData.method_10582("id", "minecraft:bee");
                        class_9279 customData = class_9279.method_57456((class_2487)beeData);
                        class_4482.class_9309 occupant = new class_4482.class_9309(customData, 0, 600);
                        bees.add(occupant);
                    }
                    if (bees.isEmpty()) {
                        stack.method_57381(class_9334.field_49624);
                    } else {
                        stack.method_57379(class_9334.field_49624, bees);
                    }
                }
                catch (NumberFormatException e) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cInvalid number!").method_27692(class_124.field_1061), false);
                }
            }
        }

        @Override
        public void loadFromItemStack(class_1799 stack, String componentName) {
            GuiWidget guiWidget = this.inputWidget;
            if (!(guiWidget instanceof TextBoxWidget)) {
                return;
            }
            TextBoxWidget textBox = (TextBoxWidget)guiWidget;
            if (componentName.equals("bees")) {
                if (stack.method_57826(class_9334.field_49624)) {
                    List bees = (List)stack.method_57824(class_9334.field_49624);
                    if (bees != null) {
                        textBox.setValue(String.valueOf(bees.size()));
                    }
                } else {
                    textBox.setValue("0");
                }
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class ConditionalButtonEditor
    extends ComponentEditor {
        private SimpleGuiScreen parentScreen;
        private Object storedValue;
        private final String buttonText;
        private final String itemType;

        public ConditionalButtonEditor(String label, String buttonText, String itemType) {
            super(label);
            this.buttonText = buttonText;
            this.itemType = itemType;
        }

        public void setParentScreen(SimpleGuiScreen screen) {
            this.parentScreen = screen;
        }

        @Override
        public GuiWidget createWidget(String id, int x, int y, int width) {
            ButtonWidget button = new ButtonWidget(id, x, y, 150, 20, this.buttonText, -12961170, -11908465, -1);
            button.setOnPress(() -> {
                if (this.parentScreen != null) {
                    this.parentScreen.closeAllOverlays();
                    this.openEditor(id);
                }
            });
            return button;
        }

        private boolean isItemTypeMatch(class_1799 stack) {
            if (stack.method_7960()) {
                return false;
            }
            String itemId = class_7923.field_41178.method_10221((Object)stack.method_7909()).toString();
            return switch (this.itemType) {
                case "decorated_pot" -> itemId.contains("decorated_pot");
                case "banner" -> {
                    if (itemId.contains("banner") && !itemId.contains("pattern")) {
                        yield true;
                    }
                    yield false;
                }
                case "lockable" -> {
                    if (itemId.contains("chest") || itemId.contains("shulker_box") || itemId.contains("barrel") || itemId.contains("hopper") || itemId.contains("dispenser") || itemId.contains("dropper")) {
                        yield true;
                    }
                    yield false;
                }
                case "beehive" -> {
                    if (itemId.contains("beehive") || itemId.contains("bee_nest")) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }

        private void openEditor(String componentName) {
            class_746 player = this.parentScreen.getPlayer();
            class_310 mc = this.parentScreen.getMinecraft();
            if (player == null || mc == null) {
                return;
            }
            class_1799 stack = player.method_6047();
            if (stack.method_7960()) {
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cHold an item to edit!").method_27692(class_124.field_1061), false);
                return;
            }
            String actualComponent = componentName;
            int firstUnderscore = componentName.indexOf(95);
            if (firstUnderscore > 0 && firstUnderscore < componentName.length() - 1) {
                actualComponent = componentName.substring(firstUnderscore + 1);
            }
            switch (actualComponent) {
                case "pot_decorations": {
                    class_8526 current = (class_8526)stack.method_57824(class_9334.field_49621);
                    mc.method_1507((class_437)new PotDecorationsEditorGui(this.parentScreen, current, decorations -> {
                        this.storedValue = decorations;
                        class_1799 preview = stack.method_7972();
                        preview.method_57379(class_9334.field_49621, decorations);
                        player.method_31548().method_5447(player.method_31548().field_7545, preview);
                    }));
                    break;
                }
                case "banner_patterns": {
                    class_9307 current = (class_9307)stack.method_57824(class_9334.field_49619);
                    mc.method_1507((class_437)new BannerPatternsEditorGui(this.parentScreen, stack, current, patterns -> {
                        this.storedValue = patterns;
                        class_1799 preview = stack.method_7972();
                        preview.method_57379(class_9334.field_49619, patterns);
                        player.method_31548().method_5447(player.method_31548().field_7545, preview);
                    }));
                    break;
                }
                case "lock": {
                    class_1273 current = (class_1273)stack.method_57824(class_9334.field_49625);
                    mc.method_1507((class_437)new LockEditorGui(this.parentScreen, current, lock -> {
                        this.storedValue = lock;
                        class_1799 preview = stack.method_7972();
                        preview.method_57379(class_9334.field_49625, lock);
                        player.method_31548().method_5447(player.method_31548().field_7545, preview);
                    }));
                }
            }
        }

        @Override
        public int getHeight() {
            return 25;
        }

        @Override
        public void applyToItemStack(class_1799 stack, String componentName, class_746 player) {
            if (this.storedValue == null) {
                switch (componentName) {
                    case "pot_decorations": {
                        this.storedValue = stack.method_57824(class_9334.field_49621);
                        break;
                    }
                    case "banner_patterns": {
                        this.storedValue = stack.method_57824(class_9334.field_49619);
                        break;
                    }
                    case "lock": {
                        this.storedValue = stack.method_57824(class_9334.field_49625);
                    }
                }
            }
            if (this.storedValue == null) {
                return;
            }
            switch (componentName) {
                case "pot_decorations": {
                    Object object = this.storedValue;
                    if (!(object instanceof class_8526)) break;
                    class_8526 decorations = (class_8526)object;
                    stack.method_57379(class_9334.field_49621, (Object)decorations);
                    break;
                }
                case "banner_patterns": {
                    Object object = this.storedValue;
                    if (!(object instanceof class_9307)) break;
                    class_9307 patterns = (class_9307)object;
                    stack.method_57379(class_9334.field_49619, (Object)patterns);
                    break;
                }
                case "lock": {
                    Object object = this.storedValue;
                    if (!(object instanceof class_1273)) break;
                    class_1273 lockCode = (class_1273)object;
                    stack.method_57379(class_9334.field_49625, (Object)lockCode);
                }
            }
        }

        @Override
        public void loadFromItemStack(class_1799 stack, String componentName) {
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class ConditionalTextFieldEditor
    extends ComponentEditor {
        private final String defaultValue;
        private final int maxLength;

        public ConditionalTextFieldEditor(String label, String defaultValue, int maxLength) {
            super(label);
            this.defaultValue = defaultValue;
            this.maxLength = maxLength;
        }

        @Override
        public GuiWidget createWidget(String id, int x, int y, int width) {
            TextBoxWidget textBox = new TextBoxWidget(id, x, y, width, 20, -14671840, -8355712, -1, -10461088);
            textBox.setValue(this.defaultValue);
            textBox.setMaxLength(this.maxLength);
            textBox.setHint("Only for Ominous Bottles");
            return textBox;
        }

        @Override
        public int getHeight() {
            return 25;
        }

        @Override
        public void applyToItemStack(class_1799 stack, String componentName, class_746 player) {
            if (stack.method_7909() != class_1802.field_50140) {
                return;
            }
            GuiWidget guiWidget = this.inputWidget;
            if (!(guiWidget instanceof TextBoxWidget)) {
                return;
            }
            TextBoxWidget textBox = (TextBoxWidget)guiWidget;
            String value = textBox.getValue().trim();
            if (componentName.equals("ominous_bottle_amplifier")) {
                try {
                    int amplifier = Integer.parseInt(value);
                    if (amplifier >= 0) {
                        stack.method_57379(class_9334.field_50238, (Object)new class_10129(amplifier));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void loadFromItemStack(class_1799 stack, String componentName) {
            class_10129 amplifier;
            if (stack.method_7909() != class_1802.field_50140) {
                super.setVisible(false);
                return;
            }
            GuiWidget guiWidget = this.inputWidget;
            if (!(guiWidget instanceof TextBoxWidget)) {
                return;
            }
            TextBoxWidget textBox = (TextBoxWidget)guiWidget;
            if (componentName.equals("ominous_bottle_amplifier") && stack.method_57826(class_9334.field_50238) && (amplifier = (class_10129)stack.method_57824(class_9334.field_50238)) != null) {
                textBox.setValue(String.valueOf(amplifier.comp_3090()));
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class DamageTypeDropdownEditor
    extends ComponentEditor {
        private final List<String> damageTypes = new ArrayList<String>();

        public DamageTypeDropdownEditor(String label) {
            super(label);
            this.damageTypes.add("none");
            this.damageTypes.add("is_fire");
            this.damageTypes.add("is_explosion");
            this.damageTypes.add("is_fall");
            this.damageTypes.add("is_drowning");
            this.damageTypes.add("is_freezing");
            this.damageTypes.add("is_lightning");
            this.damageTypes.add("is_projectile");
            this.damageTypes.add("bypasses_armor");
            this.damageTypes.add("bypasses_invulnerability");
            this.damageTypes.add("bypasses_magic");
            this.damageTypes.add("bypasses_enchantments");
            this.damageTypes.add("bypasses_resistance");
            this.damageTypes.add("bypasses_shield");
            this.damageTypes.add("witch_resistant_to");
            this.damageTypes.add("wither_immune_to");
        }

        @Override
        public GuiWidget createWidget(String id, int x, int y, int width) {
            SearchableDropdownWidget dropdown = new SearchableDropdownWidget(id, x, y, Math.min(width, 250), 20);
            for (String type : this.damageTypes) {
                dropdown.addOption(type);
            }
            dropdown.setSelectedIndex(0);
            return dropdown;
        }

        @Override
        public int getHeight() {
            return 25;
        }

        @Override
        public void applyToItemStack(class_1799 stack, String componentName, class_746 player) {
            GuiWidget guiWidget = this.inputWidget;
            if (!(guiWidget instanceof SearchableDropdownWidget)) {
                return;
            }
            SearchableDropdownWidget dropdown = (SearchableDropdownWidget)guiWidget;
            String selected = dropdown.getSelectedOption();
            if (selected.equals("none")) {
                stack.method_57381(class_9334.field_54273);
            } else {
                try {
                    class_2960 rl = class_2960.method_60656((String)selected);
                    class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_42534, (class_2960)rl);
                    stack.method_57379(class_9334.field_54273, (Object)new class_10215(tag));
                }
                catch (Exception e) {
                    player.method_7353((class_2561)class_2561.method_43470((String)("Error setting damage resistant: " + e.getMessage())).method_27692(class_124.field_1054), false);
                }
            }
        }

        @Override
        public void loadFromItemStack(class_1799 stack, String componentName) {
            GuiWidget guiWidget = this.inputWidget;
            if (!(guiWidget instanceof SearchableDropdownWidget)) {
                return;
            }
            SearchableDropdownWidget dropdown = (SearchableDropdownWidget)guiWidget;
            if (stack.method_57826(class_9334.field_54273)) {
                String tagName;
                int index;
                class_10215 dr = (class_10215)stack.method_57824(class_9334.field_54273);
                if (dr != null && (index = this.damageTypes.indexOf(tagName = dr.comp_3210().comp_327().method_12832())) >= 0) {
                    dropdown.setSelectedIndex(index);
                }
            } else {
                dropdown.setSelectedIndex(0);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class ButtonEditor
    extends ComponentEditor {
        private SimpleGuiScreen parentScreen;
        private Object storedValue;
        private final String buttonText;

        public ButtonEditor(String label, String buttonText) {
            super(label);
            this.buttonText = buttonText;
        }

        public void setParentScreen(SimpleGuiScreen screen) {
            this.parentScreen = screen;
        }

        @Override
        public GuiWidget createWidget(String id, int x, int y, int width) {
            ButtonWidget button = new ButtonWidget(id, x, y, 150, 20, this.buttonText, -12961170, -11908465, -1);
            button.setOnPress(() -> {
                if (this.parentScreen != null) {
                    this.parentScreen.closeAllOverlays();
                    this.openEditor(id);
                }
            });
            return button;
        }

        private void openEditor(String componentName) {
            String actualComponent;
            class_746 player = this.parentScreen.getPlayer();
            class_310 mc = this.parentScreen.getMinecraft();
            if (player == null || mc == null) {
                return;
            }
            class_1799 stack = player.method_6047();
            if (stack.method_7960()) {
                return;
            }
            switch (actualComponent = componentName.contains("_") ? componentName.substring(componentName.indexOf(95) + 1) : componentName) {
                case "can_place_on": {
                    ArrayList<class_2248> existingBlocks = new ArrayList<class_2248>();
                    if (stack.method_57826(class_9334.field_49634)) {
                        class_6538 class_65382 = (class_6538)stack.method_57824(class_9334.field_49634);
                    }
                    mc.method_1507((class_437)new BlockListEditorGui(this.parentScreen, "Can Place On Blocks", existingBlocks, blocks -> {
                        this.storedValue = blocks;
                        this.updateCanPlaceOnPreview(player, stack, (List<class_2248>)blocks);
                    }));
                    break;
                }
                case "can_break": {
                    ArrayList<class_2248> existingBlocks = new ArrayList<class_2248>();
                    if (stack.method_57826(class_9334.field_49635)) {
                        class_6538 class_65383 = (class_6538)stack.method_57824(class_9334.field_49635);
                    }
                    mc.method_1507((class_437)new BlockListEditorGui(this.parentScreen, "Can Break Blocks", existingBlocks, blocks -> {
                        this.storedValue = blocks;
                        this.updateCanBreakPreview(player, stack, (List<class_2248>)blocks);
                    }));
                    break;
                }
                case "dyed_color": {
                    int currentColor = 0xFFFFFF;
                    if (stack.method_57826(class_9334.field_49644)) {
                        currentColor = ((class_9282)stack.method_57824(class_9334.field_49644)).comp_2384();
                    }
                    mc.method_1507((class_437)new DyedColorEditorGui(this.parentScreen, currentColor, color -> {
                        this.storedValue = color;
                        class_1799 preview = stack.method_7972();
                        preview.method_57379(class_9334.field_49644, color);
                        player.method_31548().method_5447(player.method_31548().field_7545, preview);
                    }));
                    break;
                }
                case "food": {
                    class_4174 current = (class_4174)stack.method_57824(class_9334.field_50075);
                    mc.method_1507((class_437)new FoodPropertiesEditorGui(this.parentScreen, current, food -> {
                        this.storedValue = food;
                        class_1799 preview = stack.method_7972();
                        preview.method_57379(class_9334.field_50075, food);
                        player.method_31548().method_5447(player.method_31548().field_7545, preview);
                    }));
                    break;
                }
                case "potion_contents": {
                    class_1844 current = (class_1844)stack.method_57824(class_9334.field_49651);
                    mc.method_1507((class_437)new PotionContentsEditorGui(this.parentScreen, current, potion -> {
                        this.storedValue = potion;
                        class_1799 preview = stack.method_7972();
                        preview.method_57379(class_9334.field_49651, potion);
                        player.method_31548().method_5447(player.method_31548().field_7545, preview);
                    }));
                    break;
                }
                case "use_remainder": {
                    mc.method_1507((class_437)new ItemSelectorGui(this.parentScreen, item -> {
                        this.storedValue = new class_10131(item);
                        class_1799 preview = stack.method_7972();
                        preview.method_57379(class_9334.field_53965, (Object)new class_10131(item));
                        player.method_31548().method_5447(player.method_31548().field_7545, preview);
                    }));
                    break;
                }
                case "trim": {
                    class_8053 current = (class_8053)stack.method_57824(class_9334.field_49607);
                    mc.method_1507((class_437)new ArmorTrimEditorGui(this.parentScreen, current, trim -> {
                        this.storedValue = trim;
                        class_1799 preview = stack.method_7972();
                        preview.method_57379(class_9334.field_49607, trim);
                        player.method_31548().method_5447(player.method_31548().field_7545, preview);
                    }));
                    break;
                }
                case "consumable": {
                    class_10124 current = (class_10124)stack.method_57824(class_9334.field_53964);
                    mc.method_1507((class_437)new ConsumableEditorGui(this.parentScreen, current, consumable -> {
                        this.storedValue = consumable;
                        class_1799 preview = stack.method_7972();
                        preview.method_57379(class_9334.field_53964, consumable);
                        player.method_31548().method_5447(player.method_31548().field_7545, preview);
                    }));
                    break;
                }
                case "jukebox_playable": {
                    class_9792 current = (class_9792)stack.method_57824(class_9334.field_52175);
                    mc.method_1507((class_437)new JukeboxPlayableEditorGui(this.parentScreen, current, playable -> {
                        this.storedValue = playable;
                        class_1799 preview = stack.method_7972();
                        preview.method_57379(class_9334.field_52175, playable);
                        player.method_31548().method_5447(player.method_31548().field_7545, preview);
                    }));
                    break;
                }
                case "tool": {
                    class_9424 current = (class_9424)stack.method_57824(class_9334.field_50077);
                    mc.method_1507((class_437)new ToolPropertiesEditorGui(this.parentScreen, current, tool -> {
                        this.storedValue = tool;
                        class_1799 preview = stack.method_7972();
                        preview.method_57379(class_9334.field_50077, tool);
                        player.method_31548().method_5447(player.method_31548().field_7545, preview);
                    }));
                    break;
                }
                case "suspicious_stew_effects": {
                    class_9298 current = (class_9298)stack.method_57824(class_9334.field_49652);
                    mc.method_1507((class_437)new SuspiciousStewEditorGui(this.parentScreen, current, effects -> {
                        this.storedValue = effects;
                        class_1799 preview = stack.method_7972();
                        preview.method_57379(class_9334.field_49652, effects);
                        player.method_31548().method_5447(player.method_31548().field_7545, preview);
                    }));
                    break;
                }
                case "use_cooldown": {
                    class_10130 current = (class_10130)stack.method_57824(class_9334.field_53966);
                    mc.method_1507((class_437)new UseCooldownEditorGui(this.parentScreen, current, cooldown -> {
                        this.storedValue = cooldown;
                        class_1799 preview = stack.method_7972();
                        preview.method_57379(class_9334.field_53966, cooldown);
                        player.method_31548().method_5447(player.method_31548().field_7545, preview);
                    }));
                    break;
                }
                case "instrument": {
                    class_6880 current = (class_6880)stack.method_57824(class_9334.field_49612);
                    mc.method_1507((class_437)new InstrumentEditorGui(this.parentScreen, (class_6880<class_7444>)current, instrument -> {
                        this.storedValue = instrument;
                        class_1799 preview = stack.method_7972();
                        preview.method_57379(class_9334.field_49612, instrument);
                        player.method_31548().method_5447(player.method_31548().field_7545, preview);
                    }));
                    break;
                }
                case "note_block_sound": {
                    class_2960 current = (class_2960)stack.method_57824(class_9334.field_49618);
                    mc.method_1507((class_437)new NoteBlockSoundEditorGui(this.parentScreen, current, sound -> {
                        this.storedValue = sound;
                        class_1799 preview = stack.method_7972();
                        preview.method_57379(class_9334.field_49618, sound);
                        player.method_31548().method_5447(player.method_31548().field_7545, preview);
                    }));
                    break;
                }
                case "base_color": {
                    class_1767 current = (class_1767)stack.method_57824(class_9334.field_49620);
                    mc.method_1507((class_437)new BaseColorEditorGui(this.parentScreen, current, color -> {
                        this.storedValue = color;
                        class_1799 preview = stack.method_7972();
                        preview.method_57379(class_9334.field_49620, color);
                        player.method_31548().method_5447(player.method_31548().field_7545, preview);
                    }));
                    break;
                }
                case "lodestone_tracker": {
                    class_9291 current = (class_9291)stack.method_57824(class_9334.field_49614);
                    mc.method_1507((class_437)new LodestoneTrackerEditorGui(this.parentScreen, current, tracker -> {
                        this.storedValue = tracker;
                        class_1799 preview = stack.method_7972();
                        preview.method_57379(class_9334.field_49614, tracker);
                        player.method_31548().method_5447(player.method_31548().field_7545, preview);
                    }));
                    break;
                }
                case "container": {
                    class_9288 current = (class_9288)stack.method_57824(class_9334.field_49622);
                    mc.method_1507((class_437)new ContainerEditorGui(this.parentScreen, current, contents -> {
                        this.storedValue = contents;
                        class_1799 preview = stack.method_7972();
                        preview.method_57379(class_9334.field_49622, contents);
                        player.method_31548().method_5447(player.method_31548().field_7545, preview);
                    }));
                    break;
                }
                case "bundle_contents": {
                    class_9276 current = (class_9276)stack.method_57824(class_9334.field_49650);
                    mc.method_1507((class_437)new ContainerEditorGui(this.parentScreen, current != null ? current.method_59707().collect(Collectors.collectingAndThen(Collectors.toList(), list -> class_9288.method_57493((List)list))) : null, contents -> {
                        this.storedValue = contents;
                        class_1799 preview = stack.method_7972();
                        List<class_1799> items = contents.method_57489().filter(s -> !s.method_7960() && s.method_7947() > 0).toList();
                        preview.method_57379(class_9334.field_49650, (Object)new class_9276(items));
                        player.method_31548().method_5447(player.method_31548().field_7545, preview);
                    }));
                    break;
                }
                case "repairable": {
                    ArrayList<class_1792> existingItems = new ArrayList<class_1792>();
                    if (stack.method_57826(class_9334.field_53696)) {
                        // empty if block
                    }
                    mc.method_1507((class_437)new ItemListEditorGui(this.parentScreen, "Repairable Items", existingItems, items -> {
                        this.storedValue = items;
                        this.updateRepairablePreview(player, stack, (List<class_1792>)items);
                    }));
                }
            }
        }

        private void updateCanPlaceOnPreview(class_746 player, class_1799 stack, List<class_2248> blocks) {
            if (blocks == null || blocks.isEmpty()) {
                return;
            }
            try {
                class_1799 preview = stack.method_7972();
                ArrayList<class_4550> predicates = new ArrayList<class_4550>();
                for (class_2248 block : blocks) {
                    predicates.add(class_4550.class_4710.method_23880().method_27962((class_7871)class_7923.field_41175, new class_2248[]{block}).method_23882());
                }
                preview.method_57379(class_9334.field_49634, (Object)new class_6538(predicates, true));
                player.method_31548().method_5447(player.method_31548().field_7545, preview);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void updateCanBreakPreview(class_746 player, class_1799 stack, List<class_2248> blocks) {
            if (blocks == null || blocks.isEmpty()) {
                return;
            }
            try {
                class_1799 preview = stack.method_7972();
                ArrayList<class_4550> predicates = new ArrayList<class_4550>();
                for (class_2248 block : blocks) {
                    predicates.add(class_4550.class_4710.method_23880().method_27962((class_7871)class_7923.field_41175, new class_2248[]{block}).method_23882());
                }
                preview.method_57379(class_9334.field_49635, (Object)new class_6538(predicates, true));
                player.method_31548().method_5447(player.method_31548().field_7545, preview);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void updateRepairablePreview(class_746 player, class_1799 stack, List<class_1792> items) {
            if (items == null || items.isEmpty()) {
                return;
            }
            try {
                class_1799 preview = stack.method_7972();
                ArrayList<class_6880> holders = new ArrayList<class_6880>();
                for (class_1792 item : items) {
                    holders.add(class_7923.field_41178.method_47983((Object)item));
                }
                class_6885.class_6886 holderSet = class_6885.method_40242(holders);
                preview.method_57379(class_9334.field_53696, (Object)new class_9890((class_6885)holderSet));
                player.method_31548().method_5447(player.method_31548().field_7545, preview);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public int getHeight() {
            return 25;
        }

        @Override
        public void applyToItemStack(class_1799 stack, String componentName, class_746 player) {
            if (this.storedValue == null) {
                switch (componentName) {
                    case "can_place_on": {
                        break;
                    }
                    case "can_break": {
                        break;
                    }
                    case "repairable": {
                        break;
                    }
                    case "dyed_color": {
                        this.storedValue = stack.method_57824(class_9334.field_49644);
                        break;
                    }
                    case "food": {
                        this.storedValue = stack.method_57824(class_9334.field_50075);
                        break;
                    }
                    case "potion_contents": {
                        this.storedValue = stack.method_57824(class_9334.field_49651);
                        break;
                    }
                    case "use_remainder": {
                        this.storedValue = stack.method_57824(class_9334.field_53965);
                        break;
                    }
                    case "trim": {
                        this.storedValue = stack.method_57824(class_9334.field_49607);
                        break;
                    }
                    case "consumable": {
                        this.storedValue = stack.method_57824(class_9334.field_53964);
                        break;
                    }
                    case "jukebox_playable": {
                        this.storedValue = stack.method_57824(class_9334.field_52175);
                        break;
                    }
                    case "tool": {
                        this.storedValue = stack.method_57824(class_9334.field_50077);
                        break;
                    }
                    case "suspicious_stew_effects": {
                        this.storedValue = stack.method_57824(class_9334.field_49652);
                        break;
                    }
                    case "use_cooldown": {
                        this.storedValue = stack.method_57824(class_9334.field_53966);
                        break;
                    }
                    case "instrument": {
                        this.storedValue = stack.method_57824(class_9334.field_49612);
                        break;
                    }
                    case "note_block_sound": {
                        this.storedValue = stack.method_57824(class_9334.field_49618);
                        break;
                    }
                    case "base_color": {
                        this.storedValue = stack.method_57824(class_9334.field_49620);
                        break;
                    }
                    case "lodestone_tracker": {
                        this.storedValue = stack.method_57824(class_9334.field_49614);
                    }
                }
            }
            if (this.storedValue == null) {
                return;
            }
            switch (componentName) {
                case "can_place_on": {
                    Object object = this.storedValue;
                    if (!(object instanceof List)) break;
                    List blockList = (List)object;
                    try {
                        List blocks = blockList;
                        if (blocks.isEmpty()) {
                            stack.method_57381(class_9334.field_49634);
                            break;
                        }
                        ArrayList<class_4550> predicates = new ArrayList<class_4550>();
                        for (class_2248 block : blocks) {
                            predicates.add(class_4550.class_4710.method_23880().method_27962((class_7871)class_7923.field_41175, new class_2248[]{block}).method_23882());
                        }
                        stack.method_57379(class_9334.field_49634, (Object)new class_6538(predicates, true));
                    }
                    catch (Exception e) {
                        player.method_7353((class_2561)class_2561.method_43470((String)("Error applying can_place_on: " + e.getMessage())).method_27692(class_124.field_1061), false);
                    }
                    break;
                }
                case "can_break": {
                    Object e = this.storedValue;
                    if (!(e instanceof List)) break;
                    List blockList = (List)e;
                    try {
                        List blocks = blockList;
                        if (blocks.isEmpty()) {
                            stack.method_57381(class_9334.field_49635);
                            break;
                        }
                        ArrayList<class_4550> predicates = new ArrayList<class_4550>();
                        for (class_2248 block : blocks) {
                            predicates.add(class_4550.class_4710.method_23880().method_27962((class_7871)class_7923.field_41175, new class_2248[]{block}).method_23882());
                        }
                        stack.method_57379(class_9334.field_49635, (Object)new class_6538(predicates, true));
                    }
                    catch (Exception e2) {
                        player.method_7353((class_2561)class_2561.method_43470((String)("Error applying can_break: " + e2.getMessage())).method_27692(class_124.field_1061), false);
                    }
                    break;
                }
                case "dyed_color": {
                    Object e2 = this.storedValue;
                    if (!(e2 instanceof class_9282)) break;
                    class_9282 color = (class_9282)e2;
                    stack.method_57379(class_9334.field_49644, (Object)color);
                    break;
                }
                case "food": {
                    Object e2 = this.storedValue;
                    if (!(e2 instanceof class_4174)) break;
                    class_4174 food = (class_4174)e2;
                    stack.method_57379(class_9334.field_50075, (Object)food);
                    break;
                }
                case "potion_contents": {
                    Object e2 = this.storedValue;
                    if (!(e2 instanceof class_1844)) break;
                    class_1844 potion = (class_1844)e2;
                    stack.method_57379(class_9334.field_49651, (Object)potion);
                    break;
                }
                case "use_remainder": {
                    Object e2 = this.storedValue;
                    if (!(e2 instanceof class_10131)) break;
                    class_10131 remainder = (class_10131)e2;
                    stack.method_57379(class_9334.field_53965, (Object)remainder);
                    break;
                }
                case "trim": {
                    Object e2 = this.storedValue;
                    if (!(e2 instanceof class_8053)) break;
                    class_8053 trim = (class_8053)e2;
                    stack.method_57379(class_9334.field_49607, (Object)trim);
                    break;
                }
                case "consumable": {
                    Object e2 = this.storedValue;
                    if (!(e2 instanceof class_10124)) break;
                    class_10124 consumable = (class_10124)e2;
                    stack.method_57379(class_9334.field_53964, (Object)consumable);
                    break;
                }
                case "jukebox_playable": {
                    Object e2 = this.storedValue;
                    if (!(e2 instanceof class_9792)) break;
                    class_9792 playable = (class_9792)e2;
                    stack.method_57379(class_9334.field_52175, (Object)playable);
                    break;
                }
                case "tool": {
                    Object e2 = this.storedValue;
                    if (!(e2 instanceof class_9424)) break;
                    class_9424 tool = (class_9424)e2;
                    stack.method_57379(class_9334.field_50077, (Object)tool);
                    break;
                }
                case "suspicious_stew_effects": {
                    Object e2 = this.storedValue;
                    if (!(e2 instanceof class_9298)) break;
                    class_9298 effects = (class_9298)e2;
                    stack.method_57379(class_9334.field_49652, (Object)effects);
                    break;
                }
                case "use_cooldown": {
                    Object e2 = this.storedValue;
                    if (!(e2 instanceof class_10130)) break;
                    class_10130 cooldown = (class_10130)e2;
                    stack.method_57379(class_9334.field_53966, (Object)cooldown);
                    break;
                }
                case "instrument": {
                    if (!(this.storedValue instanceof class_6880)) break;
                    stack.method_57379(class_9334.field_49612, (Object)((class_6880)this.storedValue));
                    break;
                }
                case "note_block_sound": {
                    Object e2 = this.storedValue;
                    if (!(e2 instanceof class_2960)) break;
                    class_2960 sound = (class_2960)e2;
                    stack.method_57379(class_9334.field_49618, (Object)sound);
                    break;
                }
                case "base_color": {
                    Object e2 = this.storedValue;
                    if (!(e2 instanceof class_1767)) break;
                    class_1767 color = (class_1767)e2;
                    stack.method_57379(class_9334.field_49620, (Object)color);
                    break;
                }
                case "lodestone_tracker": {
                    Object e2 = this.storedValue;
                    if (!(e2 instanceof class_9291)) break;
                    class_9291 tracker = (class_9291)e2;
                    stack.method_57379(class_9334.field_49614, (Object)tracker);
                    break;
                }
                case "container": {
                    Object e2 = this.storedValue;
                    if (!(e2 instanceof class_9288)) break;
                    class_9288 contents = (class_9288)e2;
                    stack.method_57379(class_9334.field_49622, (Object)contents);
                    break;
                }
                case "bundle_contents": {
                    Object e2 = this.storedValue;
                    if (!(e2 instanceof class_9288)) break;
                    class_9288 contents = (class_9288)e2;
                    List<class_1799> items = contents.method_57489().filter(s -> !s.method_7960() && s.method_7947() > 0).toList();
                    stack.method_57379(class_9334.field_49650, (Object)new class_9276(items));
                    break;
                }
                case "repairable": {
                    Object items = this.storedValue;
                    if (!(items instanceof List)) break;
                    List itemList = (List)items;
                    try {
                        items = itemList;
                        if (items.isEmpty()) {
                            stack.method_57381(class_9334.field_53696);
                            break;
                        }
                        ArrayList<class_6880> holders = new ArrayList<class_6880>();
                        Iterator iterator = items.iterator();
                        while (iterator.hasNext()) {
                            class_1792 item = (class_1792)iterator.next();
                            holders.add(class_7923.field_41178.method_47983((Object)item));
                        }
                        class_6885.class_6886 holderSet = class_6885.method_40242(holders);
                        stack.method_57379(class_9334.field_53696, (Object)new class_9890((class_6885)holderSet));
                        break;
                    }
                    catch (Exception e3) {
                        player.method_7353((class_2561)class_2561.method_43470((String)("Error applying repairable: " + e3.getMessage())).method_27692(class_124.field_1061), false);
                    }
                }
            }
        }

        @Override
        public void loadFromItemStack(class_1799 stack, String componentName) {
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class AttributeModifierListEditor
    extends ComponentEditor {
        private class_9285 storedModifiers;
        private SimpleGuiScreen parentScreen;

        public AttributeModifierListEditor(String label) {
            super(label);
        }

        @Override
        public GuiWidget createWidget(String id, int x, int y, int width) {
            ButtonWidget button = new ButtonWidget(id, x, y, 150, 20, "Edit " + this.label, -12961170, -11908465, -1);
            button.setOnPress(() -> {
                if (this.parentScreen != null) {
                    class_1799 stack;
                    this.parentScreen.closeAllOverlays();
                    class_746 player = this.parentScreen.getPlayer();
                    class_310 mc = this.parentScreen.getMinecraft();
                    if (player != null && mc != null && !(stack = player.method_6047()).method_7960()) {
                        this.storedModifiers = (class_9285)stack.method_57825(class_9334.field_49636, (Object)class_9285.field_49326);
                        mc.method_1507((class_437)new AttributeModifierEditorGui(this.parentScreen, stack, modifiers -> {
                            this.storedModifiers = modifiers;
                            class_1799 preview = stack.method_7972();
                            preview.method_57379(class_9334.field_49636, (Object)this.storedModifiers);
                            player.method_31548().method_5447(player.method_31548().field_7545, preview);
                        }));
                    }
                }
            });
            return button;
        }

        public void setParentScreen(SimpleGuiScreen screen) {
            this.parentScreen = screen;
        }

        @Override
        public int getHeight() {
            return 25;
        }

        @Override
        public void applyToItemStack(class_1799 stack, String componentName, class_746 player) {
            if (this.storedModifiers == null) {
                this.storedModifiers = (class_9285)stack.method_57825(class_9334.field_49636, (Object)class_9285.field_49326);
            }
            stack.method_57379(class_9334.field_49636, (Object)this.storedModifiers);
        }

        @Override
        public void loadFromItemStack(class_1799 stack, String componentName) {
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class EnchantmentListEditor
    extends ComponentEditor {
        private class_9304 storedEnchantments;
        private SimpleGuiScreen parentScreen;

        public EnchantmentListEditor(String label) {
            super(label);
        }

        @Override
        public GuiWidget createWidget(String id, int x, int y, int width) {
            ButtonWidget button = new ButtonWidget(id, x, y, 150, 20, "Edit " + this.label, -12961170, -11908465, -1);
            button.setOnPress(() -> {
                if (this.parentScreen != null) {
                    class_1799 stack;
                    this.parentScreen.closeAllOverlays();
                    class_746 player = this.parentScreen.getPlayer();
                    class_310 mc = this.parentScreen.getMinecraft();
                    if (player != null && mc != null && !(stack = player.method_6047()).method_7960()) {
                        boolean isStored = this.label.toLowerCase().contains("stored");
                        this.storedEnchantments = isStored ? (class_9304)stack.method_57825(class_9334.field_49643, (Object)class_9304.field_49385) : class_1890.method_57532((class_1799)stack);
                        mc.method_1507((class_437)new EnchantmentEditorGui(this.parentScreen, stack, isStored, enchants -> {
                            this.storedEnchantments = enchants;
                            class_1799 preview = stack.method_7972();
                            if (isStored) {
                                preview.method_57379(class_9334.field_49643, (Object)this.storedEnchantments);
                            } else {
                                class_1890.method_57530((class_1799)preview, (class_9304)this.storedEnchantments);
                            }
                            player.method_31548().method_5447(player.method_31548().field_7545, preview);
                        }));
                    }
                }
            });
            return button;
        }

        public void setParentScreen(SimpleGuiScreen screen) {
            this.parentScreen = screen;
        }

        @Override
        public int getHeight() {
            return 25;
        }

        @Override
        public void applyToItemStack(class_1799 stack, String componentName, class_746 player) {
            if (this.storedEnchantments == null) {
                if (componentName.equals("stored_enchantments")) {
                    this.storedEnchantments = (class_9304)stack.method_57825(class_9334.field_49643, (Object)class_9304.field_49385);
                } else if (componentName.equals("enchantments")) {
                    this.storedEnchantments = class_1890.method_57532((class_1799)stack);
                }
            }
            if (this.storedEnchantments == null) {
                return;
            }
            if (componentName.equals("stored_enchantments")) {
                stack.method_57379(class_9334.field_49643, (Object)this.storedEnchantments);
            } else if (componentName.equals("enchantments")) {
                class_1890.method_57530((class_1799)stack, (class_9304)this.storedEnchantments);
            }
        }

        @Override
        public void loadFromItemStack(class_1799 stack, String componentName) {
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class DropdownEditor
    extends ComponentEditor {
        private final String[] options;
        private final int defaultIndex;

        public DropdownEditor(String label, String[] options, int defaultIndex) {
            super(label);
            this.options = options;
            this.defaultIndex = defaultIndex;
        }

        @Override
        public GuiWidget createWidget(String id, int x, int y, int width) {
            SearchableDropdownWidget dropdown = new SearchableDropdownWidget(id, x, y, Math.min(width, 250), 20);
            for (String option : this.options) {
                dropdown.addOption(option);
            }
            dropdown.setSelectedIndex(this.defaultIndex);
            return dropdown;
        }

        @Override
        public int getHeight() {
            return 25;
        }

        @Override
        public void applyToItemStack(class_1799 stack, String componentName, class_746 player) {
            GuiWidget guiWidget = this.inputWidget;
            if (!(guiWidget instanceof SearchableDropdownWidget)) {
                return;
            }
            SearchableDropdownWidget dropdown = (SearchableDropdownWidget)guiWidget;
            String selected = dropdown.getSelectedOption();
            if (componentName.equals("rarity")) {
                class_1814 rarity = switch (selected.toLowerCase()) {
                    case "uncommon" -> class_1814.field_8907;
                    case "rare" -> class_1814.field_8903;
                    case "epic" -> class_1814.field_8904;
                    default -> class_1814.field_8906;
                };
                stack.method_57379(class_9334.field_50073, (Object)rarity);
            } else if (componentName.equals("equippable")) {
                if (selected.equals("none")) {
                    stack.method_57381(class_9334.field_54196);
                } else {
                    class_1304 slot = switch (selected.toLowerCase()) {
                        case "head" -> class_1304.field_6169;
                        case "chest" -> class_1304.field_6174;
                        case "legs" -> class_1304.field_6172;
                        case "feet" -> class_1304.field_6166;
                        case "body" -> class_1304.field_48824;
                        case "offhand" -> class_1304.field_6171;
                        default -> class_1304.field_6173;
                    };
                    stack.method_57379(class_9334.field_54196, (Object)class_10192.method_64202((class_1304)slot).method_64203());
                }
            }
        }

        @Override
        public void loadFromItemStack(class_1799 stack, String componentName) {
            GuiWidget guiWidget = this.inputWidget;
            if (!(guiWidget instanceof SearchableDropdownWidget)) {
                return;
            }
            SearchableDropdownWidget dropdown = (SearchableDropdownWidget)guiWidget;
            if (componentName.equals("rarity")) {
                class_1814 rarity = (class_1814)stack.method_57825(class_9334.field_50073, (Object)class_1814.field_8906);
                int index = switch (rarity) {
                    case class_1814.field_8907 -> 1;
                    case class_1814.field_8903 -> 2;
                    case class_1814.field_8904 -> 3;
                    default -> 0;
                };
                dropdown.setSelectedIndex(index);
            } else if (componentName.equals("equippable")) {
                class_10192 equippable = (class_10192)stack.method_57824(class_9334.field_54196);
                if (equippable == null) {
                    dropdown.setSelectedIndex(0);
                } else {
                    int index = switch (equippable.comp_3174()) {
                        default -> throw new MatchException(null, null);
                        case class_1304.field_6169 -> 1;
                        case class_1304.field_6174 -> 2;
                        case class_1304.field_6172 -> 3;
                        case class_1304.field_6166 -> 4;
                        case class_1304.field_48824 -> 5;
                        case class_1304.field_6173 -> 6;
                        case class_1304.field_6171 -> 7;
                    };
                    dropdown.setSelectedIndex(index);
                }
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class CheckboxEditor
    extends ComponentEditor {
        private boolean value;

        public CheckboxEditor(String label, boolean defaultValue) {
            super(label);
            this.value = defaultValue;
        }

        @Override
        public GuiWidget createWidget(String id, int x, int y, int width) {
            ButtonWidget button = new ButtonWidget(id, x, y, 80, 20, this.value ? "\u00a7aEnabled" : "\u00a7cDisabled", this.value ? -13996502 : -9557462, this.value ? -13004999 : -7390919, -1);
            button.setOnPress(() -> {
                this.value = !this.value;
                button.setText(this.value ? "\u00a7aEnabled" : "\u00a7cDisabled");
            });
            return button;
        }

        @Override
        public int getHeight() {
            return 25;
        }

        @Override
        public void applyToItemStack(class_1799 stack, String componentName, class_746 player) {
            switch (componentName) {
                case "unbreakable": {
                    if (this.value) {
                        stack.method_57379(class_9334.field_49630, (Object)new class_9300(true));
                        break;
                    }
                    stack.method_57381(class_9334.field_49630);
                    break;
                }
                case "hide_tooltip": {
                    if (this.value) {
                        stack.method_57379(class_9334.field_50074, (Object)class_3902.field_17274);
                        break;
                    }
                    stack.method_57381(class_9334.field_50074);
                    break;
                }
                case "hide_additional_tooltip": {
                    if (this.value) {
                        stack.method_57379(class_9334.field_49638, (Object)class_3902.field_17274);
                        break;
                    }
                    stack.method_57381(class_9334.field_49638);
                    break;
                }
                case "creative_slot_lock": {
                    if (this.value) {
                        stack.method_57379(class_9334.field_49640, (Object)class_3902.field_17274);
                        break;
                    }
                    stack.method_57381(class_9334.field_49640);
                    break;
                }
                case "enchantment_glint_override": {
                    stack.method_57379(class_9334.field_49641, (Object)this.value);
                    break;
                }
                case "intangible_projectile": {
                    if (this.value) {
                        stack.method_57379(class_9334.field_49642, (Object)class_3902.field_17274);
                        break;
                    }
                    stack.method_57381(class_9334.field_49642);
                    break;
                }
                case "glider": {
                    if (this.value) {
                        stack.method_57379(class_9334.field_54197, (Object)class_3902.field_17274);
                        break;
                    }
                    stack.method_57381(class_9334.field_54197);
                    break;
                }
                case "death_protection": {
                    if (this.value) {
                        stack.method_57379(class_9334.field_54274, (Object)new class_10216(List.of()));
                        break;
                    }
                    stack.method_57381(class_9334.field_54274);
                }
            }
        }

        @Override
        public void loadFromItemStack(class_1799 stack, String componentName) {
            switch (componentName) {
                case "unbreakable": {
                    this.value = stack.method_57826(class_9334.field_49630);
                    GuiWidget guiWidget = this.inputWidget;
                    if (!(guiWidget instanceof ButtonWidget)) break;
                    ButtonWidget button = (ButtonWidget)guiWidget;
                    button.setText(this.value ? "\u00a7aEnabled" : "\u00a7cDisabled");
                    break;
                }
                case "hide_tooltip": {
                    this.value = stack.method_57826(class_9334.field_50074);
                    GuiWidget guiWidget = this.inputWidget;
                    if (!(guiWidget instanceof ButtonWidget)) break;
                    ButtonWidget button = (ButtonWidget)guiWidget;
                    button.setText(this.value ? "\u00a7aEnabled" : "\u00a7cDisabled");
                    break;
                }
                case "hide_additional_tooltip": {
                    this.value = stack.method_57826(class_9334.field_49638);
                    GuiWidget guiWidget = this.inputWidget;
                    if (!(guiWidget instanceof ButtonWidget)) break;
                    ButtonWidget button = (ButtonWidget)guiWidget;
                    button.setText(this.value ? "\u00a7aEnabled" : "\u00a7cDisabled");
                    break;
                }
                case "creative_slot_lock": {
                    this.value = stack.method_57826(class_9334.field_49640);
                    GuiWidget guiWidget = this.inputWidget;
                    if (!(guiWidget instanceof ButtonWidget)) break;
                    ButtonWidget button = (ButtonWidget)guiWidget;
                    button.setText(this.value ? "\u00a7aEnabled" : "\u00a7cDisabled");
                    break;
                }
                case "enchantment_glint_override": {
                    this.value = (Boolean)stack.method_57825(class_9334.field_49641, (Object)false);
                    GuiWidget guiWidget = this.inputWidget;
                    if (!(guiWidget instanceof ButtonWidget)) break;
                    ButtonWidget button = (ButtonWidget)guiWidget;
                    button.setText(this.value ? "\u00a7aEnabled" : "\u00a7cDisabled");
                    break;
                }
                case "intangible_projectile": {
                    this.value = stack.method_57826(class_9334.field_49642);
                    GuiWidget guiWidget = this.inputWidget;
                    if (!(guiWidget instanceof ButtonWidget)) break;
                    ButtonWidget button = (ButtonWidget)guiWidget;
                    button.setText(this.value ? "\u00a7aEnabled" : "\u00a7cDisabled");
                    break;
                }
                case "glider": {
                    this.value = stack.method_57826(class_9334.field_54197);
                    GuiWidget guiWidget = this.inputWidget;
                    if (!(guiWidget instanceof ButtonWidget)) break;
                    ButtonWidget button = (ButtonWidget)guiWidget;
                    button.setText(this.value ? "\u00a7aEnabled" : "\u00a7cDisabled");
                    break;
                }
                case "death_protection": {
                    this.value = stack.method_57826(class_9334.field_54274);
                    GuiWidget guiWidget = this.inputWidget;
                    if (!(guiWidget instanceof ButtonWidget)) break;
                    ButtonWidget button = (ButtonWidget)guiWidget;
                    button.setText(this.value ? "\u00a7aEnabled" : "\u00a7cDisabled");
                }
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class TextAreaEditor
    extends ComponentEditor {
        private final int lines;

        public TextAreaEditor(String label, int lines) {
            super(label);
            this.lines = lines;
        }

        @Override
        public GuiWidget createWidget(String id, int x, int y, int width) {
            TextBoxWidget textBox = new TextBoxWidget(id, x, y, width, 20 * this.lines, -14671840, -8355712, -1, -10461088);
            textBox.setMaxLength(512);
            textBox.setHint("Enter " + this.label.toLowerCase() + "...");
            return textBox;
        }

        @Override
        public int getHeight() {
            return 20 * this.lines + 5;
        }

        @Override
        public void applyToItemStack(class_1799 stack, String componentName, class_746 player) {
            GuiWidget guiWidget = this.inputWidget;
            if (!(guiWidget instanceof TextBoxWidget)) {
                return;
            }
            TextBoxWidget textBox = (TextBoxWidget)guiWidget;
            String value = textBox.getValue().trim();
            switch (componentName) {
                case "lore": {
                    if (value.isEmpty()) {
                        stack.method_57381(class_9334.field_49632);
                        break;
                    }
                    String[] lines = value.split("\n");
                    ArrayList<class_5250> loreLines = new ArrayList<class_5250>();
                    for (String line : lines) {
                        if (line.trim().isEmpty()) continue;
                        loreLines.add(class_2561.method_43470((String)line.trim()));
                    }
                    if (loreLines.isEmpty()) break;
                    stack.method_57379(class_9334.field_49632, (Object)new class_9290(loreLines));
                }
            }
        }

        @Override
        public void loadFromItemStack(class_1799 stack, String componentName) {
            Object object = this.inputWidget;
            if (!(object instanceof TextBoxWidget)) {
                return;
            }
            TextBoxWidget textBox = (TextBoxWidget)object;
            switch (componentName) {
                case "lore": {
                    class_9290 lore;
                    if (!stack.method_57826(class_9334.field_49632) || (lore = (class_9290)stack.method_57824(class_9334.field_49632)) == null) break;
                    StringBuilder sb = new StringBuilder();
                    for (class_2561 line : lore.comp_2400()) {
                        if (sb.length() > 0) {
                            sb.append("\n");
                        }
                        sb.append(line.getString());
                    }
                    textBox.setValue(sb.toString());
                }
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class TextFieldEditor
    extends ComponentEditor {
        private final String defaultValue;
        private final int maxLength;

        public TextFieldEditor(String label, String defaultValue, int maxLength) {
            super(label);
            this.defaultValue = defaultValue;
            this.maxLength = maxLength;
        }

        @Override
        public GuiWidget createWidget(String id, int x, int y, int width) {
            TextBoxWidget textBox = new TextBoxWidget(id, x, y, width, 20, -14671840, -8355712, -1, -10461088);
            textBox.setValue(this.defaultValue);
            textBox.setMaxLength(this.maxLength);
            textBox.setHint("Enter " + this.label.toLowerCase() + "...");
            return textBox;
        }

        @Override
        public int getHeight() {
            return 25;
        }

        @Override
        public void applyToItemStack(class_1799 stack, String componentName, class_746 player) {
            GuiWidget guiWidget = this.inputWidget;
            if (!(guiWidget instanceof TextBoxWidget)) {
                return;
            }
            TextBoxWidget textBox = (TextBoxWidget)guiWidget;
            String value = textBox.getValue().trim();
            if (value.isEmpty() && this.defaultValue.isEmpty()) {
                return;
            }
            switch (componentName) {
                case "max_stack_size": {
                    try {
                        int maxStack = Integer.parseInt(value);
                        if (maxStack <= 0 || maxStack > 99) break;
                        stack.method_57379(class_9334.field_50071, (Object)maxStack);
                    }
                    catch (NumberFormatException maxStack) {}
                    break;
                }
                case "max_damage": {
                    try {
                        int maxDamage = Integer.parseInt(value);
                        if (maxDamage <= 0) break;
                        stack.method_57379(class_9334.field_50072, (Object)maxDamage);
                    }
                    catch (NumberFormatException maxDamage) {}
                    break;
                }
                case "damage": {
                    try {
                        int damage = Integer.parseInt(value);
                        if (damage < 0) break;
                        stack.method_57379(class_9334.field_49629, (Object)damage);
                    }
                    catch (NumberFormatException damage) {}
                    break;
                }
                case "custom_name": {
                    if (value.isEmpty()) break;
                    stack.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)value));
                    break;
                }
                case "item_name": {
                    if (value.isEmpty()) break;
                    stack.method_57379(class_9334.field_50239, (Object)class_2561.method_43470((String)value));
                    break;
                }
                case "custom_model_data": {
                    try {
                        int modelData = Integer.parseInt(value);
                        if (modelData <= 0) break;
                        stack.method_57379(class_9334.field_49637, (Object)new class_9280(List.of(), List.of(), List.of(), List.of(Integer.valueOf(modelData))));
                    }
                    catch (NumberFormatException modelData) {}
                    break;
                }
                case "repair_cost": {
                    try {
                        int cost = Integer.parseInt(value);
                        if (cost < 0) break;
                        stack.method_57379(class_9334.field_49639, (Object)cost);
                    }
                    catch (NumberFormatException cost) {}
                    break;
                }
                case "ominous_bottle_amplifier": {
                    try {
                        if (player.method_6047().method_7909() == class_1802.field_50140) {
                            try {
                                int amplifier = Integer.parseInt(value);
                                if (amplifier < 0) break;
                                stack.method_57379(class_9334.field_50238, (Object)new class_10129(amplifier));
                            }
                            catch (NumberFormatException amplifier) {}
                            break;
                        }
                        player.method_7353((class_2561)class_2561.method_43470((String)"Ominous Bottle Amplifier can only be set on Ominous Bottles").method_27692(class_124.field_1054), false);
                    }
                    catch (NumberFormatException amplifier) {}
                    break;
                }
                case "item_model": {
                    try {
                        if (value.isEmpty()) break;
                        class_2960 rl = value.contains(":") ? class_2960.method_60654((String)value) : class_2960.method_60656((String)value);
                        try {
                            stack.method_57379(class_9334.field_54199, (Object)rl);
                        }
                        catch (Throwable ignored) {
                            ArrayList<class_5250> loreLines = new ArrayList<class_5250>();
                            loreLines.add(class_2561.method_43470((String)("Model: " + rl.toString())).method_27692(class_124.field_1063));
                            stack.method_57379(class_9334.field_49632, (Object)new class_9290(loreLines));
                        }
                    }
                    catch (Exception rl) {}
                    break;
                }
                case "tooltip_style": {
                    try {
                        if (value.isEmpty()) break;
                        class_2960 rl = value.contains(":") ? class_2960.method_60654((String)value) : class_2960.method_60656((String)value);
                        stack.method_57379(class_9334.field_54198, (Object)rl);
                    }
                    catch (Exception rl) {}
                    break;
                }
                case "enchantable": {
                    try {
                        int enchantValue = Integer.parseInt(value);
                        if (enchantValue > 0) {
                            stack.method_57379(class_9334.field_53695, (Object)new class_9889(enchantValue));
                            break;
                        }
                        stack.method_57381(class_9334.field_53695);
                    }
                    catch (NumberFormatException enchantValue) {}
                    break;
                }
                case "damage_resistant": {
                    if (!value.isEmpty()) {
                        try {
                            class_2960 rl = value.contains(":") ? class_2960.method_60654((String)value) : class_2960.method_60656((String)value);
                            class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_42534, (class_2960)rl);
                            stack.method_57379(class_9334.field_54273, (Object)new class_10215(tag));
                        }
                        catch (Exception exception) {}
                        break;
                    }
                    stack.method_57381(class_9334.field_54273);
                    break;
                }
                case "lock": {
                    if (!value.isEmpty()) {
                        player.method_7353((class_2561)class_2561.method_43470((String)"Lock component requires NBT editing").method_27692(class_124.field_1054), false);
                        break;
                    }
                    stack.method_57381(class_9334.field_49625);
                }
            }
        }

        @Override
        public void loadFromItemStack(class_1799 stack, String componentName) {
            Object object = this.inputWidget;
            if (!(object instanceof TextBoxWidget)) {
                return;
            }
            TextBoxWidget textBox = (TextBoxWidget)object;
            switch (componentName) {
                case "max_stack_size": {
                    textBox.setValue(String.valueOf(stack.method_57825(class_9334.field_50071, (Object)64)));
                    break;
                }
                case "max_damage": {
                    textBox.setValue(String.valueOf(stack.method_57825(class_9334.field_50072, (Object)0)));
                    break;
                }
                case "damage": {
                    textBox.setValue(String.valueOf(stack.method_57825(class_9334.field_49629, (Object)0)));
                    break;
                }
                case "custom_name": {
                    if (!stack.method_57826(class_9334.field_49631)) break;
                    textBox.setValue(((class_2561)stack.method_57824(class_9334.field_49631)).getString());
                    break;
                }
                case "item_name": {
                    if (!stack.method_57826(class_9334.field_50239)) break;
                    textBox.setValue(((class_2561)stack.method_57824(class_9334.field_50239)).getString());
                    break;
                }
                case "custom_model_data": {
                    if (!stack.method_57826(class_9334.field_49637)) break;
                    textBox.setValue("0");
                    break;
                }
                case "repair_cost": {
                    textBox.setValue(String.valueOf(stack.method_57825(class_9334.field_49639, (Object)0)));
                    break;
                }
                case "ominous_bottle_amplifier": {
                    if (!stack.method_57826(class_9334.field_50238)) break;
                    textBox.setValue(String.valueOf(((class_10129)stack.method_57824(class_9334.field_50238)).comp_3090()));
                    break;
                }
                case "item_model": {
                    try {
                        Object v;
                        if (!stack.method_57826(class_9334.field_54199) || !((v = stack.method_57824(class_9334.field_54199)) instanceof class_2960)) break;
                        class_2960 rl = (class_2960)v;
                        textBox.setValue(rl.toString());
                    }
                    catch (Throwable v) {}
                    break;
                }
                case "tooltip_style": {
                    try {
                        class_2960 rl;
                        if (!stack.method_57826(class_9334.field_54198) || (rl = (class_2960)stack.method_57824(class_9334.field_54198)) == null) break;
                        textBox.setValue(rl.toString());
                    }
                    catch (Throwable rl) {}
                    break;
                }
                case "enchantable": {
                    class_9889 enchantable;
                    if (!stack.method_57826(class_9334.field_53695) || (enchantable = (class_9889)stack.method_57824(class_9334.field_53695)) == null) break;
                    textBox.setValue(String.valueOf(enchantable.comp_2938()));
                    break;
                }
                case "damage_resistant": {
                    class_10215 dr;
                    if (!stack.method_57826(class_9334.field_54273) || (dr = (class_10215)stack.method_57824(class_9334.field_54273)) == null) break;
                    textBox.setValue(dr.comp_3210().comp_327().toString());
                    break;
                }
                case "lock": {
                    if (!stack.method_57826(class_9334.field_49625)) break;
                    textBox.setValue("[Complex lock data]");
                }
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static abstract class ComponentEditor {
        protected final String label;
        protected GuiWidget inputWidget;
        protected LabelWidget labelWidget;
        protected int originalWidth = -1;

        public ComponentEditor(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public void setInputWidget(GuiWidget widget) {
            this.inputWidget = widget;
            if (widget != null && this.originalWidth == -1) {
                this.originalWidth = widget.getWidth();
            }
        }

        public void setLabelWidget(LabelWidget widget) {
            this.labelWidget = widget;
        }

        public void setVisible(boolean visible) {
            if (this.inputWidget != null) {
                this.inputWidget.setVisible(visible);
            }
            if (this.labelWidget != null) {
                this.labelWidget.setVisible(visible);
            }
        }

        public int getOriginalWidth() {
            return this.originalWidth;
        }

        public abstract GuiWidget createWidget(String var1, int var2, int var3, int var4);

        public abstract int getHeight();

        public abstract void applyToItemStack(class_1799 var1, String var2, class_746 var3);

        public abstract void loadFromItemStack(class_1799 var1, String var2);
    }
}

