/*
 * Decompiled with CFR 0.152.
 */
package net.jackson.simplegui;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jackson.simplegui.SimpleGuiScreen;
import net.jackson.simplegui.widget.ButtonWidget;
import net.jackson.simplegui.widget.LabelWidget;
import net.jackson.simplegui.widget.ScrollMenuWidget;
import net.jackson.simplegui.widget.SearchableDropdownWidget;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_746;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class ItemListEditorGui
extends SimpleGuiScreen {
    private final Consumer<List<class_1792>> onSave;
    private final List<class_1792> items = new ArrayList<class_1792>();
    private final String title;
    private ScrollMenuWidget itemListWidget;
    private SearchableDropdownWidget itemSelector;
    private final List<class_1792> allItems = new ArrayList<class_1792>();

    public ItemListEditorGui(class_437 parent, String title, List<class_1792> initialItems, Consumer<List<class_1792>> onSave) {
        super(title, parent);
        this.title = title;
        this.onSave = onSave;
        if (initialItems != null) {
            this.items.addAll(initialItems);
        }
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        int panelWidth = Math.min(400, this.field_22789 - 40);
        int panelX = centerX - panelWidth / 2;
        LabelWidget titleLabel = new LabelWidget("title", centerX, 10, "\u00a76\u00a7l" + this.title, -1, true, true);
        this.addWidget(titleLabel);
        LabelWidget instructions = new LabelWidget("instructions", centerX, 30, "\u00a77Select items that can repair this item", -5592406, true, false);
        this.addWidget(instructions);
        LabelWidget selectorLabel = new LabelWidget("selector_label", panelX, 50, "Add Item:", -5592406, false, false);
        this.addWidget(selectorLabel);
        this.itemSelector = new SearchableDropdownWidget("item_selector", panelX, 70, panelWidth - 80, 20, -14671840, -12566464, -1);
        ArrayList<String> itemNames = new ArrayList<String>();
        for (class_1792 item : class_7923.field_41178) {
            if (item == class_1802.field_8162) continue;
            class_2960 id = class_7923.field_41178.method_10221((Object)item);
            itemNames.add(id.toString());
            this.allItems.add(item);
            int index = itemNames.size() - 1;
            this.itemSelector.setItemOverlay(index, new class_1799((class_1935)item));
        }
        for (String name : itemNames) {
            this.itemSelector.addOption(name);
        }
        this.addWidget(this.itemSelector);
        ButtonWidget addBtn = new ButtonWidget("add_item", panelX + panelWidth - 70, 70, 60, 20, "Add", -13996502, -13004999, -1);
        addBtn.setOnPress(() -> {
            class_1792 selectedItem;
            int selectedIndex = this.itemSelector.getSelectedIndex();
            if (selectedIndex >= 0 && selectedIndex < this.allItems.size() && !this.items.contains(selectedItem = this.allItems.get(selectedIndex))) {
                this.items.add(selectedItem);
                this.refreshItemList();
            }
        });
        this.addWidget(addBtn);
        LabelWidget listLabel = new LabelWidget("list_label", panelX, 100, "\u00a7eSelected Repair Items (" + this.items.size() + "):", -1, false, false);
        this.addWidget(listLabel);
        this.itemListWidget = new ScrollMenuWidget("item_list", panelX, 120, panelWidth, this.field_22790 - 180, -15066598, -14013910, -12632257, -1, -10461088);
        this.itemListWidget.setItemHeight(24);
        this.addWidget(this.itemListWidget);
        this.refreshItemList();
        ButtonWidget saveBtn = new ButtonWidget("save", centerX - 105, this.field_22790 - 35, 100, 20, "Save", -13996502, -13004999, -1);
        saveBtn.setOnPress(this::save);
        this.addWidget(saveBtn);
        ButtonWidget cancelBtn = new ButtonWidget("cancel", centerX + 5, this.field_22790 - 35, 100, 20, "Cancel", -9737365, -7697782, -1);
        cancelBtn.setOnPress(this::method_25419);
        this.addWidget(cancelBtn);
    }

    private void refreshItemList() {
        this.itemListWidget.clearItems();
        for (int i = 0; i < this.items.size(); ++i) {
            class_1792 item = this.items.get(i);
            class_2960 id = class_7923.field_41178.method_10221((Object)item);
            String displayName = id.toString();
            this.itemListWidget.addItem(displayName);
        }
        LabelWidget listLabel = (LabelWidget)this.getWidget("list_label");
        if (listLabel != null) {
            listLabel.setText("\u00a7eSelected Repair Items (" + this.items.size() + "):");
        }
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 1 && this.itemListWidget != null) {
            int scrollOffset;
            int clickedIndex;
            int listX = this.itemListWidget.getX();
            int listY = this.itemListWidget.getY();
            int listWidth = this.itemListWidget.getWidth();
            int itemHeight = 24;
            if (mouseX >= (double)listX && mouseX < (double)(listX + listWidth) && mouseY >= (double)listY && mouseY < (double)(listY + this.itemListWidget.getHeight()) && (clickedIndex = (int)((mouseY - (double)listY) / (double)itemHeight) + (scrollOffset = this.itemListWidget.getSelectedIndex() / 10)) >= 0 && clickedIndex < this.items.size()) {
                this.items.remove(clickedIndex);
                this.refreshItemList();
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private void save() {
        class_746 player;
        if (this.onSave != null) {
            this.onSave.accept(new ArrayList<class_1792>(this.items));
        }
        if ((player = this.field_22787.field_1724) != null) {
            player.method_7353((class_2561)class_2561.method_43470((String)("Repair items updated: " + this.items.size() + " items")).method_27692(class_124.field_1060), false);
        }
        this.method_25419();
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        int centerX = this.field_22789 / 2;
        graphics.method_51433(this.field_22787.field_1772, "\u00a77Right-click on an item to remove it", centerX - this.field_22787.field_1772.method_1727("Right-click on an item to remove it") / 2, this.field_22790 - 55, -6710887, false);
    }
}

