/*
 * Decompiled with CFR 0.152.
 */
package net.jackson.simplegui;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jackson.simplegui.SimpleGuiScreen;
import net.jackson.simplegui.widget.ButtonWidget;
import net.jackson.simplegui.widget.LabelWidget;
import net.jackson.simplegui.widget.ScrollMenuWidget;
import net.jackson.simplegui.widget.TextBoxWidget;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_437;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class ItemSelectorGui
extends SimpleGuiScreen {
    private final Consumer<class_1799> onSelect;
    private ScrollMenuWidget itemList;
    private TextBoxWidget searchBox;
    private final List<class_1792> allItems = new ArrayList<class_1792>();
    private final List<class_1792> filteredItems = new ArrayList<class_1792>();
    private String lastSearch = "";

    public ItemSelectorGui(class_437 parent, Consumer<class_1799> onSelect) {
        super("Item Selector", parent);
        this.onSelect = onSelect;
        this.loadItems();
    }

    private void loadItems() {
        for (class_1792 item2 : class_7923.field_41178) {
            if (item2 == class_1802.field_8162) continue;
            this.allItems.add(item2);
        }
        this.allItems.sort(Comparator.comparing(item -> class_7923.field_41178.method_10221(item).toString()));
        this.filteredItems.addAll(this.allItems);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        int panelWidth = 350;
        int panelX = centerX - panelWidth / 2;
        LabelWidget title = new LabelWidget("title", centerX, 10, "\u00a76\u00a7lSelect Item", -1, true, true);
        this.addWidget(title);
        LabelWidget searchLabel = new LabelWidget("search_label", panelX, 30, "\u00a7eSearch:", -1, false, false);
        this.addWidget(searchLabel);
        this.searchBox = new TextBoxWidget("search", panelX, 45, panelWidth, 20, -14671840, -8355712, -1, -10461088);
        this.searchBox.setHint("Type to filter items...");
        this.searchBox.setMaxLength(64);
        this.addWidget(this.searchBox);
        this.itemList = new ScrollMenuWidget("item_list", panelX, 75, panelWidth, this.field_22790 - 145, -15066598, -14013910, -12632257, -1, -10461088);
        this.itemList.setItemHeight(24);
        this.updateItemList("");
        this.addWidget(this.itemList);
        ButtonWidget selectBtn = new ButtonWidget("select", centerX - 105, this.field_22790 - 35, 100, 20, "Select", -13996502, -13004999, -1);
        selectBtn.setOnPress(() -> {
            int selectedIndex = this.itemList.getSelectedIndex();
            if (selectedIndex >= 0 && selectedIndex < this.filteredItems.size()) {
                class_1792 item = this.filteredItems.get(selectedIndex);
                if (this.onSelect != null) {
                    this.onSelect.accept(new class_1799((class_1935)item));
                }
                this.method_25419();
            }
        });
        this.addWidget(selectBtn);
        ButtonWidget cancelBtn = new ButtonWidget("cancel", centerX + 5, this.field_22790 - 35, 100, 20, "Cancel", -9737365, -7697782, -1);
        cancelBtn.setOnPress(this::method_25419);
        this.addWidget(cancelBtn);
    }

    public void method_25393() {
        super.method_25393();
        if (this.searchBox != null) {
            String searchText = this.searchBox.getValue();
            this.updateItemList(searchText);
        }
    }

    private void updateItemList(String searchText) {
        String itemName;
        if (searchText.equals(this.lastSearch)) {
            return;
        }
        this.lastSearch = searchText;
        this.filteredItems.clear();
        String search = searchText.toLowerCase();
        for (class_1792 item : this.allItems) {
            itemName = class_7923.field_41178.method_10221((Object)item).toString();
            if (!itemName.toLowerCase().contains(search)) continue;
            this.filteredItems.add(item);
        }
        this.itemList.clearItems();
        for (class_1792 item : this.filteredItems) {
            itemName = class_7923.field_41178.method_10221((Object)item).toString();
            this.itemList.addItem(itemName);
            this.itemList.setItemOverlay(this.itemList.getItemCount() - 1, new class_1799((class_1935)item));
        }
    }
}

