/*
 * Decompiled with CFR 0.152.
 */
package net.jackson.simplegui;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jackson.simplegui.SimpleGuiScreen;
import net.jackson.simplegui.widget.ButtonWidget;
import net.jackson.simplegui.widget.DropdownWidget;
import net.jackson.simplegui.widget.LabelWidget;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9791;
import net.minecraft.class_9792;

@Environment(value=EnvType.CLIENT)
public class JukeboxPlayableEditorGui
extends SimpleGuiScreen {
    private final Consumer<class_9792> onSave;
    private DropdownWidget songDropdown;
    private ButtonWidget showTooltipToggle;
    private final List<class_3414> allSongs = new ArrayList<class_3414>();
    private boolean showInTooltip = true;

    public JukeboxPlayableEditorGui(class_437 parent, class_9792 initial, Consumer<class_9792> onSave) {
        super("Jukebox Playable Editor", parent);
        this.onSave = onSave;
        if (initial != null) {
            this.showInTooltip = initial.comp_2834();
        }
        this.loadSongs();
    }

    private void loadSongs() {
        String[] discSounds;
        for (String sound : discSounds = new String[]{"music_disc.13", "music_disc.cat", "music_disc.blocks", "music_disc.chirp", "music_disc.far", "music_disc.mall", "music_disc.mellohi", "music_disc.stal", "music_disc.strad", "music_disc.ward", "music_disc.11", "music_disc.wait", "music_disc.pigstep", "music_disc.otherside", "music_disc.5", "music_disc.relic", "music_disc.precipice", "music_disc.creator", "music_disc.creator_music_box"}) {
            try {
                class_3414 event = class_3414.method_47908((class_2960)class_2960.method_60656((String)sound));
                this.allSongs.add(event);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        int panelWidth = 350;
        int panelX = centerX - panelWidth / 2;
        LabelWidget title = new LabelWidget("title", centerX, 10, "\u00a76\u00a7lJukebox Playable", -1, true, true);
        this.addWidget(title);
        LabelWidget songLabel = new LabelWidget("song_label", panelX, 35, "\u00a7eMusic Disc Song:", -1, false, false);
        this.addWidget(songLabel);
        this.songDropdown = new DropdownWidget("song_dropdown", panelX, 50, panelWidth, 20);
        if (this.allSongs.isEmpty()) {
            this.songDropdown.addOption("No songs available");
        } else {
            for (class_3414 song : this.allSongs) {
                String name = song.comp_3319().method_12832().replace("music_disc.", "").replace("_", " ");
                this.songDropdown.addOption(name);
            }
        }
        this.addWidget(this.songDropdown);
        LabelWidget tooltipLabel = new LabelWidget("tooltip_label", panelX, 85, "\u00a7eShow in Tooltip:", -1, false, false);
        this.addWidget(tooltipLabel);
        this.showTooltipToggle = new ButtonWidget("tooltip_toggle", panelX, 100, 120, 20, this.showInTooltip ? "\u00a7aYes" : "\u00a7cNo", this.showInTooltip ? -13996502 : -9557462, this.showInTooltip ? -13004999 : -7390919, -1);
        this.showTooltipToggle.setOnPress(() -> {
            this.showInTooltip = !this.showInTooltip;
            this.showTooltipToggle.setText(this.showInTooltip ? "\u00a7aYes" : "\u00a7cNo");
        });
        this.addWidget(this.showTooltipToggle);
        LabelWidget infoLabel = new LabelWidget("info_label", panelX, 140, "\u00a77Popular discs: cat, blocks, chirp, pigstep", -5592406, false, false);
        this.addWidget(infoLabel);
        LabelWidget info2Label = new LabelWidget("info2_label", panelX, 155, "\u00a771.21+ discs: creator, precipice, relic", -5592406, false, false);
        this.addWidget(info2Label);
        ButtonWidget saveBtn = new ButtonWidget("save", centerX - 105, this.field_22790 - 35, 100, 20, "Apply", -13996502, -13004999, -1);
        saveBtn.setOnPress(() -> {
            this.saveJukeboxPlayable();
            this.method_25419();
        });
        this.addWidget(saveBtn);
        ButtonWidget cancelBtn = new ButtonWidget("cancel", centerX + 5, this.field_22790 - 35, 100, 20, "Cancel", -9737365, -7697782, -1);
        cancelBtn.setOnPress(this::method_25419);
        this.addWidget(cancelBtn);
    }

    private void saveJukeboxPlayable() {
        int songIdx = this.songDropdown.getSelectedIndex();
        if (songIdx < 0 || songIdx >= this.allSongs.size()) {
            return;
        }
        try {
            String selectedSound = this.allSongs.get(songIdx).comp_3319().method_12832();
            String songKey = selectedSound.replace("music_disc.", "");
            class_5321 jukeboxSongKey = class_5321.method_29179((class_5321)class_7924.field_52176, (class_2960)class_2960.method_60656((String)songKey));
            class_5455 registryAccess = class_310.method_1551().field_1687.method_30349();
            class_2378 jukeboxSongRegistry = registryAccess.method_30530(class_7924.field_52176);
            Optional holderOpt = jukeboxSongRegistry.method_46746(jukeboxSongKey);
            if (holderOpt.isPresent()) {
                class_9792 playable = new class_9792(new class_9791((class_6880)holderOpt.get()), this.showInTooltip);
                if (this.onSave != null) {
                    this.onSave.accept(playable);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

