/*
 * Decompiled with CFR 0.152.
 */
package net.jackson.simplegui;

import java.util.Optional;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jackson.simplegui.SimpleGuiScreen;
import net.jackson.simplegui.widget.ButtonWidget;
import net.jackson.simplegui.widget.LabelWidget;
import net.jackson.simplegui.widget.TextBoxWidget;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4208;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_9291;

@Environment(value=EnvType.CLIENT)
public class LodestoneTrackerEditorGui
extends SimpleGuiScreen {
    private final Consumer<class_9291> onSave;
    private TextBoxWidget dimensionField;
    private TextBoxWidget xField;
    private TextBoxWidget yField;
    private TextBoxWidget zField;
    private ButtonWidget trackedButton;
    private boolean tracked = true;
    private String currentDimension = "minecraft:overworld";
    private int currentX = 0;
    private int currentY = 64;
    private int currentZ = 0;

    public LodestoneTrackerEditorGui(class_437 parent, class_9291 current, Consumer<class_9291> onSave) {
        super("Lodestone Tracker Editor", parent);
        this.onSave = onSave;
        if (current != null && current.comp_2402().isPresent()) {
            class_4208 pos = (class_4208)current.comp_2402().get();
            this.currentDimension = pos.comp_2207().method_29177().toString();
            this.currentX = pos.comp_2208().method_10263();
            this.currentY = pos.comp_2208().method_10264();
            this.currentZ = pos.comp_2208().method_10260();
            this.tracked = current.comp_2403();
        }
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        int panelWidth = 300;
        int panelX = centerX - panelWidth / 2;
        LabelWidget title = new LabelWidget("title", centerX, 10, "\u00a76\u00a7lLodestone Tracker Editor", -1, true, true);
        this.addWidget(title);
        LabelWidget instructions = new LabelWidget("instructions", centerX, 30, "\u00a77Set lodestone position and dimension", -5592406, true, false);
        this.addWidget(instructions);
        LabelWidget dimensionLabel = new LabelWidget("dimension_label", panelX, 60, "Dimension:", -5592406, false, false);
        this.addWidget(dimensionLabel);
        this.dimensionField = new TextBoxWidget("dimension", panelX, 80, panelWidth, 20, -14671840, -8355712, -1, -10461088);
        this.dimensionField.setValue(this.currentDimension);
        this.dimensionField.setMaxLength(128);
        this.dimensionField.setHint("e.g., minecraft:overworld");
        this.addWidget(this.dimensionField);
        LabelWidget posLabel = new LabelWidget("pos_label", panelX, 110, "Position:", -5592406, false, false);
        this.addWidget(posLabel);
        LabelWidget xLabel = new LabelWidget("x_label", panelX, 135, "X:", -5592406, false, false);
        this.addWidget(xLabel);
        this.xField = new TextBoxWidget("x", panelX + 20, 135, 80, 20, -14671840, -8355712, -1, -10461088);
        this.xField.setValue(String.valueOf(this.currentX));
        this.xField.setMaxLength(10);
        this.addWidget(this.xField);
        LabelWidget yLabel = new LabelWidget("y_label", panelX + 110, 135, "Y:", -5592406, false, false);
        this.addWidget(yLabel);
        this.yField = new TextBoxWidget("y", panelX + 130, 135, 80, 20, -14671840, -8355712, -1, -10461088);
        this.yField.setValue(String.valueOf(this.currentY));
        this.yField.setMaxLength(10);
        this.addWidget(this.yField);
        LabelWidget zLabel = new LabelWidget("z_label", panelX + 220, 135, "Z:", -5592406, false, false);
        this.addWidget(zLabel);
        this.zField = new TextBoxWidget("z", panelX + 240, 135, 80, 20, -14671840, -8355712, -1, -10461088);
        this.zField.setValue(String.valueOf(this.currentZ));
        this.zField.setMaxLength(10);
        this.addWidget(this.zField);
        LabelWidget trackedLabel = new LabelWidget("tracked_label", panelX, 165, "Tracked:", -5592406, false, false);
        this.addWidget(trackedLabel);
        this.trackedButton = new ButtonWidget("tracked", panelX + 70, 165, 100, 20, this.tracked ? "\u00a7aYes" : "\u00a7cNo", this.tracked ? -13996502 : -9557462, this.tracked ? -13004999 : -7390919, -1);
        this.trackedButton.setOnPress(() -> {
            this.tracked = !this.tracked;
            this.trackedButton.setText(this.tracked ? "\u00a7aYes" : "\u00a7cNo");
        });
        this.addWidget(this.trackedButton);
        LabelWidget info = new LabelWidget("info", panelX, 195, "\u00a77Dimensions: overworld, the_nether, the_end", -8355712, false, false);
        this.addWidget(info);
        ButtonWidget copyPosBtn = new ButtonWidget("copy_pos", panelX, 220, 150, 20, "Copy Current Position", -12961170, -11908465, -1);
        copyPosBtn.setOnPress(this::copyCurrentPosition);
        this.addWidget(copyPosBtn);
        ButtonWidget saveBtn = new ButtonWidget("save", centerX - 105, this.field_22790 - 35, 100, 20, "Save", -13996502, -13004999, -1);
        saveBtn.setOnPress(this::save);
        this.addWidget(saveBtn);
        ButtonWidget cancelBtn = new ButtonWidget("cancel", centerX + 5, this.field_22790 - 35, 100, 20, "Cancel", -9737365, -7697782, -1);
        cancelBtn.setOnPress(this::method_25419);
        this.addWidget(cancelBtn);
    }

    private void copyCurrentPosition() {
        if (this.field_22787.field_1724 != null) {
            class_2338 pos = this.field_22787.field_1724.method_24515();
            this.xField.setValue(String.valueOf(pos.method_10263()));
            this.yField.setValue(String.valueOf(pos.method_10264()));
            this.zField.setValue(String.valueOf(pos.method_10260()));
            class_5321 dim = this.field_22787.field_1724.method_37908().method_27983();
            this.dimensionField.setValue(dim.method_29177().toString());
            this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7aCopied your current position!"), false);
        }
    }

    private void save() {
        try {
            int x = Integer.parseInt(this.xField.getValue());
            int y = Integer.parseInt(this.yField.getValue());
            int z = Integer.parseInt(this.zField.getValue());
            String dimension = this.dimensionField.getValue();
            class_2960 dimLocation = class_2960.method_60654((String)dimension);
            class_5321 dimKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)dimLocation);
            class_2338 blockPos = new class_2338(x, y, z);
            class_4208 globalPos = class_4208.method_19443((class_5321)dimKey, (class_2338)blockPos);
            class_9291 tracker = new class_9291(Optional.of(globalPos), this.tracked);
            if (this.onSave != null) {
                this.onSave.accept(tracker);
            }
            this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7aLodestone tracker set!"), false);
            this.method_25419();
        }
        catch (NumberFormatException e) {
            this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cInvalid coordinates!"), false);
        }
        catch (Exception e) {
            this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u00a7cError: " + e.getMessage())), false);
        }
    }
}

