/*
 * Decompiled with CFR 0.152.
 */
package net.jackson.simplegui;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jackson.simplegui.SimpleGuiScreen;
import net.jackson.simplegui.widget.ButtonWidget;
import net.jackson.simplegui.widget.LabelWidget;
import net.jackson.simplegui.widget.SearchableDropdownWidget;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_7923;
import net.minecraft.class_8526;
import net.minecraft.class_9334;

@Environment(value=EnvType.CLIENT)
public class PotDecorationsEditorGui
extends SimpleGuiScreen {
    private final Consumer<class_8526> onSave;
    private final List<String> itemNames = new ArrayList<String>();
    private final List<class_1792> items = new ArrayList<class_1792>();
    private int selectedFront = 0;
    private int selectedBack = 0;
    private int selectedLeft = 0;
    private int selectedRight = 0;

    public PotDecorationsEditorGui(class_437 parent, class_8526 current, Consumer<class_8526> onSave) {
        super("Pot Decorations Editor", parent);
        this.onSave = onSave;
        this.loadSherds();
        if (current != null) {
            this.selectedFront = this.findItemIndex(current.comp_1490());
            this.selectedBack = this.findItemIndex(current.comp_1487());
            this.selectedLeft = this.findItemIndex(current.comp_1488());
            this.selectedRight = this.findItemIndex(current.comp_1489());
        }
    }

    private void loadSherds() {
        this.itemNames.add("(none)");
        this.items.add(null);
        for (class_1792 item : class_7923.field_41178) {
            String id = class_7923.field_41178.method_10221((Object)item).toString();
            if (!id.contains("pottery_sherd") && !id.equals("minecraft:brick")) continue;
            this.itemNames.add(id);
            this.items.add(item);
        }
    }

    private int findItemIndex(Optional<class_1792> item) {
        if (item.isEmpty()) {
            return 0;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            if (this.items.get(i) == null || !this.items.get(i).equals(item.get())) continue;
            return i;
        }
        return 0;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        int panelWidth = 300;
        int panelX = centerX - panelWidth / 2;
        LabelWidget title = new LabelWidget("title", centerX, 10, "\u00a76\u00a7lPot Decorations Editor", -1, true, true);
        this.addWidget(title);
        LabelWidget instructions = new LabelWidget("instructions", centerX, 30, "\u00a77Select sherds for each side of the pot", -5592406, true, false);
        this.addWidget(instructions);
        this.createSideSelector("Front", panelX, 60, this.selectedFront, index -> {
            this.selectedFront = index;
        });
        this.createSideSelector("Back", panelX, 110, this.selectedBack, index -> {
            this.selectedBack = index;
        });
        this.createSideSelector("Left", panelX, 160, this.selectedLeft, index -> {
            this.selectedLeft = index;
        });
        this.createSideSelector("Right", panelX, 210, this.selectedRight, index -> {
            this.selectedRight = index;
        });
        ButtonWidget saveBtn = new ButtonWidget("save", centerX - 105, this.field_22790 - 35, 100, 20, "Save", -13996502, -13004999, -1);
        saveBtn.setOnPress(this::save);
        this.addWidget(saveBtn);
        ButtonWidget cancelBtn = new ButtonWidget("cancel", centerX + 5, this.field_22790 - 35, 100, 20, "Cancel", -9737365, -7697782, -1);
        cancelBtn.setOnPress(this::method_25419);
        this.addWidget(cancelBtn);
    }

    private void createSideSelector(String side, int x, int y, int defaultIndex, Consumer<Integer> onChange) {
        LabelWidget label = new LabelWidget(side.toLowerCase() + "_label", x, y, side + " Side:", -5592406, false, false);
        this.addWidget(label);
        SearchableDropdownWidget dropdown = new SearchableDropdownWidget(side.toLowerCase() + "_dropdown", x, y + 20, 280, 20);
        for (String itemName : this.itemNames) {
            dropdown.addOption(itemName);
        }
        dropdown.setSelectedIndex(defaultIndex);
        dropdown.setOnChanged(onChange);
        this.addWidget(dropdown);
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        int previewX = this.field_22789 / 2 - 16;
        int previewY = 280;
        class_1799 potPreview = new class_1799((class_1935)class_1802.field_42699);
        Optional front = this.selectedFront > 0 ? Optional.of(this.items.get(this.selectedFront)) : Optional.empty();
        Optional back = this.selectedBack > 0 ? Optional.of(this.items.get(this.selectedBack)) : Optional.empty();
        Optional left = this.selectedLeft > 0 ? Optional.of(this.items.get(this.selectedLeft)) : Optional.empty();
        Optional right = this.selectedRight > 0 ? Optional.of(this.items.get(this.selectedRight)) : Optional.empty();
        class_8526 decorations = new class_8526(front, back, left, right);
        potPreview.method_57379(class_9334.field_49621, (Object)decorations);
        graphics.method_51427(potPreview, previewX, previewY);
        graphics.method_51433(this.field_22787.field_1772, "\u00a77Preview:", previewX - 30, previewY + 4, -5592406, false);
    }

    private void save() {
        Optional front = this.selectedFront > 0 ? Optional.of(this.items.get(this.selectedFront)) : Optional.empty();
        Optional back = this.selectedBack > 0 ? Optional.of(this.items.get(this.selectedBack)) : Optional.empty();
        Optional left = this.selectedLeft > 0 ? Optional.of(this.items.get(this.selectedLeft)) : Optional.empty();
        Optional right = this.selectedRight > 0 ? Optional.of(this.items.get(this.selectedRight)) : Optional.empty();
        class_8526 decorations = new class_8526(front, back, left, right);
        if (this.onSave != null) {
            this.onSave.accept(decorations);
        }
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7aPot decorations saved!"), false);
        }
        this.method_25419();
    }
}

