/*
 * Decompiled with CFR 0.152.
 */
package net.jackson.simplegui;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jackson.simplegui.SimpleGuiScreen;
import net.jackson.simplegui.ToolRuleEditorGui;
import net.jackson.simplegui.widget.ButtonWidget;
import net.jackson.simplegui.widget.LabelWidget;
import net.jackson.simplegui.widget.ScrollMenuWidget;
import net.jackson.simplegui.widget.TextBoxWidget;
import net.minecraft.class_437;
import net.minecraft.class_9424;

@Environment(value=EnvType.CLIENT)
public class ToolPropertiesEditorGui
extends SimpleGuiScreen {
    private final Consumer<class_9424> onSave;
    private TextBoxWidget defaultMiningSpeedInput;
    private TextBoxWidget damagePerBlockInput;
    private ScrollMenuWidget rulesList;
    private final List<class_9424.class_9425> rules = new ArrayList<class_9424.class_9425>();

    public ToolPropertiesEditorGui(class_437 parent, class_9424 initial, Consumer<class_9424> onSave) {
        super("Tool Properties Editor", parent);
        this.onSave = onSave;
        if (initial != null) {
            this.rules.addAll(initial.comp_2498());
        }
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        int panelWidth = 350;
        int panelX = centerX - panelWidth / 2;
        LabelWidget title = new LabelWidget("title", centerX, 10, "\u00a76\u00a7lTool Properties", -1, true, true);
        this.addWidget(title);
        LabelWidget speedLabel = new LabelWidget("speed_label", panelX, 35, "\u00a7eDefault Mining Speed:", -1, false, false);
        this.addWidget(speedLabel);
        this.defaultMiningSpeedInput = new TextBoxWidget("speed_input", panelX, 50, panelWidth, 20, -14671840, -8355712, -1, -10461088);
        this.defaultMiningSpeedInput.setValue("1.0");
        this.defaultMiningSpeedInput.setMaxLength(8);
        this.defaultMiningSpeedInput.setHint("1.0 = normal speed");
        this.addWidget(this.defaultMiningSpeedInput);
        LabelWidget damageLabel = new LabelWidget("damage_label", panelX, 80, "\u00a7eDamage Per Block:", -1, false, false);
        this.addWidget(damageLabel);
        this.damagePerBlockInput = new TextBoxWidget("damage_input", panelX, 95, panelWidth, 20, -14671840, -8355712, -1, -10461088);
        this.damagePerBlockInput.setValue("1");
        this.damagePerBlockInput.setMaxLength(3);
        this.damagePerBlockInput.setHint("Durability lost per block");
        this.addWidget(this.damagePerBlockInput);
        LabelWidget rulesLabel = new LabelWidget("rules_label", panelX, 125, "\u00a7eTool Rules (block-specific speeds):", -1, false, false);
        this.addWidget(rulesLabel);
        this.rulesList = new ScrollMenuWidget("rules_list", panelX, 140, panelWidth, 100, -15066598, -14013910, -12632257, -1, -10461088);
        this.rulesList.setItemHeight(20);
        this.updateRulesList();
        this.addWidget(this.rulesList);
        ButtonWidget addRuleBtn = new ButtonWidget("add_rule", panelX, 250, 110, 20, "Add Rule", -13996502, -13004999, -1);
        addRuleBtn.setOnPress(() -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507((class_437)new ToolRuleEditorGui(this, null, rule -> {
                    this.rules.add((class_9424.class_9425)rule);
                    this.updateRulesList();
                }));
            }
        });
        this.addWidget(addRuleBtn);
        ButtonWidget removeRuleBtn = new ButtonWidget("remove_rule", panelX + 120, 250, 110, 20, "Remove", -9557462, -7390919, -1);
        removeRuleBtn.setOnPress(() -> {
            int selected = this.rulesList.getSelectedIndex();
            if (selected >= 0 && selected < this.rules.size()) {
                this.rules.remove(selected);
                this.updateRulesList();
            }
        });
        this.addWidget(removeRuleBtn);
        ButtonWidget clearRulesBtn = new ButtonWidget("clear_rules", panelX + 240, 250, 110, 20, "Clear All", -9557462, -7390919, -1);
        clearRulesBtn.setOnPress(() -> {
            this.rules.clear();
            this.updateRulesList();
        });
        this.addWidget(clearRulesBtn);
        LabelWidget infoLabel = new LabelWidget("info_label", panelX, 280, "\u00a77Rules define which blocks break faster", -5592406, false, false);
        this.addWidget(infoLabel);
        ButtonWidget saveBtn = new ButtonWidget("save", centerX - 105, this.field_22790 - 35, 100, 20, "Apply", -13996502, -13004999, -1);
        saveBtn.setOnPress(() -> {
            this.saveTool();
            this.method_25419();
        });
        this.addWidget(saveBtn);
        ButtonWidget cancelBtn = new ButtonWidget("cancel", centerX + 5, this.field_22790 - 35, 100, 20, "Cancel", -9737365, -7697782, -1);
        cancelBtn.setOnPress(this::method_25419);
        this.addWidget(cancelBtn);
    }

    private void updateRulesList() {
        this.rulesList.clearItems();
        for (class_9424.class_9425 rule : this.rules) {
            String speed;
            String string = speed = rule.comp_2502().isPresent() ? String.format("%.1fx", rule.comp_2502().get()) : "instant";
            String correctForDrops = rule.comp_2503().isPresent() ? (((Boolean)rule.comp_2503().get()).booleanValue() ? " (drops)" : " (no drops)") : "";
            this.rulesList.addItem("Speed: " + speed + correctForDrops);
        }
    }

    private void saveTool() {
        float defaultSpeed = 1.0f;
        try {
            defaultSpeed = Float.parseFloat(this.defaultMiningSpeedInput.getValue());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int damagePerBlock = 1;
        try {
            damagePerBlock = Integer.parseInt(this.damagePerBlockInput.getValue());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        class_9424 tool = new class_9424(this.rules, defaultSpeed, damagePerBlock);
        if (this.onSave != null) {
            this.onSave.accept(tool);
        }
    }
}

