/*
 * Decompiled with CFR 0.152.
 */
package net.jackson.simplegui;

import java.util.Optional;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jackson.simplegui.SimpleGuiScreen;
import net.jackson.simplegui.widget.ButtonWidget;
import net.jackson.simplegui.widget.DropdownWidget;
import net.jackson.simplegui.widget.LabelWidget;
import net.jackson.simplegui.widget.TextBoxWidget;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import net.minecraft.class_9424;

@Environment(value=EnvType.CLIENT)
public class ToolRuleEditorGui
extends SimpleGuiScreen {
    private final Consumer<class_9424.class_9425> onSave;
    private DropdownWidget blockTagDropdown;
    private TextBoxWidget speedInput;
    private ButtonWidget correctForDropsToggle;
    private DropdownWidget speedPresetDropdown;
    private Boolean correctForDrops = null;

    public ToolRuleEditorGui(class_437 parent, class_9424.class_9425 initial, Consumer<class_9424.class_9425> onSave) {
        super("Tool Rule Editor", parent);
        this.onSave = onSave;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        int panelWidth = 320;
        int panelX = centerX - panelWidth / 2;
        LabelWidget title = new LabelWidget("title", centerX, 10, "\u00a76\u00a7lTool Rule Editor", -1, true, true);
        this.addWidget(title);
        LabelWidget tagLabel = new LabelWidget("tag_label", panelX, 35, "\u00a7eBlock Tag:", -1, false, false);
        this.addWidget(tagLabel);
        this.blockTagDropdown = new DropdownWidget("block_tag", panelX, 50, panelWidth, 20);
        this.blockTagDropdown.addOption("mineable/axe");
        this.blockTagDropdown.addOption("mineable/pickaxe");
        this.blockTagDropdown.addOption("mineable/shovel");
        this.blockTagDropdown.addOption("mineable/hoe");
        this.blockTagDropdown.addOption("mineable/sword");
        this.blockTagDropdown.addOption("needs_stone_tool");
        this.blockTagDropdown.addOption("needs_iron_tool");
        this.blockTagDropdown.addOption("needs_diamond_tool");
        this.blockTagDropdown.addOption("wool");
        this.blockTagDropdown.addOption("logs");
        this.blockTagDropdown.addOption("leaves");
        this.addWidget(this.blockTagDropdown);
        LabelWidget presetLabel = new LabelWidget("preset_label", panelX, 85, "\u00a7eSpeed Preset:", -1, false, false);
        this.addWidget(presetLabel);
        this.speedPresetDropdown = new DropdownWidget("speed_preset", panelX, 100, panelWidth, 20);
        this.speedPresetDropdown.addOption("Instant Break");
        this.speedPresetDropdown.addOption("Very Fast (10x)");
        this.speedPresetDropdown.addOption("Fast (5x)");
        this.speedPresetDropdown.addOption("Faster (2x)");
        this.speedPresetDropdown.addOption("Normal (1x)");
        this.speedPresetDropdown.addOption("Slower (0.5x)");
        this.speedPresetDropdown.addOption("Custom...");
        this.speedPresetDropdown.setSelectedIndex(4);
        this.speedPresetDropdown.setOnChanged(idx -> {
            if (idx < 6) {
                float speed;
                switch (idx) {
                    case 1: {
                        float f = 10.0f;
                        break;
                    }
                    case 2: {
                        float f = 5.0f;
                        break;
                    }
                    case 3: {
                        float f = 2.0f;
                        break;
                    }
                    case 4: {
                        float f = 1.0f;
                        break;
                    }
                    case 5: {
                        float f = 0.5f;
                        break;
                    }
                    default: {
                        float f = speed = 0.0f;
                    }
                }
                if (idx == 0) {
                    this.speedInput.setValue("instant");
                } else {
                    this.speedInput.setValue(String.valueOf(speed));
                }
            }
        });
        this.addWidget(this.speedPresetDropdown);
        LabelWidget speedLabel = new LabelWidget("speed_label", panelX, 135, "\u00a7eMining Speed Multiplier:", -1, false, false);
        this.addWidget(speedLabel);
        this.speedInput = new TextBoxWidget("speed_input", panelX, 150, panelWidth, 20, -14671840, -8355712, -1, -10461088);
        this.speedInput.setValue("1.0");
        this.speedInput.setMaxLength(10);
        this.speedInput.setHint("1.0 or 'instant'");
        this.addWidget(this.speedInput);
        LabelWidget dropsLabel = new LabelWidget("drops_label", panelX, 185, "\u00a7eCorrect For Drops:", -1, false, false);
        this.addWidget(dropsLabel);
        this.correctForDropsToggle = new ButtonWidget("drops_toggle", panelX, 200, 150, 20, "\u00a77Not Set", -12961222, -11908534, -1);
        this.correctForDropsToggle.setOnPress(() -> {
            if (this.correctForDrops == null) {
                this.correctForDrops = true;
                this.correctForDropsToggle.setText("\u00a7aYes");
            } else if (this.correctForDrops.booleanValue()) {
                this.correctForDrops = false;
                this.correctForDropsToggle.setText("\u00a7cNo");
            } else {
                this.correctForDrops = null;
                this.correctForDropsToggle.setText("\u00a77Not Set");
            }
        });
        this.addWidget(this.correctForDropsToggle);
        LabelWidget infoLabel = new LabelWidget("info_label", panelX, 235, "\u00a77Correct for drops: Tool must be correct", -5592406, false, false);
        this.addWidget(infoLabel);
        LabelWidget info2Label = new LabelWidget("info2_label", panelX, 250, "\u00a77to get block drops (like silk touch requirement)", -5592406, false, false);
        this.addWidget(info2Label);
        ButtonWidget saveBtn = new ButtonWidget("save", centerX - 105, this.field_22790 - 35, 100, 20, "Add", -13996502, -13004999, -1);
        saveBtn.setOnPress(() -> {
            this.saveRule();
            this.method_25419();
        });
        this.addWidget(saveBtn);
        ButtonWidget cancelBtn = new ButtonWidget("cancel", centerX + 5, this.field_22790 - 35, 100, 20, "Cancel", -9737365, -7697782, -1);
        cancelBtn.setOnPress(this::method_25419);
        this.addWidget(cancelBtn);
    }

    private void saveRule() {
        Optional<Object> speed;
        Object blocks;
        String tagName = this.blockTagDropdown.getSelectedOption();
        class_2960 tagLocation = class_2960.method_60656((String)tagName);
        try {
            class_2378 registry;
            Optional tag;
            blocks = this.field_22787 != null && this.field_22787.field_1687 != null ? ((tag = (registry = this.field_22787.field_1687.method_30349().method_30530(class_7924.field_41254)).method_46733(class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)tagLocation))).isPresent() ? (class_6885)tag.get() : class_6885.method_40246((class_6880[])new class_6880[0])) : class_6885.method_40246((class_6880[])new class_6880[0]);
        }
        catch (Exception e) {
            blocks = class_6885.method_40246((class_6880[])new class_6880[0]);
        }
        String speedStr = this.speedInput.getValue().trim();
        if (speedStr.equalsIgnoreCase("instant")) {
            speed = Optional.empty();
        } else {
            try {
                speed = Optional.of(Float.valueOf(Float.parseFloat(speedStr)));
            }
            catch (NumberFormatException e) {
                speed = Optional.of(Float.valueOf(1.0f));
            }
        }
        Optional drops = this.correctForDrops == null ? Optional.empty() : Optional.of(this.correctForDrops);
        class_9424.class_9425 rule = new class_9424.class_9425((class_6885)blocks, speed, drops);
        if (this.onSave != null) {
            this.onSave.accept(rule);
        }
    }
}

