/*
 * Decompiled with CFR 0.152.
 */
package net.jackson.simplegui;

import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jackson.simplegui.SimpleGuiScreen;
import net.jackson.simplegui.widget.ButtonWidget;
import net.jackson.simplegui.widget.LabelWidget;
import net.jackson.simplegui.widget.TextBoxWidget;
import net.minecraft.class_10130;
import net.minecraft.class_2561;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class UseCooldownEditorGui
extends SimpleGuiScreen {
    private final Consumer<class_10130> onSave;
    private TextBoxWidget secondsField;
    private float currentSeconds = 0.0f;

    public UseCooldownEditorGui(class_437 parent, class_10130 current, Consumer<class_10130> onSave) {
        super("Use Cooldown Editor", parent);
        this.onSave = onSave;
        if (current != null) {
            this.currentSeconds = current.comp_3091();
        }
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        int panelWidth = 300;
        int panelX = centerX - panelWidth / 2;
        LabelWidget title = new LabelWidget("title", centerX, 10, "\u00a76\u00a7lUse Cooldown Editor", -1, true, true);
        this.addWidget(title);
        LabelWidget instructions = new LabelWidget("instructions", centerX, 30, "\u00a77Set the cooldown in seconds", -5592406, true, false);
        this.addWidget(instructions);
        LabelWidget secondsLabel = new LabelWidget("seconds_label", panelX, 60, "Cooldown (seconds):", -5592406, false, false);
        this.addWidget(secondsLabel);
        this.secondsField = new TextBoxWidget("seconds", panelX, 80, panelWidth, 20, -14671840, -8355712, -1, -10461088);
        this.secondsField.setValue(String.valueOf(this.currentSeconds));
        this.secondsField.setMaxLength(10);
        this.secondsField.setHint("Enter seconds (e.g., 1.5)");
        this.addWidget(this.secondsField);
        LabelWidget info = new LabelWidget("info", panelX, 110, "\u00a77Examples: 1.0 = 1 second, 0.5 = half second", -8355712, false, false);
        this.addWidget(info);
        LabelWidget ticksLabel = new LabelWidget("ticks_label", panelX, 130, "\u00a77(1 second = 20 ticks)", -8355712, false, false);
        this.addWidget(ticksLabel);
        ButtonWidget saveBtn = new ButtonWidget("save", centerX - 105, this.field_22790 - 35, 100, 20, "Save", -13996502, -13004999, -1);
        saveBtn.setOnPress(this::save);
        this.addWidget(saveBtn);
        ButtonWidget cancelBtn = new ButtonWidget("cancel", centerX + 5, this.field_22790 - 35, 100, 20, "Cancel", -9737365, -7697782, -1);
        cancelBtn.setOnPress(this::method_25419);
        this.addWidget(cancelBtn);
    }

    private void save() {
        try {
            float seconds = Float.parseFloat(this.secondsField.getValue());
            if (seconds < 0.0f) {
                this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cCooldown must be non-negative!"), false);
                return;
            }
            class_10130 cooldown = new class_10130(seconds);
            if (this.onSave != null) {
                this.onSave.accept(cooldown);
            }
            this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u00a7aUse cooldown set to " + seconds + " seconds")), false);
            this.method_25419();
        }
        catch (NumberFormatException e) {
            this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cInvalid number format!"), false);
        }
    }
}

