/*
 * Decompiled with CFR 0.152.
 */
package net.jackson.simplegui.widget;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jackson.simplegui.widget.GuiWidget;
import net.minecraft.class_1799;
import net.minecraft.class_332;
import net.minecraft.class_3532;

@Environment(value=EnvType.CLIENT)
public class ScrollMenuWidget
extends GuiWidget {
    private final List<String> items = new ArrayList<String>();
    private final Map<Integer, class_1799> itemOverlays = new HashMap<Integer, class_1799>();
    private int scrollOffset = 0;
    private int itemHeight = 20;
    private final int backgroundColor;
    private final int itemColor;
    private final int hoverColor;
    private final int textColor;
    private final int scrollbarColor;
    private int selectedIndex = -1;
    private boolean isDraggingScrollbar = false;
    private int dragStartY = 0;
    private int dragStartScroll = 0;

    public ScrollMenuWidget(String id, int x, int y, int width, int height) {
        this(id, x, y, width, height, -16777216, -14671840, -12566464, -1, -8355712);
    }

    public ScrollMenuWidget(String id, int x, int y, int width, int height, int backgroundColor, int itemColor, int hoverColor, int textColor, int scrollbarColor) {
        super(id, x, y, width, height);
        this.backgroundColor = backgroundColor;
        this.itemColor = itemColor;
        this.hoverColor = hoverColor;
        this.textColor = textColor;
        this.scrollbarColor = scrollbarColor;
    }

    public void addItem(String item) {
        this.items.add(item);
    }

    public void setItems(List<String> items) {
        this.items.clear();
        this.items.addAll(items);
        this.scrollOffset = 0;
    }

    public void clearItems() {
        this.items.clear();
        this.itemOverlays.clear();
        this.scrollOffset = 0;
        this.selectedIndex = -1;
    }

    public void setItemOverlay(int index, class_1799 itemStack) {
        if (index >= 0 && index < this.items.size()) {
            if (itemStack != null && !itemStack.method_7960()) {
                this.itemOverlays.put(index, itemStack);
            } else {
                this.itemOverlays.remove(index);
            }
        }
    }

    public int getItemCount() {
        return this.items.size();
    }

    public void setItemHeight(int itemHeight) {
        this.itemHeight = itemHeight;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public String getSelectedItem() {
        if (this.selectedIndex >= 0 && this.selectedIndex < this.items.size()) {
            return this.items.get(this.selectedIndex);
        }
        return null;
    }

    public List<String> getItems() {
        return new ArrayList<String>(this.items);
    }

    @Override
    public void render(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        if (!this.visible) {
            return;
        }
        graphics.method_25294(this.x, this.y, this.x + this.width, this.y + this.height, this.backgroundColor);
        graphics.method_25294(this.x, this.y, this.x + this.width, this.y + 1, -6250336);
        graphics.method_25294(this.x, this.y, this.x + 1, this.y + this.height, -6250336);
        graphics.method_25294(this.x + this.width - 1, this.y, this.x + this.width, this.y + this.height, -16777216);
        graphics.method_25294(this.x, this.y + this.height - 1, this.x + this.width, this.y + this.height, -16777216);
        int visibleItems = this.height / this.itemHeight;
        int totalHeight = this.items.size() * this.itemHeight;
        int maxScroll = Math.max(0, totalHeight - this.height);
        this.scrollOffset = class_3532.method_15340((int)this.scrollOffset, (int)0, (int)maxScroll);
        int startIndex = this.scrollOffset / this.itemHeight;
        int endIndex = Math.min(this.items.size(), startIndex + visibleItems + 2);
        graphics.method_44379(this.x + 1, this.y + 1, this.x + this.width - 9, this.y + this.height - 1);
        for (int i = startIndex; i < endIndex; ++i) {
            boolean isSelected;
            int itemY = this.y + i * this.itemHeight - this.scrollOffset;
            if (itemY + this.itemHeight < this.y || itemY > this.y + this.height) continue;
            boolean isHovered = !this.isDraggingScrollbar && mouseX >= this.x + 1 && mouseX < this.x + this.width - 9 && mouseY >= itemY && mouseY < itemY + this.itemHeight;
            boolean bl = isSelected = i == this.selectedIndex;
            int color = isSelected ? this.hoverColor : (isHovered ? this.itemColor + 0x101010 : this.itemColor);
            graphics.method_25294(this.x + 1, itemY, this.x + this.width - 9, itemY + this.itemHeight, color);
            class_1799 overlay = this.itemOverlays.get(i);
            int textX = this.x + 4;
            if (overlay != null && !overlay.method_7960()) {
                graphics.method_51427(overlay, this.x + 4, itemY + (this.itemHeight - 16) / 2);
                textX = this.x + 24;
            }
            String itemText = this.items.get(i);
            int textY = itemY + (this.itemHeight - 8) / 2;
            graphics.method_51433(this.minecraft.field_1772, itemText, textX, textY, this.textColor, false);
        }
        graphics.method_44380();
        if (totalHeight > this.height) {
            int scrollbarX = this.x + this.width - 8;
            int scrollbarHeight = Math.max(20, this.height * this.height / totalHeight);
            int scrollbarY = this.y + (int)((float)this.scrollOffset / (float)maxScroll * (float)(this.height - scrollbarHeight));
            graphics.method_25294(scrollbarX, this.y, this.x + this.width - 1, this.y + this.height, -15724528);
            boolean scrollbarHovered = mouseX >= scrollbarX && mouseX < this.x + this.width - 1 && mouseY >= scrollbarY && mouseY < scrollbarY + scrollbarHeight;
            int thumbColor = scrollbarHovered || this.isDraggingScrollbar ? this.scrollbarColor + 0x202020 : this.scrollbarColor;
            graphics.method_25294(scrollbarX, scrollbarY, this.x + this.width - 1, scrollbarY + scrollbarHeight, thumbColor);
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int relativeY;
        int clickedIndex;
        if (!this.visible || !this.enabled || button != 0) {
            return false;
        }
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        int totalHeight = this.items.size() * this.itemHeight;
        if (totalHeight > this.height) {
            int scrollbarX = this.x + this.width - 8;
            int maxScroll = Math.max(0, totalHeight - this.height);
            int scrollbarHeight = Math.max(20, this.height * this.height / totalHeight);
            int scrollbarY = this.y + (int)((float)this.scrollOffset / (float)maxScroll * (float)(this.height - scrollbarHeight));
            if (mouseX >= (double)scrollbarX && mouseX < (double)(this.x + this.width - 1) && mouseY >= (double)scrollbarY && mouseY < (double)(scrollbarY + scrollbarHeight)) {
                this.isDraggingScrollbar = true;
                this.dragStartY = (int)mouseY;
                this.dragStartScroll = this.scrollOffset;
                return true;
            }
        }
        if (mouseX >= (double)(this.x + 1) && mouseX < (double)(this.x + this.width - 9) && (clickedIndex = (relativeY = (int)mouseY - this.y + this.scrollOffset) / this.itemHeight) >= 0 && clickedIndex < this.items.size()) {
            this.selectedIndex = clickedIndex;
            return true;
        }
        return true;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.isDraggingScrollbar = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.isDraggingScrollbar) {
            return false;
        }
        int totalHeight = this.items.size() * this.itemHeight;
        int maxScroll = Math.max(0, totalHeight - this.height);
        int scrollbarHeight = Math.max(20, this.height * this.height / totalHeight);
        int deltaY = (int)mouseY - this.dragStartY;
        int scrollDelta = (int)((float)deltaY / (float)(this.height - scrollbarHeight) * (float)maxScroll);
        this.scrollOffset = class_3532.method_15340((int)(this.dragStartScroll + scrollDelta), (int)0, (int)maxScroll);
        return true;
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (!this.visible || !this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        int totalHeight = this.items.size() * this.itemHeight;
        int maxScroll = Math.max(0, totalHeight - this.height);
        this.scrollOffset = class_3532.method_15340((int)(this.scrollOffset - (int)(scrollY * (double)this.itemHeight)), (int)0, (int)maxScroll);
        return true;
    }
}

