/*
 * Decompiled with CFR 0.152.
 */
package net.jackson.simplegui.widget;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jackson.simplegui.widget.GuiWidget;
import net.minecraft.class_1799;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class SearchableDropdownWidget
extends GuiWidget {
    private final List<String> allOptions = new ArrayList<String>();
    private final List<String> filteredOptions = new ArrayList<String>();
    private final Map<Integer, class_1799> itemOverlays = new HashMap<Integer, class_1799>();
    private int selectedIndex = 0;
    private boolean expanded = false;
    private final int backgroundColor;
    private final int hoverColor;
    private final int textColor;
    private Consumer<Integer> onChanged;
    private String searchText = "";
    private boolean searchFocused = false;
    private int scrollOffset = 0;
    private int cursorPosition = 0;
    private long lastCursorToggle = 0L;

    public SearchableDropdownWidget(String id, int x, int y, int width, int height) {
        this(id, x, y, width, height, -16777216, -13619152, -1);
    }

    public SearchableDropdownWidget(String id, int x, int y, int width, int height, int backgroundColor, int hoverColor, int textColor) {
        super(id, x, y, width, height);
        this.backgroundColor = backgroundColor;
        this.hoverColor = hoverColor;
        this.textColor = textColor;
    }

    public void addOption(String option) {
        this.allOptions.add(option);
        this.updateFilteredOptions();
    }

    public void setOptions(List<String> options) {
        this.allOptions.clear();
        this.allOptions.addAll(options);
        this.updateFilteredOptions();
        if (this.selectedIndex >= this.allOptions.size()) {
            this.selectedIndex = Math.max(0, this.allOptions.size() - 1);
        }
        this.scrollOffset = 0;
    }

    private void updateFilteredOptions() {
        this.filteredOptions.clear();
        String search = this.searchText.toLowerCase();
        for (String option : this.allOptions) {
            if (!option.toLowerCase().contains(search)) continue;
            this.filteredOptions.add(option);
        }
    }

    public void setSelectedIndex(int index) {
        if (index >= 0 && index < this.allOptions.size()) {
            this.selectedIndex = index;
            if (this.onChanged != null) {
                this.onChanged.accept(this.selectedIndex);
            }
        }
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public String getSelectedOption() {
        if (this.selectedIndex >= 0 && this.selectedIndex < this.allOptions.size()) {
            return this.allOptions.get(this.selectedIndex);
        }
        return "";
    }

    public List<String> getOptions() {
        return new ArrayList<String>(this.allOptions);
    }

    public void setOnChanged(Consumer<Integer> onChanged) {
        this.onChanged = onChanged;
    }

    public void setItemOverlay(int index, class_1799 itemStack) {
        if (index >= 0 && index < this.allOptions.size()) {
            if (itemStack != null && !itemStack.method_7960()) {
                this.itemOverlays.put(index, itemStack);
            } else {
                this.itemOverlays.remove(index);
            }
        }
    }

    public void setItemOverlays(Map<Integer, class_1799> overlays) {
        this.itemOverlays.clear();
        if (overlays != null) {
            this.itemOverlays.putAll(overlays);
        }
    }

    public void clearItemOverlays() {
        this.itemOverlays.clear();
    }

    public class_1799 getItemOverlay(int index) {
        return this.itemOverlays.get(index);
    }

    @Override
    public void render(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        if (!this.visible) {
            return;
        }
        boolean mainHovered = !this.expanded && this.isMouseOver(mouseX, mouseY);
        int mainColor = mainHovered ? this.hoverColor : this.backgroundColor;
        graphics.method_25294(this.x, this.y, this.x + this.width, this.y + this.height, mainColor);
        graphics.method_25294(this.x, this.y, this.x + this.width, this.y + 1, -1);
        graphics.method_25294(this.x, this.y, this.x + 1, this.y + this.height, -1);
        graphics.method_25294(this.x + this.width - 1, this.y, this.x + this.width, this.y + this.height, -16777216);
        graphics.method_25294(this.x, this.y + this.height - 1, this.x + this.width, this.y + this.height, -16777216);
        if (this.expanded && this.searchFocused) {
            int textX = this.x + 4;
            int textY = this.y + (this.height - 8) / 2;
            String displayText = this.searchText.isEmpty() ? "Type to search..." : this.searchText;
            int color = this.searchText.isEmpty() ? -8355712 : this.textColor;
            graphics.method_51433(this.minecraft.field_1772, displayText, textX, textY, color, false);
            if (System.currentTimeMillis() - this.lastCursorToggle < 500L) {
                int cursorX = textX + this.minecraft.field_1772.method_1727(this.searchText.substring(0, Math.min(this.cursorPosition, this.searchText.length())));
                graphics.method_25294(cursorX, textY - 1, cursorX + 1, textY + 9, -1);
            }
            if (System.currentTimeMillis() - this.lastCursorToggle >= 1000L) {
                this.lastCursorToggle = System.currentTimeMillis();
            }
        } else {
            String sel = this.getSelectedOption();
            int textX = this.x + 4;
            int textY = this.y + (this.height - 8) / 2;
            class_1799 overlay = this.itemOverlays.get(this.selectedIndex);
            if (overlay != null && !overlay.method_7960()) {
                graphics.method_51427(overlay, this.x + 2, this.y + (this.height - 16) / 2);
                textX += 20;
            }
            graphics.method_51433(this.minecraft.field_1772, sel, textX, textY, this.textColor, false);
        }
        int arrowX = this.x + this.width - 12;
        int arrowY = this.y + this.height / 2;
        if (!this.expanded) {
            graphics.method_25294(arrowX + 2, arrowY - 1, arrowX + 7, arrowY, this.textColor);
            graphics.method_25294(arrowX + 3, arrowY, arrowX + 6, arrowY + 1, this.textColor);
            graphics.method_25294(arrowX + 4, arrowY + 1, arrowX + 5, arrowY + 2, this.textColor);
        } else {
            graphics.method_25294(arrowX + 4, arrowY - 2, arrowX + 5, arrowY - 1, this.textColor);
            graphics.method_25294(arrowX + 3, arrowY - 1, arrowX + 6, arrowY, this.textColor);
            graphics.method_25294(arrowX + 2, arrowY, arrowX + 7, arrowY + 1, this.textColor);
        }
    }

    @Override
    public void renderOverlay(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        int optIndex;
        if (!this.visible || !this.expanded) {
            return;
        }
        int itemHeight = 20;
        int spaceBelow = this.screen.field_22790 - (this.y + this.height) - 6;
        int maxVisible = Math.max(5, Math.min(15, spaceBelow / itemHeight));
        int totalItems = this.filteredOptions.size();
        int visibleItems = Math.min(totalItems, maxVisible);
        int expandedHeight = visibleItems * itemHeight + 2;
        int listTop = this.y + this.height;
        graphics.method_25294(this.x, listTop, this.x + this.width, listTop + expandedHeight, -15066598);
        graphics.method_25294(this.x, listTop, this.x + this.width, listTop + 1, -1);
        graphics.method_25294(this.x, listTop, this.x + 1, listTop + expandedHeight, -1);
        graphics.method_25294(this.x + this.width - 1, listTop, this.x + this.width, listTop + expandedHeight, -16777216);
        graphics.method_25294(this.x, listTop + expandedHeight - 1, this.x + this.width, listTop + expandedHeight, -16777216);
        graphics.method_44379(this.x + 1, listTop + 1, this.x + this.width - 1, listTop + expandedHeight - 1);
        int hoveredIndex = -1;
        if (mouseX >= this.x && mouseX < this.x + this.width - 10 && mouseY >= listTop && mouseY < listTop + expandedHeight) {
            hoveredIndex = (mouseY - listTop) / itemHeight + this.scrollOffset;
        }
        for (int i = 0; i < visibleItems && (optIndex = i + this.scrollOffset) < totalItems; ++i) {
            boolean isSelected;
            String filteredOption = this.filteredOptions.get(optIndex);
            int actualIndex = this.allOptions.indexOf(filteredOption);
            int rowTop = listTop + 1 + i * itemHeight;
            boolean isHovered = optIndex == hoveredIndex;
            boolean bl = isSelected = actualIndex == this.selectedIndex;
            int rowColor = isSelected ? -14013842 : (isHovered ? this.hoverColor : this.backgroundColor);
            graphics.method_25294(this.x + 1, rowTop, this.x + this.width - 11, rowTop + itemHeight, rowColor);
            class_1799 overlay = this.itemOverlays.get(actualIndex);
            int textX = this.x + 4;
            if (overlay != null && !overlay.method_7960()) {
                graphics.method_51427(overlay, this.x + 2, rowTop + 2);
                textX += 20;
            }
            int rowTextY = rowTop + (itemHeight - 8) / 2;
            if (!this.searchText.isEmpty()) {
                String searchLower;
                String optLower = filteredOption.toLowerCase();
                int matchIndex = optLower.indexOf(searchLower = this.searchText.toLowerCase());
                if (matchIndex >= 0) {
                    String before = filteredOption.substring(0, matchIndex);
                    String match = filteredOption.substring(matchIndex, matchIndex + this.searchText.length());
                    String after = filteredOption.substring(matchIndex + this.searchText.length());
                    graphics.method_51433(this.minecraft.field_1772, before, textX, rowTextY, this.textColor, false);
                    int matchX = textX + this.minecraft.field_1772.method_1727(before);
                    graphics.method_51433(this.minecraft.field_1772, match, matchX, rowTextY, -256, false);
                    int afterX = matchX + this.minecraft.field_1772.method_1727(match);
                    graphics.method_51433(this.minecraft.field_1772, after, afterX, rowTextY, this.textColor, false);
                    continue;
                }
                graphics.method_51433(this.minecraft.field_1772, filteredOption, textX, rowTextY, this.textColor, false);
                continue;
            }
            graphics.method_51433(this.minecraft.field_1772, filteredOption, textX, rowTextY, this.textColor, false);
        }
        graphics.method_44380();
        if (totalItems > visibleItems) {
            int barX = this.x + this.width - 9;
            int barTop = listTop + 2;
            int barBottom = listTop + expandedHeight - 2;
            int barHeight = barBottom - barTop;
            graphics.method_25294(barX, barTop, barX + 6, barBottom, -16119286);
            int thumbHeight = Math.max(10, barHeight * visibleItems / totalItems);
            int maxScroll = Math.max(1, totalItems - visibleItems);
            int thumbTop = barTop + this.scrollOffset * (barHeight - thumbHeight) / maxScroll;
            graphics.method_25294(barX + 1, thumbTop, barX + 5, thumbTop + thumbHeight, -10461088);
        }
        if (totalItems == 0 && !this.searchText.isEmpty()) {
            int msgY = listTop + 10;
            graphics.method_51433(this.minecraft.field_1772, "No matches found", this.x + 10, msgY, -8355712, false);
        }
    }

    @Override
    public boolean hasOverlayActive() {
        return this.expanded && this.visible && this.enabled;
    }

    @Override
    public void closeOverlay() {
        this.expanded = false;
        this.searchFocused = false;
        this.searchText = "";
        this.scrollOffset = 0;
        this.cursorPosition = 0;
        this.updateFilteredOptions();
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.visible || !this.enabled || button != 0) {
            return false;
        }
        if (!this.expanded) {
            if (this.isMouseOver(mouseX, mouseY)) {
                this.expanded = true;
                this.searchFocused = true;
                this.searchText = "";
                this.cursorPosition = 0;
                this.scrollOffset = 0;
                this.updateFilteredOptions();
                this.lastCursorToggle = System.currentTimeMillis();
                return true;
            }
            return false;
        }
        int itemHeight = 20;
        int listTop = this.y + this.height;
        int spaceBelow = this.screen.field_22790 - (this.y + this.height) - 6;
        int maxVisible = Math.max(5, Math.min(15, spaceBelow / itemHeight));
        int visibleItems = Math.min(this.filteredOptions.size(), maxVisible);
        int expandedHeight = visibleItems * itemHeight + 2;
        if (mouseX >= (double)this.x && mouseX < (double)(this.x + this.width - 10) && mouseY >= (double)listTop && mouseY < (double)(listTop + expandedHeight)) {
            int localRow = (int)((mouseY - (double)listTop) / (double)itemHeight);
            int index = this.scrollOffset + localRow;
            if (index >= 0 && index < this.filteredOptions.size()) {
                String selected = this.filteredOptions.get(index);
                int actualIndex = this.allOptions.indexOf(selected);
                this.setSelectedIndex(actualIndex);
            }
            this.closeOverlay();
            return true;
        }
        this.closeOverlay();
        return true;
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (!this.visible || !this.expanded) {
            return false;
        }
        int itemHeight = 20;
        int spaceBelow = this.screen.field_22790 - (this.y + this.height) - 6;
        int maxVisible = Math.max(5, Math.min(15, spaceBelow / itemHeight));
        int visibleItems = Math.min(this.filteredOptions.size(), maxVisible);
        if (this.filteredOptions.size() > visibleItems) {
            int maxOffset = Math.max(0, this.filteredOptions.size() - visibleItems);
            this.scrollOffset = Math.max(0, Math.min(maxOffset, this.scrollOffset - (int)scrollY));
            return true;
        }
        return false;
    }

    @Override
    public boolean charTyped(char chr, int modifiers) {
        if (!(this.visible && this.expanded && this.searchFocused)) {
            return false;
        }
        if (Character.isLetterOrDigit(chr) || Character.isWhitespace(chr) || chr == '_' || chr == '-' || chr == ':') {
            this.searchText = this.searchText.substring(0, this.cursorPosition) + chr + this.searchText.substring(this.cursorPosition);
            ++this.cursorPosition;
            this.scrollOffset = 0;
            this.updateFilteredOptions();
            this.lastCursorToggle = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (!(this.visible && this.expanded && this.searchFocused)) {
            return false;
        }
        if (keyCode == 259 && this.cursorPosition > 0) {
            this.searchText = this.searchText.substring(0, this.cursorPosition - 1) + this.searchText.substring(this.cursorPosition);
            --this.cursorPosition;
            this.scrollOffset = 0;
            this.updateFilteredOptions();
            this.lastCursorToggle = System.currentTimeMillis();
            return true;
        }
        if (keyCode == 261 && this.cursorPosition < this.searchText.length()) {
            this.searchText = this.searchText.substring(0, this.cursorPosition) + this.searchText.substring(this.cursorPosition + 1);
            this.updateFilteredOptions();
            this.lastCursorToggle = System.currentTimeMillis();
            return true;
        }
        if (keyCode == 263 && this.cursorPosition > 0) {
            --this.cursorPosition;
            this.lastCursorToggle = System.currentTimeMillis();
            return true;
        }
        if (keyCode == 262 && this.cursorPosition < this.searchText.length()) {
            ++this.cursorPosition;
            this.lastCursorToggle = System.currentTimeMillis();
            return true;
        }
        if (keyCode == 256) {
            this.closeOverlay();
            return true;
        }
        if (keyCode == 257) {
            if (!this.filteredOptions.isEmpty()) {
                String selected = this.filteredOptions.get(Math.min(this.scrollOffset, this.filteredOptions.size() - 1));
                int actualIndex = this.allOptions.indexOf(selected);
                this.setSelectedIndex(actualIndex);
            }
            this.closeOverlay();
            return true;
        }
        return false;
    }
}

