/*
 * Decompiled with CFR 0.152.
 */
package net.jackson.simplegui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jackson.simplegui.AttributeModifierEditorGui;
import net.jackson.simplegui.SimpleGuiScreen;
import net.jackson.simplegui.widget.ButtonWidget;
import net.jackson.simplegui.widget.DropdownWidget;
import net.jackson.simplegui.widget.LabelWidget;
import net.jackson.simplegui.widget.TextBoxWidget;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9274;

@Environment(value=EnvType.CLIENT)
public class AttributeCustomizerGui
extends SimpleGuiScreen {
    private final AttributeModifierEditorGui.ModifierEntry existingEntry;
    private final Consumer<AttributeModifierEditorGui.ModifierEntry> onSave;
    private DropdownWidget attributeDropdown;
    private TextBoxWidget amountInput;
    private DropdownWidget operationDropdown;
    private DropdownWidget slotDropdown;
    private final List<class_6880<class_1320>> allAttributes = new ArrayList<class_6880<class_1320>>();

    public AttributeCustomizerGui(class_437 parent, AttributeModifierEditorGui.ModifierEntry existingEntry, Consumer<AttributeModifierEditorGui.ModifierEntry> onSave) {
        super("Attribute Customizer", parent);
        this.existingEntry = existingEntry;
        this.onSave = onSave;
        for (Map.Entry entry : class_7923.field_41190.method_29722()) {
            this.allAttributes.add((class_6880<class_1320>)class_7923.field_41190.method_47983((Object)((class_1320)entry.getValue())));
        }
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        int panelWidth = 350;
        int panelX = centerX - panelWidth / 2;
        int yPos = 40;
        LabelWidget title = new LabelWidget("title", centerX, 10, "\u00a76\u00a7l" + (this.existingEntry == null ? "Add Attribute" : "Edit Attribute"), -1, true, true);
        this.addWidget(title);
        LabelWidget attributeLabel = new LabelWidget("attribute_label", panelX, yPos, "\u00a7eAttribute Type:", -1, false, false);
        this.addWidget(attributeLabel);
        this.attributeDropdown = new DropdownWidget("attribute_dropdown", panelX, yPos += 20, panelWidth, 20);
        int selectedAttributeIndex = 0;
        for (int i = 0; i < this.allAttributes.size(); ++i) {
            class_6880<class_1320> attr = this.allAttributes.get(i);
            Optional key = attr.method_40230();
            String name = key.isPresent() ? ((class_5321)key.get()).method_29177().method_12832().replace("_", " ") : "unknown";
            this.attributeDropdown.addOption(name);
            if (this.existingEntry == null || !attr.equals(this.existingEntry.attribute())) continue;
            selectedAttributeIndex = i;
        }
        this.attributeDropdown.setSelectedIndex(selectedAttributeIndex);
        this.addWidget(this.attributeDropdown);
        LabelWidget amountLabel = new LabelWidget("amount_label", panelX, yPos += 30, "\u00a7eAmount:", -1, false, false);
        this.addWidget(amountLabel);
        this.amountInput = new TextBoxWidget("amount_input", panelX, yPos += 20, panelWidth, 20);
        this.amountInput.setValue(this.existingEntry != null ? String.valueOf(this.existingEntry.modifier().comp_2449()) : "1.0");
        this.amountInput.setMaxLength(16);
        this.amountInput.setHint("Enter numeric value");
        this.addWidget(this.amountInput);
        LabelWidget operationLabel = new LabelWidget("operation_label", panelX, yPos += 30, "\u00a7eOperation:", -1, false, false);
        this.addWidget(operationLabel);
        this.operationDropdown = new DropdownWidget("operation_dropdown", panelX, yPos += 20, panelWidth, 20);
        this.operationDropdown.addOption("add_value (Adds value)");
        this.operationDropdown.addOption("add_multiplied_base (Adds % of base)");
        this.operationDropdown.addOption("add_multiplied_total (Multiplies total)");
        if (this.existingEntry != null) {
            this.operationDropdown.setSelectedIndex(this.existingEntry.modifier().comp_2450().ordinal());
        }
        this.addWidget(this.operationDropdown);
        LabelWidget slotLabel = new LabelWidget("slot_label", panelX, yPos += 30, "\u00a7eEquipment Slot:", -1, false, false);
        this.addWidget(slotLabel);
        this.slotDropdown = new DropdownWidget("slot_dropdown", panelX, yPos += 20, panelWidth, 20);
        this.slotDropdown.addOption("any");
        this.slotDropdown.addOption("mainhand");
        this.slotDropdown.addOption("offhand");
        this.slotDropdown.addOption("hand");
        this.slotDropdown.addOption("feet");
        this.slotDropdown.addOption("legs");
        this.slotDropdown.addOption("chest");
        this.slotDropdown.addOption("head");
        this.slotDropdown.addOption("armor");
        this.slotDropdown.addOption("body");
        if (this.existingEntry != null) {
            String slotName;
            int slotIndex = switch (slotName = this.existingEntry.slot().toString().toLowerCase()) {
                case "mainhand" -> 1;
                case "offhand" -> 2;
                case "hand" -> 3;
                case "feet" -> 4;
                case "legs" -> 5;
                case "chest" -> 6;
                case "head" -> 7;
                case "armor" -> 8;
                case "body" -> 9;
                default -> 0;
            };
            this.slotDropdown.setSelectedIndex(slotIndex);
        }
        this.addWidget(this.slotDropdown);
        LabelWidget infoLabel = new LabelWidget("info_label", panelX, yPos += 30, "\u00a77Operation determines how the value is applied:", -5592406, false, false);
        this.addWidget(infoLabel);
        LabelWidget info2Label = new LabelWidget("info2_label", panelX, yPos += 15, "\u00a77- add_value: Adds the amount directly", -5592406, false, false);
        this.addWidget(info2Label);
        LabelWidget info3Label = new LabelWidget("info3_label", panelX, yPos += 12, "\u00a77- add_multiplied_base: Adds (base * amount)", -5592406, false, false);
        this.addWidget(info3Label);
        LabelWidget info4Label = new LabelWidget("info4_label", panelX, yPos += 12, "\u00a77- add_multiplied_total: Multiplies total by (1 + amount)", -5592406, false, false);
        this.addWidget(info4Label);
        ButtonWidget saveBtn = new ButtonWidget("save", centerX - 105, this.field_22790 - 35, 100, 20, "Save", -13996502, -13004999, -1);
        saveBtn.setOnPress(this::saveModifier);
        this.addWidget(saveBtn);
        ButtonWidget cancelBtn = new ButtonWidget("cancel", centerX + 5, this.field_22790 - 35, 100, 20, "Cancel", -9737365, -7697782, -1);
        cancelBtn.setOnPress(this::method_25419);
        this.addWidget(cancelBtn);
    }

    private void saveModifier() {
        try {
            int attrIndex = this.attributeDropdown.getSelectedIndex();
            if (attrIndex < 0 || attrIndex >= this.allAttributes.size()) {
                return;
            }
            class_6880<class_1320> attribute = this.allAttributes.get(attrIndex);
            double amount = Double.parseDouble(this.amountInput.getValue());
            class_1322.class_1323 operation = class_1322.class_1323.values()[this.operationDropdown.getSelectedIndex()];
            class_9274 slot = this.parseSlotGroup(this.slotDropdown.getSelectedOption());
            class_2960 id = class_2960.method_60656((String)("custom_modifier_" + UUID.randomUUID().toString().substring(0, 8)));
            class_1322 modifier = new class_1322(id, amount, operation);
            AttributeModifierEditorGui.ModifierEntry entry = new AttributeModifierEditorGui.ModifierEntry(attribute, modifier, slot);
            if (this.onSave != null) {
                this.onSave.accept(entry);
            }
            this.method_25419();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private class_9274 parseSlotGroup(String option) {
        String name;
        return switch (name = option.split(" ")[0].toLowerCase()) {
            case "mainhand" -> class_9274.field_49217;
            case "offhand" -> class_9274.field_49218;
            case "hand" -> class_9274.field_49219;
            case "feet" -> class_9274.field_49220;
            case "legs" -> class_9274.field_49221;
            case "chest" -> class_9274.field_49222;
            case "head" -> class_9274.field_49223;
            case "armor" -> class_9274.field_49224;
            case "body" -> class_9274.field_50127;
            default -> class_9274.field_49216;
        };
    }
}

