/*
 * Decompiled with CFR 0.152.
 */
package net.jackson.simplegui;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jackson.simplegui.AttributeCustomizerGui;
import net.jackson.simplegui.SimpleGuiScreen;
import net.jackson.simplegui.widget.ButtonWidget;
import net.jackson.simplegui.widget.LabelWidget;
import net.jackson.simplegui.widget.ScrollMenuWidget;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9334;

@Environment(value=EnvType.CLIENT)
public class AttributeModifierEditorGui
extends SimpleGuiScreen {
    private final class_1799 itemStack;
    private final Consumer<class_9285> onSave;
    private ScrollMenuWidget modifierList;
    private final List<ModifierEntry> modifiers = new ArrayList<ModifierEntry>();

    public AttributeModifierEditorGui(class_437 parent, class_1799 itemStack, Consumer<class_9285> onSave) {
        super("Attribute Modifiers Editor", parent);
        this.itemStack = itemStack;
        this.onSave = onSave;
        this.loadExistingModifiers();
    }

    private void loadExistingModifiers() {
        class_9285 existing = (class_9285)this.itemStack.method_57825(class_9334.field_49636, (Object)class_9285.field_49326);
        for (class_9285.class_9287 entry : existing.comp_2393()) {
            this.modifiers.add(new ModifierEntry((class_6880<class_1320>)entry.comp_2395(), entry.comp_2396(), entry.comp_2397()));
        }
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        int panelWidth = 400;
        int panelX = centerX - panelWidth / 2;
        LabelWidget title = new LabelWidget("title", centerX, 10, "\u00a76\u00a7lAttribute Modifiers", -1, true, true);
        this.addWidget(title);
        LabelWidget currentLabel = new LabelWidget("current_label", panelX, 30, "\u00a7eCurrent Modifiers:", -1, false, false);
        this.addWidget(currentLabel);
        this.modifierList = new ScrollMenuWidget("modifier_list", panelX, 45, panelWidth, 120, -15066598, -14013910, -12632257, -1, -10461088);
        this.modifierList.setItemHeight(20);
        this.updateModifierList();
        this.addWidget(this.modifierList);
        ButtonWidget addBtn = new ButtonWidget("add_btn", panelX, 175, 100, 20, "Add New", -13996502, -13004999, -1);
        addBtn.setOnPress(() -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507((class_437)new AttributeCustomizerGui(this, null, entry -> {
                    this.modifiers.add((ModifierEntry)entry);
                    this.updateModifierList();
                }));
            }
        });
        this.addWidget(addBtn);
        ButtonWidget editBtn = new ButtonWidget("edit_btn", panelX + 110, 175, 100, 20, "Edit", -12961170, -11908465, -1);
        editBtn.setOnPress(() -> {
            int selectedIndex = this.modifierList.getSelectedIndex();
            if (selectedIndex >= 0 && selectedIndex < this.modifiers.size()) {
                ModifierEntry entry = this.modifiers.get(selectedIndex);
                if (this.field_22787 != null) {
                    this.field_22787.method_1507((class_437)new AttributeCustomizerGui(this, entry, newEntry -> {
                        this.modifiers.set(selectedIndex, (ModifierEntry)newEntry);
                        this.updateModifierList();
                    }));
                }
            }
        });
        this.addWidget(editBtn);
        ButtonWidget removeBtn = new ButtonWidget("remove_btn", panelX + 220, 175, 90, 20, "Remove", -9557462, -7390919, -1);
        removeBtn.setOnPress(() -> {
            int selectedIndex = this.modifierList.getSelectedIndex();
            if (selectedIndex >= 0 && selectedIndex < this.modifiers.size()) {
                this.modifiers.remove(selectedIndex);
                this.updateModifierList();
            }
        });
        this.addWidget(removeBtn);
        ButtonWidget clearBtn = new ButtonWidget("clear_btn", panelX + 320, 175, 80, 20, "Clear All", -9557462, -7390919, -1);
        clearBtn.setOnPress(() -> {
            this.modifiers.clear();
            this.updateModifierList();
        });
        this.addWidget(clearBtn);
        ButtonWidget saveBtn = new ButtonWidget("save", centerX - 105, this.field_22790 - 35, 100, 20, "Save", -13996502, -13004999, -1);
        saveBtn.setOnPress(() -> {
            this.saveModifiers();
            this.method_25419();
        });
        this.addWidget(saveBtn);
        ButtonWidget cancelBtn = new ButtonWidget("cancel", centerX + 5, this.field_22790 - 35, 100, 20, "Cancel", -9737365, -7697782, -1);
        cancelBtn.setOnPress(this::method_25419);
        this.addWidget(cancelBtn);
    }

    private void updateModifierList() {
        this.modifierList.clearItems();
        for (ModifierEntry entry : this.modifiers) {
            Optional key = entry.attribute().method_40230();
            String name = key.isPresent() ? ((class_5321)key.get()).method_29177().method_12832().replace("_", " ") : "unknown";
            String value = String.format("%.2f", entry.modifier().comp_2449());
            String operation = entry.modifier().comp_2450().name();
            this.modifierList.addItem(name + ": " + value + " (" + operation + ")");
        }
    }

    private void saveModifiers() {
        ArrayList<class_9285.class_9287> entries = new ArrayList<class_9285.class_9287>();
        for (ModifierEntry entry : this.modifiers) {
            entries.add(new class_9285.class_9287(entry.attribute(), entry.modifier(), entry.slot()));
        }
        class_9285 result = new class_9285(entries, true);
        if (this.onSave != null) {
            this.onSave.accept(result);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class ModifierEntry {
        private final class_6880<class_1320> attribute;
        private final class_1322 modifier;
        private final class_9274 slot;

        public ModifierEntry(class_6880<class_1320> attribute, class_1322 modifier, class_9274 slot) {
            this.attribute = attribute;
            this.modifier = modifier;
            this.slot = slot;
        }

        public class_6880<class_1320> attribute() {
            return this.attribute;
        }

        public class_1322 modifier() {
            return this.modifier;
        }

        public class_9274 slot() {
            return this.slot;
        }
    }
}

