/*
 * Decompiled with CFR 0.152.
 */
package net.jackson.simplegui;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jackson.simplegui.SimpleGuiScreen;
import net.jackson.simplegui.widget.ButtonWidget;
import net.jackson.simplegui.widget.LabelWidget;
import net.jackson.simplegui.widget.ScrollMenuWidget;
import net.jackson.simplegui.widget.SearchableDropdownWidget;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_746;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class BlockListEditorGui
extends SimpleGuiScreen {
    private final Consumer<List<class_2248>> onSave;
    private final List<class_2248> blocks = new ArrayList<class_2248>();
    private final String title;
    private ScrollMenuWidget blockListWidget;
    private SearchableDropdownWidget blockSelector;
    private final List<class_2248> allBlocks = new ArrayList<class_2248>();

    public BlockListEditorGui(class_437 parent, String title, List<class_2248> initialBlocks, Consumer<List<class_2248>> onSave) {
        super(title, parent);
        this.title = title;
        this.onSave = onSave;
        if (initialBlocks != null) {
            this.blocks.addAll(initialBlocks);
        }
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        int panelWidth = Math.min(400, this.field_22789 - 40);
        int panelX = centerX - panelWidth / 2;
        LabelWidget titleLabel = new LabelWidget("title", centerX, 10, "\u00a76\u00a7l" + this.title, -1, true, true);
        this.addWidget(titleLabel);
        LabelWidget instructions = new LabelWidget("instructions", centerX, 30, "\u00a77Select blocks to add to the list", -5592406, true, false);
        this.addWidget(instructions);
        LabelWidget selectorLabel = new LabelWidget("selector_label", panelX, 50, "Add Block:", -5592406, false, false);
        this.addWidget(selectorLabel);
        this.blockSelector = new SearchableDropdownWidget("block_selector", panelX, 70, panelWidth - 80, 20, -14671840, -12566464, -1);
        ArrayList<String> blockNames = new ArrayList<String>();
        for (class_2248 block : class_7923.field_41175) {
            if (block == class_2246.field_10124 || block == class_2246.field_10543 || block == class_2246.field_10243) continue;
            class_2960 id = class_7923.field_41175.method_10221((Object)block);
            blockNames.add(id.toString());
            this.allBlocks.add(block);
            int index = blockNames.size() - 1;
            this.blockSelector.setItemOverlay(index, new class_1799((class_1935)block.method_8389()));
        }
        for (String name : blockNames) {
            this.blockSelector.addOption(name);
        }
        this.addWidget(this.blockSelector);
        ButtonWidget addBtn = new ButtonWidget("add_block", panelX + panelWidth - 70, 70, 60, 20, "Add", -13996502, -13004999, -1);
        addBtn.setOnPress(() -> {
            class_2248 selectedBlock;
            int selectedIndex = this.blockSelector.getSelectedIndex();
            if (selectedIndex >= 0 && selectedIndex < this.allBlocks.size() && !this.blocks.contains(selectedBlock = this.allBlocks.get(selectedIndex))) {
                this.blocks.add(selectedBlock);
                this.refreshBlockList();
            }
        });
        this.addWidget(addBtn);
        LabelWidget listLabel = new LabelWidget("list_label", panelX, 100, "\u00a7eSelected Blocks (" + this.blocks.size() + "):", -1, false, false);
        this.addWidget(listLabel);
        this.blockListWidget = new ScrollMenuWidget("block_list", panelX, 120, panelWidth, this.field_22790 - 180, -15066598, -14013910, -12632257, -1, -10461088);
        this.blockListWidget.setItemHeight(24);
        this.addWidget(this.blockListWidget);
        this.refreshBlockList();
        ButtonWidget saveBtn = new ButtonWidget("save", centerX - 105, this.field_22790 - 35, 100, 20, "Save", -13996502, -13004999, -1);
        saveBtn.setOnPress(this::save);
        this.addWidget(saveBtn);
        ButtonWidget cancelBtn = new ButtonWidget("cancel", centerX + 5, this.field_22790 - 35, 100, 20, "Cancel", -9737365, -7697782, -1);
        cancelBtn.setOnPress(this::method_25419);
        this.addWidget(cancelBtn);
    }

    private void refreshBlockList() {
        this.blockListWidget.clearItems();
        for (int i = 0; i < this.blocks.size(); ++i) {
            class_2248 block = this.blocks.get(i);
            class_2960 id = class_7923.field_41175.method_10221((Object)block);
            String displayName = id.toString();
            this.blockListWidget.addItem(displayName);
        }
        LabelWidget listLabel = (LabelWidget)this.getWidget("list_label");
        if (listLabel != null) {
            listLabel.setText("\u00a7eSelected Blocks (" + this.blocks.size() + "):");
        }
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 1 && this.blockListWidget != null) {
            int scrollOffset;
            int clickedIndex;
            int listX = this.blockListWidget.getX();
            int listY = this.blockListWidget.getY();
            int listWidth = this.blockListWidget.getWidth();
            int itemHeight = 24;
            if (mouseX >= (double)listX && mouseX < (double)(listX + listWidth) && mouseY >= (double)listY && mouseY < (double)(listY + this.blockListWidget.getHeight()) && (clickedIndex = (int)((mouseY - (double)listY) / (double)itemHeight) + (scrollOffset = this.blockListWidget.getSelectedIndex() / 10)) >= 0 && clickedIndex < this.blocks.size()) {
                this.blocks.remove(clickedIndex);
                this.refreshBlockList();
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private void save() {
        class_746 player;
        if (this.onSave != null) {
            this.onSave.accept(new ArrayList<class_2248>(this.blocks));
        }
        if ((player = this.field_22787.field_1724) != null) {
            player.method_7353((class_2561)class_2561.method_43470((String)("Block list updated: " + this.blocks.size() + " blocks")).method_27692(class_124.field_1060), false);
        }
        this.method_25419();
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        int centerX = this.field_22789 / 2;
        graphics.method_51433(this.field_22787.field_1772, "\u00a77Right-click on a block to remove it", centerX - this.field_22787.field_1772.method_1727("Right-click on a block to remove it") / 2, this.field_22790 - 50, -8355712, false);
    }
}

