/*
 * Decompiled with CFR 0.152.
 */
package net.jackson.simplegui;

import java.util.Locale;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jackson.simplegui.SimpleGuiScreen;
import net.jackson.simplegui.widget.ButtonWidget;
import net.jackson.simplegui.widget.DropdownWidget;
import net.jackson.simplegui.widget.LabelWidget;
import net.jackson.simplegui.widget.TextBoxWidget;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2873;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_7924;
import net.minecraft.class_9304;

@Environment(value=EnvType.CLIENT)
public class EnchantGui
extends SimpleGuiScreen {
    private DropdownWidget enchantmentDropdown;
    private TextBoxWidget levelBox;

    public EnchantGui(class_437 parent) {
        super("Enchant GUI", parent);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        LabelWidget title = new LabelWidget("title", centerX, 20, "Enchanter", -1, true, true);
        this.addWidget(title);
        LabelWidget enchLabel = new LabelWidget("ench_label", centerX, 45, "Enchantment", -5592406, true, true);
        this.addWidget(enchLabel);
        this.enchantmentDropdown = new DropdownWidget("enchantment_dropdown", centerX - 100, 60, 200, 20);
        this.enchantmentDropdown.addOption("Sharpness");
        this.enchantmentDropdown.setItemOverlay(0, class_1802.field_8371.method_7854());
        this.enchantmentDropdown.addOption("Efficiency");
        this.enchantmentDropdown.setItemOverlay(1, class_1802.field_8403.method_7854());
        this.enchantmentDropdown.addOption("Unbreaking");
        this.enchantmentDropdown.setItemOverlay(2, class_1802.field_8773.method_7854());
        this.enchantmentDropdown.addOption("Fortune");
        this.enchantmentDropdown.setItemOverlay(3, class_1802.field_8787.method_7854());
        this.enchantmentDropdown.addOption("Protection");
        this.enchantmentDropdown.setItemOverlay(4, class_1802.field_8058.method_7854());
        this.enchantmentDropdown.addOption("Looting");
        this.enchantmentDropdown.setItemOverlay(5, class_1802.field_8802.method_7854());
        this.enchantmentDropdown.addOption("Silk Touch");
        this.enchantmentDropdown.setItemOverlay(6, class_1802.field_8377.method_7854());
        this.enchantmentDropdown.addOption("Mending");
        this.enchantmentDropdown.setItemOverlay(7, class_1802.field_8598.method_7854());
        this.enchantmentDropdown.setSelectedIndex(0);
        this.addWidget(this.enchantmentDropdown);
        LabelWidget levelLabel = new LabelWidget("level_label", centerX, 90, "Level (1-255)", -5592406, true, true);
        this.addWidget(levelLabel);
        this.levelBox = new TextBoxWidget("level_input", centerX - 100, 105, 200, 20, -14671840, -8355712, -1, -8355712);
        this.levelBox.setHint("Enter level...");
        this.levelBox.setMaxLength(3);
        this.addWidget(this.levelBox);
        ButtonWidget enchantBtn = new ButtonWidget("enchant", centerX - 100, 140, 200, 20, "Enchant Item", -13996502, -13004999, -1);
        enchantBtn.setOnPress(this::onEnchantPressed);
        this.addWidget(enchantBtn);
        ButtonWidget closeBtn = new ButtonWidget("close", centerX - 100, 170, 200, 20, "Close", -9737365, -7697782, -1);
        closeBtn.setOnPress(this::method_25419);
        this.addWidget(closeBtn);
    }

    private void onEnchantPressed() {
        int level;
        String levelText;
        class_746 player = this.field_22787.field_1724;
        if (player == null) {
            return;
        }
        if (!player.method_31549().field_7477) {
            player.method_7353((class_2561)class_2561.method_43470((String)"You must be in creative mode to use this enchanter.").method_27692(class_124.field_1061), false);
            return;
        }
        class_1799 mainHandStack = player.method_6047();
        if (mainHandStack.method_7960()) {
            player.method_7353((class_2561)class_2561.method_43470((String)"You must hold an item to enchant it.").method_27692(class_124.field_1061), false);
            return;
        }
        String displayName = this.enchantmentDropdown.getSelectedOption();
        if (displayName == null || displayName.isEmpty()) {
            player.method_7353((class_2561)class_2561.method_43470((String)"Please select an enchantment.").method_27692(class_124.field_1061), false);
            return;
        }
        String idPath = displayName.toLowerCase(Locale.ROOT).replace(" ", "_");
        String string = levelText = this.levelBox != null ? this.levelBox.getValue().trim() : "";
        if (levelText.isEmpty()) {
            player.method_7353((class_2561)class_2561.method_43470((String)"Enter a level between 1 and 255.").method_27692(class_124.field_1061), false);
            return;
        }
        try {
            level = Integer.parseInt(levelText);
        }
        catch (NumberFormatException ex) {
            player.method_7353((class_2561)class_2561.method_43470((String)"Level must be a number (1-255).").method_27692(class_124.field_1061), false);
            return;
        }
        if (level > 255) {
            level = 255;
        } else if (level < 0) {
            level = 0;
        }
        class_2378 enchantmentRegistry = player.method_37908().method_30349().method_30530(class_7924.field_41265);
        class_2960 enchantmentId = class_2960.method_60656((String)idPath);
        class_6880.class_6883 enchantmentHolder = enchantmentRegistry.method_10223(enchantmentId).orElse(null);
        if (enchantmentHolder == null) {
            player.method_7353((class_2561)class_2561.method_43470((String)("Invalid enchantment: " + displayName)).method_27692(class_124.field_1061), false);
            return;
        }
        class_1799 newStack = mainHandStack.method_7972();
        class_9304 existingEnchants = class_1890.method_57532((class_1799)newStack);
        class_9304.class_9305 mutableEnchants = new class_9304.class_9305(existingEnchants);
        mutableEnchants.method_57547((class_6880)enchantmentHolder, level);
        class_1890.method_57530((class_1799)newStack, (class_9304)mutableEnchants.method_57549());
        int slot = 36 + player.method_31548().field_7545;
        player.field_3944.method_52787((class_2596)new class_2873(slot, newStack));
        player.method_31548().method_5447(player.method_31548().field_7545, newStack);
        player.method_7353((class_2561)class_2561.method_43470((String)("Applied " + displayName.toUpperCase(Locale.ROOT) + " " + level + " to item!")).method_27692(class_124.field_1060), false);
    }
}

