/*
 * Decompiled with CFR 0.152.
 */
package net.jackson.simplegui;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jackson.simplegui.SimpleGuiScreen;
import net.jackson.simplegui.widget.ButtonWidget;
import net.jackson.simplegui.widget.DropdownWidget;
import net.jackson.simplegui.widget.LabelWidget;
import net.jackson.simplegui.widget.TextBoxWidget;
import net.minecraft.class_437;
import net.minecraft.class_9283;

@Environment(value=EnvType.CLIENT)
public class FireworkExplosionEditorGui
extends SimpleGuiScreen {
    private final Consumer<class_9283> onSave;
    private final class_9283 initial;
    private DropdownWidget shapeDropdown;
    private TextBoxWidget colorsInput;
    private TextBoxWidget fadeColorsInput;
    private ButtonWidget trailToggle;
    private ButtonWidget twinkleToggle;
    private boolean hasTrail = false;
    private boolean hasTwinkle = false;

    public FireworkExplosionEditorGui(class_437 parent, class_9283 initial, Consumer<class_9283> onSave) {
        super("Firework Explosion Editor", parent);
        this.initial = initial;
        this.onSave = onSave;
        if (initial != null) {
            this.hasTrail = initial.comp_2389();
            this.hasTwinkle = initial.comp_2390();
        }
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        int panelWidth = 350;
        int panelX = centerX - panelWidth / 2;
        LabelWidget title = new LabelWidget("title", centerX, 10, "\u00a76\u00a7lFirework Explosion Editor", -1, true, true);
        this.addWidget(title);
        LabelWidget shapeLabel = new LabelWidget("shape_label", panelX, 35, "\u00a7eShape:", -1, false, false);
        this.addWidget(shapeLabel);
        this.shapeDropdown = new DropdownWidget("shape_dropdown", panelX, 50, panelWidth, 20);
        this.shapeDropdown.addOption("small_ball");
        this.shapeDropdown.addOption("large_ball");
        this.shapeDropdown.addOption("star");
        this.shapeDropdown.addOption("creeper");
        this.shapeDropdown.addOption("burst");
        if (this.initial != null) {
            this.shapeDropdown.setSelectedIndex(this.initial.comp_2386().ordinal());
        }
        this.addWidget(this.shapeDropdown);
        LabelWidget colorsLabel = new LabelWidget("colors_label", panelX, 80, "\u00a7eColors (comma-separated RGB hex, e.g., FF0000,00FF00):", -1, false, false);
        this.addWidget(colorsLabel);
        this.colorsInput = new TextBoxWidget("colors_input", panelX, 95, panelWidth, 20, -14671840, -8355712, -1, -10461088);
        if (this.initial != null && !this.initial.comp_2387().isEmpty()) {
            StringBuilder sb = new StringBuilder();
            IntListIterator intListIterator = this.initial.comp_2387().iterator();
            while (intListIterator.hasNext()) {
                int color = (Integer)intListIterator.next();
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(String.format("%06X", color));
            }
            this.colorsInput.setValue(sb.toString());
        }
        this.colorsInput.setMaxLength(128);
        this.colorsInput.setHint("FF0000,00FF00,0000FF");
        this.addWidget(this.colorsInput);
        LabelWidget fadeColorsLabel = new LabelWidget("fade_colors_label", panelX, 125, "\u00a7eFade Colors (comma-separated RGB hex):", -1, false, false);
        this.addWidget(fadeColorsLabel);
        this.fadeColorsInput = new TextBoxWidget("fade_colors_input", panelX, 140, panelWidth, 20, -14671840, -8355712, -1, -10461088);
        if (this.initial != null && !this.initial.comp_2388().isEmpty()) {
            StringBuilder sb = new StringBuilder();
            IntListIterator color = this.initial.comp_2388().iterator();
            while (color.hasNext()) {
                int color2 = (Integer)color.next();
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(String.format("%06X", color2));
            }
            this.fadeColorsInput.setValue(sb.toString());
        }
        this.fadeColorsInput.setMaxLength(128);
        this.fadeColorsInput.setHint("Leave empty for no fade");
        this.addWidget(this.fadeColorsInput);
        LabelWidget trailLabel = new LabelWidget("trail_label", panelX, 170, "\u00a7eHas Trail:", -1, false, false);
        this.addWidget(trailLabel);
        this.trailToggle = new ButtonWidget("trail_toggle", panelX, 185, 120, 20, this.hasTrail ? "\u00a7aYes" : "\u00a7cNo", this.hasTrail ? -13996502 : -9557462, this.hasTrail ? -13004999 : -7390919, -1);
        this.trailToggle.setOnPress(() -> {
            this.hasTrail = !this.hasTrail;
            this.trailToggle.setText(this.hasTrail ? "\u00a7aYes" : "\u00a7cNo");
        });
        this.addWidget(this.trailToggle);
        LabelWidget twinkleLabel = new LabelWidget("twinkle_label", panelX, 215, "\u00a7eHas Twinkle:", -1, false, false);
        this.addWidget(twinkleLabel);
        this.twinkleToggle = new ButtonWidget("twinkle_toggle", panelX, 230, 120, 20, this.hasTwinkle ? "\u00a7aYes" : "\u00a7cNo", this.hasTwinkle ? -13996502 : -9557462, this.hasTwinkle ? -13004999 : -7390919, -1);
        this.twinkleToggle.setOnPress(() -> {
            this.hasTwinkle = !this.hasTwinkle;
            this.twinkleToggle.setText(this.hasTwinkle ? "\u00a7aYes" : "\u00a7cNo");
        });
        this.addWidget(this.twinkleToggle);
        ButtonWidget saveBtn = new ButtonWidget("save", centerX - 105, this.field_22790 - 35, 100, 20, "Save", -13996502, -13004999, -1);
        saveBtn.setOnPress(() -> {
            this.saveExplosion();
            this.method_25419();
        });
        this.addWidget(saveBtn);
        ButtonWidget cancelBtn = new ButtonWidget("cancel", centerX + 5, this.field_22790 - 35, 100, 20, "Cancel", -9737365, -7697782, -1);
        cancelBtn.setOnPress(this::method_25419);
        this.addWidget(cancelBtn);
    }

    private void saveExplosion() {
        class_9283.class_1782 shape = class_9283.class_1782.values()[this.shapeDropdown.getSelectedIndex()];
        IntList colors = this.parseColors(this.colorsInput.getValue());
        IntList fadeColors = this.parseColors(this.fadeColorsInput.getValue());
        class_9283 explosion = new class_9283(shape, colors, fadeColors, this.hasTrail, this.hasTwinkle);
        if (this.onSave != null) {
            this.onSave.accept(explosion);
        }
    }

    private IntList parseColors(String input) {
        String[] parts;
        IntArrayList colors = new IntArrayList();
        if (input == null || input.trim().isEmpty()) {
            return colors;
        }
        for (String part : parts = input.split(",")) {
            try {
                String hex = part.trim();
                int color = Integer.parseInt(hex, 16);
                colors.add(color);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return colors;
    }
}

