/*
 * Decompiled with CFR 0.152.
 */
package net.jackson.simplegui;

import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jackson.simplegui.SimpleGuiScreen;
import net.jackson.simplegui.widget.ButtonWidget;
import net.jackson.simplegui.widget.LabelWidget;
import net.jackson.simplegui.widget.TextBoxWidget;
import net.minecraft.class_4174;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class FoodPropertiesEditorGui
extends SimpleGuiScreen {
    private final Consumer<class_4174> onSave;
    private TextBoxWidget nutritionInput;
    private TextBoxWidget saturationInput;
    private ButtonWidget canAlwaysEatToggle;
    private ButtonWidget fastFoodToggle;
    private boolean canAlwaysEat = false;
    private boolean fastFood = false;

    public FoodPropertiesEditorGui(class_437 parent, class_4174 initial, Consumer<class_4174> onSave) {
        super("Food Properties Editor", parent);
        this.onSave = onSave;
        if (initial != null) {
            this.canAlwaysEat = initial.comp_2493();
        }
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        int panelWidth = 300;
        int panelX = centerX - panelWidth / 2;
        LabelWidget title = new LabelWidget("title", centerX, 10, "\u00a76\u00a7lFood Properties Editor", -1, true, true);
        this.addWidget(title);
        LabelWidget nutritionLabel = new LabelWidget("nutrition_label", panelX, 40, "\u00a7eNutrition (hunger restored):", -1, false, false);
        this.addWidget(nutritionLabel);
        this.nutritionInput = new TextBoxWidget("nutrition_input", panelX, 55, panelWidth, 20, -14671840, -8355712, -1, -10461088);
        this.nutritionInput.setValue("4");
        this.nutritionInput.setMaxLength(3);
        this.nutritionInput.setHint("1-20");
        this.addWidget(this.nutritionInput);
        LabelWidget saturationLabel = new LabelWidget("saturation_label", panelX, 85, "\u00a7eSaturation Modifier:", -1, false, false);
        this.addWidget(saturationLabel);
        this.saturationInput = new TextBoxWidget("saturation_input", panelX, 100, panelWidth, 20, -14671840, -8355712, -1, -10461088);
        this.saturationInput.setValue("0.3");
        this.saturationInput.setMaxLength(6);
        this.saturationInput.setHint("0.0-2.0");
        this.addWidget(this.saturationInput);
        LabelWidget alwaysEatLabel = new LabelWidget("always_eat_label", panelX, 130, "\u00a7eCan Always Eat:", -1, false, false);
        this.addWidget(alwaysEatLabel);
        this.canAlwaysEatToggle = new ButtonWidget("always_eat_toggle", panelX, 145, 120, 20, this.canAlwaysEat ? "\u00a7aYes" : "\u00a7cNo", this.canAlwaysEat ? -13996502 : -9557462, this.canAlwaysEat ? -13004999 : -7390919, -1);
        this.canAlwaysEatToggle.setOnPress(() -> {
            this.canAlwaysEat = !this.canAlwaysEat;
            this.canAlwaysEatToggle.setText(this.canAlwaysEat ? "\u00a7aYes" : "\u00a7cNo");
        });
        this.addWidget(this.canAlwaysEatToggle);
        LabelWidget infoLabel = new LabelWidget("info_label", panelX, 180, "\u00a77Note: Effects are managed via Consumable", -5592406, false, false);
        this.addWidget(infoLabel);
        ButtonWidget saveBtn = new ButtonWidget("save", centerX - 105, this.field_22790 - 35, 100, 20, "Apply", -13996502, -13004999, -1);
        saveBtn.setOnPress(() -> {
            this.saveProperties();
            this.method_25419();
        });
        this.addWidget(saveBtn);
        ButtonWidget cancelBtn = new ButtonWidget("cancel", centerX + 5, this.field_22790 - 35, 100, 20, "Cancel", -9737365, -7697782, -1);
        cancelBtn.setOnPress(this::method_25419);
        this.addWidget(cancelBtn);
    }

    private void saveProperties() {
        int nutrition = 4;
        try {
            nutrition = Integer.parseInt(this.nutritionInput.getValue());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        float saturation = 0.3f;
        try {
            saturation = Float.parseFloat(this.saturationInput.getValue());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        class_4174 properties = new class_4174(nutrition, saturation, this.canAlwaysEat);
        if (this.onSave != null) {
            this.onSave.accept(properties);
        }
    }
}

