/*
 * Decompiled with CFR 0.152.
 */
package net.jackson.simplegui;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jackson.simplegui.SimpleGuiScreen;
import net.jackson.simplegui.widget.ButtonWidget;
import net.jackson.simplegui.widget.DropdownWidget;
import net.jackson.simplegui.widget.LabelWidget;
import net.minecraft.class_2378;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7444;
import net.minecraft.class_7924;

@Environment(value=EnvType.CLIENT)
public class InstrumentEditorGui
extends SimpleGuiScreen {
    private final Consumer<class_6880<class_7444>> onSave;
    private DropdownWidget instrumentDropdown;
    private final List<class_6880<class_7444>> allInstruments = new ArrayList<class_6880<class_7444>>();

    public InstrumentEditorGui(class_437 parent, class_6880<class_7444> initial, Consumer<class_6880<class_7444>> onSave) {
        super("Instrument Selector", parent);
        this.onSave = onSave;
        this.loadInstruments();
    }

    private void loadInstruments() {
        if (this.field_22787 != null && this.field_22787.field_1687 != null) {
            try {
                class_5455 registryAccess = this.field_22787.field_1687.method_30349();
                Optional registry = registryAccess.method_46759(class_7924.field_41275);
                if (registry.isPresent()) {
                    ((class_2378)registry.get()).method_42017().forEach(h -> this.allInstruments.add((class_6880<class_7444>)h));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        int panelWidth = 320;
        int panelX = centerX - panelWidth / 2;
        LabelWidget title = new LabelWidget("title", centerX, 10, "\u00a76\u00a7lInstrument Selector", -1, true, true);
        this.addWidget(title);
        LabelWidget infoLabel = new LabelWidget("info_label", panelX, 35, "\u00a77For goat horns and other instruments", -5592406, false, false);
        this.addWidget(infoLabel);
        LabelWidget instrumentLabel = new LabelWidget("instrument_label", panelX, 60, "\u00a7eInstrument:", -1, false, false);
        this.addWidget(instrumentLabel);
        this.instrumentDropdown = new DropdownWidget("instrument_dropdown", panelX, 75, panelWidth, 20);
        if (this.allInstruments.isEmpty()) {
            this.instrumentDropdown.addOption("No instruments available");
        } else {
            for (class_6880<class_7444> instrument : this.allInstruments) {
                Optional key = instrument.method_40230();
                String name = key.isPresent() ? ((class_5321)key.get()).method_29177().method_12832().replace("_", " ") : "unknown";
                this.instrumentDropdown.addOption(name);
            }
        }
        this.addWidget(this.instrumentDropdown);
        LabelWidget info2Label = new LabelWidget("info2_label", panelX, 110, "\u00a77Common: ponder, sing, seek, feel, admire", -5592406, false, false);
        this.addWidget(info2Label);
        LabelWidget info3Label = new LabelWidget("info3_label", panelX, 125, "\u00a77call, yearn, dream, resist, cry", -5592406, false, false);
        this.addWidget(info3Label);
        ButtonWidget saveBtn = new ButtonWidget("save", centerX - 105, this.field_22790 - 35, 100, 20, "Apply", -13996502, -13004999, -1);
        saveBtn.setOnPress(() -> {
            this.saveInstrument();
            this.method_25419();
        });
        this.addWidget(saveBtn);
        ButtonWidget cancelBtn = new ButtonWidget("cancel", centerX + 5, this.field_22790 - 35, 100, 20, "Cancel", -9737365, -7697782, -1);
        cancelBtn.setOnPress(this::method_25419);
        this.addWidget(cancelBtn);
    }

    private void saveInstrument() {
        int idx = this.instrumentDropdown.getSelectedIndex();
        if (idx < 0 || idx >= this.allInstruments.size()) {
            return;
        }
        class_6880<class_7444> instrument = this.allInstruments.get(idx);
        if (this.onSave != null) {
            this.onSave.accept(instrument);
        }
    }
}

