/*
 * Decompiled with CFR 0.152.
 */
package net.jackson.simplegui;

import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jackson.simplegui.SimpleGuiScreen;
import net.jackson.simplegui.widget.ButtonWidget;
import net.jackson.simplegui.widget.LabelWidget;
import net.jackson.simplegui.widget.TextBoxWidget;
import net.minecraft.class_1273;
import net.minecraft.class_2073;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_9329;
import net.minecraft.class_9334;

@Environment(value=EnvType.CLIENT)
public class LockEditorGui
extends SimpleGuiScreen {
    private final Consumer<class_1273> onSave;
    private TextBoxWidget keyField;
    private ButtonWidget removeButton;
    private String currentKey = "";
    private boolean hasLock = false;

    public LockEditorGui(class_437 parent, class_1273 current, Consumer<class_1273> onSave) {
        super("Lock Editor", parent);
        this.onSave = onSave;
        boolean bl = this.hasLock = current != null;
        if (current != null) {
            this.currentKey = "";
        }
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        int panelWidth = 300;
        int panelX = centerX - panelWidth / 2;
        LabelWidget title = new LabelWidget("title", centerX, 10, "\u00a76\u00a7lLock Editor", -1, true, true);
        this.addWidget(title);
        LabelWidget instructions = new LabelWidget("instructions", centerX, 30, "\u00a77Set a custom key name for this lock", -5592406, true, false);
        this.addWidget(instructions);
        LabelWidget keyLabel = new LabelWidget("key_label", panelX, 60, "Lock Key Name:", -5592406, false, false);
        this.addWidget(keyLabel);
        this.keyField = new TextBoxWidget("key_name", panelX, 80, panelWidth, 20, -14671840, -8355712, -1, -10461088);
        this.keyField.setValue(this.currentKey);
        this.keyField.setMaxLength(64);
        this.keyField.setHint("e.g., Golden Key");
        this.addWidget(this.keyField);
        LabelWidget info1 = new LabelWidget("info1", panelX, 115, "\u00a77The item must have this exact custom name", -8355712, false, false);
        this.addWidget(info1);
        LabelWidget info2 = new LabelWidget("info2", panelX, 130, "\u00a77to open this locked container", -8355712, false, false);
        this.addWidget(info2);
        LabelWidget example = new LabelWidget("example", panelX, 155, "\u00a7eExamples:", -22016, false, false);
        this.addWidget(example);
        LabelWidget ex1 = new LabelWidget("ex1", panelX, 170, "\u00a77- \"Rusty Key\" (any item with this name)", -8355712, false, false);
        this.addWidget(ex1);
        LabelWidget ex2 = new LabelWidget("ex2", panelX, 185, "\u00a77- \"Master Key\" (works for master locks)", -8355712, false, false);
        this.addWidget(ex2);
        this.removeButton = new ButtonWidget("remove", panelX, 215, 140, 20, "Remove Lock", -9557462, -7390919, -1);
        this.removeButton.setOnPress(this::removeLock);
        this.removeButton.setEnabled(this.hasLock);
        this.addWidget(this.removeButton);
        ButtonWidget saveBtn = new ButtonWidget("save", centerX - 105, this.field_22790 - 35, 100, 20, "Save", -13996502, -13004999, -1);
        saveBtn.setOnPress(this::save);
        this.addWidget(saveBtn);
        ButtonWidget cancelBtn = new ButtonWidget("cancel", centerX + 5, this.field_22790 - 35, 100, 20, "Cancel", -9737365, -7697782, -1);
        cancelBtn.setOnPress(this::method_25419);
        this.addWidget(cancelBtn);
    }

    private void removeLock() {
        if (this.onSave != null) {
            this.onSave.accept(null);
        }
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7aLock removed!"), false);
        }
        this.method_25419();
    }

    private void save() {
        block6: {
            String keyName = this.keyField.getValue().trim();
            if (keyName.isEmpty()) {
                if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                    this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cPlease specify a key name!"), false);
                }
                return;
            }
            try {
                class_2073.class_2074 predicateBuilder = class_2073.class_2074.method_8973();
                class_5250 nameComponent = class_2561.method_43470((String)keyName);
                predicateBuilder.method_57299(class_9329.method_57862().method_57872(class_9334.field_49631, (Object)nameComponent).method_57871());
                class_2073 predicate = predicateBuilder.method_8976();
                class_1273 lockCode = new class_1273(predicate);
                if (this.onSave != null) {
                    this.onSave.accept(lockCode);
                }
                if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                    this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u00a7aLock saved! Key name: \"" + keyName + "\"")), false);
                }
                this.method_25419();
            }
            catch (Exception e) {
                if (this.field_22787 == null || this.field_22787.field_1724 == null) break block6;
                this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u00a7cError: " + e.getMessage())), false);
            }
        }
    }
}

