/*
 * Decompiled with CFR 0.152.
 */
package net.jackson.simplegui;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jackson.simplegui.SimpleGuiScreen;
import net.jackson.simplegui.widget.ButtonWidget;
import net.jackson.simplegui.widget.DropdownWidget;
import net.jackson.simplegui.widget.LabelWidget;
import net.jackson.simplegui.widget.TextBoxWidget;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_437;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class MobEffectEditorGui
extends SimpleGuiScreen {
    private final Consumer<class_1293> onSave;
    private DropdownWidget effectDropdown;
    private TextBoxWidget durationInput;
    private TextBoxWidget amplifierInput;
    private ButtonWidget ambientToggle;
    private ButtonWidget visibleToggle;
    private ButtonWidget showIconToggle;
    private final List<class_1291> allEffects = new ArrayList<class_1291>();
    private boolean ambient = false;
    private boolean visible = true;
    private boolean showIcon = true;

    public MobEffectEditorGui(class_437 parent, class_1293 initial, Consumer<class_1293> onSave) {
        super("Mob Effect Editor", parent);
        this.onSave = onSave;
        for (class_1291 effect : class_7923.field_41174) {
            this.allEffects.add(effect);
        }
        if (initial != null) {
            this.ambient = initial.method_5591();
            this.visible = initial.method_5581();
            this.showIcon = initial.method_5592();
        }
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        int panelWidth = 300;
        int panelX = centerX - panelWidth / 2;
        LabelWidget title = new LabelWidget("title", centerX, 10, "\u00a76\u00a7lMob Effect Editor", -1, true, true);
        this.addWidget(title);
        LabelWidget effectLabel = new LabelWidget("effect_label", panelX, 35, "\u00a7eEffect Type:", -1, false, false);
        this.addWidget(effectLabel);
        this.effectDropdown = new DropdownWidget("effect_dropdown", panelX, 50, panelWidth, 20);
        for (class_1291 effect : this.allEffects) {
            String name = class_7923.field_41174.method_10221((Object)effect).method_12832().replace("_", " ");
            this.effectDropdown.addOption(name);
        }
        this.addWidget(this.effectDropdown);
        LabelWidget durationLabel = new LabelWidget("duration_label", panelX, 80, "\u00a7eDuration (ticks, 20t = 1s):", -1, false, false);
        this.addWidget(durationLabel);
        this.durationInput = new TextBoxWidget("duration_input", panelX, 95, panelWidth, 20, -14671840, -8355712, -1, -10461088);
        this.durationInput.setValue("600");
        this.durationInput.setMaxLength(8);
        this.durationInput.setHint("600 = 30 seconds");
        this.addWidget(this.durationInput);
        LabelWidget amplifierLabel = new LabelWidget("amplifier_label", panelX, 125, "\u00a7eAmplifier (0 = level 1):", -1, false, false);
        this.addWidget(amplifierLabel);
        this.amplifierInput = new TextBoxWidget("amplifier_input", panelX, 140, panelWidth, 20, -14671840, -8355712, -1, -10461088);
        this.amplifierInput.setValue("0");
        this.amplifierInput.setMaxLength(3);
        this.amplifierInput.setHint("0-255");
        this.addWidget(this.amplifierInput);
        LabelWidget ambientLabel = new LabelWidget("ambient_label", panelX, 170, "\u00a7eAmbient (from beacon):", -1, false, false);
        this.addWidget(ambientLabel);
        this.ambientToggle = new ButtonWidget("ambient_toggle", panelX, 185, 100, 20, this.ambient ? "\u00a7aEnabled" : "\u00a7cDisabled", this.ambient ? -13996502 : -9557462, this.ambient ? -13004999 : -7390919, -1);
        this.ambientToggle.setOnPress(() -> {
            this.ambient = !this.ambient;
            this.ambientToggle.setText(this.ambient ? "\u00a7aEnabled" : "\u00a7cDisabled");
        });
        this.addWidget(this.ambientToggle);
        LabelWidget visibleLabel = new LabelWidget("visible_label", panelX, 215, "\u00a7eVisible (show particles):", -1, false, false);
        this.addWidget(visibleLabel);
        this.visibleToggle = new ButtonWidget("visible_toggle", panelX, 230, 100, 20, this.visible ? "\u00a7aEnabled" : "\u00a7cDisabled", this.visible ? -13996502 : -9557462, this.visible ? -13004999 : -7390919, -1);
        this.visibleToggle.setOnPress(() -> {
            this.visible = !this.visible;
            this.visibleToggle.setText(this.visible ? "\u00a7aEnabled" : "\u00a7cDisabled");
        });
        this.addWidget(this.visibleToggle);
        LabelWidget showIconLabel = new LabelWidget("show_icon_label", panelX, 260, "\u00a7eShow Icon:", -1, false, false);
        this.addWidget(showIconLabel);
        this.showIconToggle = new ButtonWidget("show_icon_toggle", panelX, 275, 100, 20, this.showIcon ? "\u00a7aEnabled" : "\u00a7cDisabled", this.showIcon ? -13996502 : -9557462, this.showIcon ? -13004999 : -7390919, -1);
        this.showIconToggle.setOnPress(() -> {
            this.showIcon = !this.showIcon;
            this.showIconToggle.setText(this.showIcon ? "\u00a7aEnabled" : "\u00a7cDisabled");
        });
        this.addWidget(this.showIconToggle);
        ButtonWidget saveBtn = new ButtonWidget("save", centerX - 105, this.field_22790 - 35, 100, 20, "Add", -13996502, -13004999, -1);
        saveBtn.setOnPress(() -> {
            this.saveEffect();
            this.method_25419();
        });
        this.addWidget(saveBtn);
        ButtonWidget cancelBtn = new ButtonWidget("cancel", centerX + 5, this.field_22790 - 35, 100, 20, "Cancel", -9737365, -7697782, -1);
        cancelBtn.setOnPress(this::method_25419);
        this.addWidget(cancelBtn);
    }

    private void saveEffect() {
        int effectIdx = this.effectDropdown.getSelectedIndex();
        if (effectIdx < 0 || effectIdx >= this.allEffects.size()) {
            return;
        }
        class_1291 effect = this.allEffects.get(effectIdx);
        int duration = 600;
        try {
            duration = Integer.parseInt(this.durationInput.getValue());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int amplifier = 0;
        try {
            amplifier = Integer.parseInt(this.amplifierInput.getValue());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        class_6880 effectHolder = class_7923.field_41174.method_47983((Object)effect);
        class_1293 instance = new class_1293(effectHolder, duration, amplifier, this.ambient, this.visible, this.showIcon);
        if (this.onSave != null) {
            this.onSave.accept(instance);
        }
    }
}

