/*
 * Decompiled with CFR 0.152.
 */
package net.jackson.simplegui;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jackson.simplegui.MobEffectEditorGui;
import net.jackson.simplegui.SimpleGuiScreen;
import net.jackson.simplegui.widget.ButtonWidget;
import net.jackson.simplegui.widget.DropdownWidget;
import net.jackson.simplegui.widget.LabelWidget;
import net.jackson.simplegui.widget.ScrollMenuWidget;
import net.jackson.simplegui.widget.TextBoxWidget;
import net.minecraft.class_1293;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class PotionContentsEditorGui
extends SimpleGuiScreen {
    private final Consumer<class_1844> onSave;
    private DropdownWidget potionDropdown;
    private ScrollMenuWidget effectList;
    private TextBoxWidget customColorInput;
    private final List<class_1293> customEffects = new ArrayList<class_1293>();
    private final List<class_1842> allPotions = new ArrayList<class_1842>();
    private Optional<class_6880<class_1842>> selectedPotion = Optional.empty();
    private Optional<Integer> customColor = Optional.empty();

    public PotionContentsEditorGui(class_437 parent, class_1844 initial, Consumer<class_1844> onSave) {
        super("Potion Contents Editor", parent);
        this.onSave = onSave;
        if (initial != null) {
            this.selectedPotion = initial.comp_2378();
            this.customColor = initial.comp_2379();
            this.customEffects.addAll(initial.comp_2380());
        }
        this.loadPotions();
    }

    private void loadPotions() {
        for (class_1842 potion : class_7923.field_41179) {
            this.allPotions.add(potion);
        }
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        int panelWidth = 350;
        int panelX = centerX - panelWidth / 2;
        LabelWidget title = new LabelWidget("title", centerX, 10, "\u00a76\u00a7lPotion Contents Editor", -1, true, true);
        this.addWidget(title);
        LabelWidget potionLabel = new LabelWidget("potion_label", panelX, 35, "\u00a7eBase Potion:", -1, false, false);
        this.addWidget(potionLabel);
        this.potionDropdown = new DropdownWidget("potion_dropdown", panelX, 50, panelWidth, 20);
        this.potionDropdown.addOption("None");
        for (class_1842 potion : this.allPotions) {
            String name = class_7923.field_41179.method_10221((Object)potion).toString();
            this.potionDropdown.addOption(name);
        }
        if (this.selectedPotion.isPresent()) {
            String name = class_7923.field_41179.method_10221((Object)((class_1842)this.selectedPotion.get().comp_349())).toString();
            for (int i = 0; i < this.potionDropdown.getOptions().size(); ++i) {
                if (!this.potionDropdown.getOptions().get(i).equals(name)) continue;
                this.potionDropdown.setSelectedIndex(i);
                break;
            }
        }
        this.addWidget(this.potionDropdown);
        LabelWidget colorLabel = new LabelWidget("color_label", panelX, 80, "\u00a7eCustom Color (RGB hex, e.g., FF5733):", -1, false, false);
        this.addWidget(colorLabel);
        this.customColorInput = new TextBoxWidget("color_input", panelX, 95, panelWidth, 20, -14671840, -8355712, -1, -10461088);
        if (this.customColor.isPresent()) {
            this.customColorInput.setValue(String.format("%06X", this.customColor.get()));
        }
        this.customColorInput.setMaxLength(6);
        this.customColorInput.setHint("RRGGBB");
        this.addWidget(this.customColorInput);
        LabelWidget effectsLabel = new LabelWidget("effects_label", panelX, 125, "\u00a7eCustom Effects:", -1, false, false);
        this.addWidget(effectsLabel);
        this.effectList = new ScrollMenuWidget("effect_list", panelX, 140, panelWidth, 100, -15066598, -14013910, -12632257, -1, -10461088);
        this.effectList.setItemHeight(20);
        this.updateEffectList();
        this.addWidget(this.effectList);
        ButtonWidget addEffectBtn = new ButtonWidget("add_effect", panelX, 250, 100, 20, "Add Effect", -13996502, -13004999, -1);
        addEffectBtn.setOnPress(() -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507((class_437)new MobEffectEditorGui(this, null, effect -> {
                    this.customEffects.add((class_1293)effect);
                    this.updateEffectList();
                }));
            }
        });
        this.addWidget(addEffectBtn);
        ButtonWidget removeEffectBtn = new ButtonWidget("remove_effect", panelX + 110, 250, 110, 20, "Remove", -9557462, -7390919, -1);
        removeEffectBtn.setOnPress(() -> {
            int selected = this.effectList.getSelectedIndex();
            if (selected >= 0 && selected < this.customEffects.size()) {
                this.customEffects.remove(selected);
                this.updateEffectList();
            }
        });
        this.addWidget(removeEffectBtn);
        ButtonWidget clearEffectsBtn = new ButtonWidget("clear_effects", panelX + 230, 250, 120, 20, "Clear All", -9557462, -7390919, -1);
        clearEffectsBtn.setOnPress(() -> {
            this.customEffects.clear();
            this.updateEffectList();
        });
        this.addWidget(clearEffectsBtn);
        ButtonWidget saveBtn = new ButtonWidget("save", centerX - 105, this.field_22790 - 35, 100, 20, "Apply", -13996502, -13004999, -1);
        saveBtn.setOnPress(() -> {
            this.savePotionContents();
            this.method_25419();
        });
        this.addWidget(saveBtn);
        ButtonWidget cancelBtn = new ButtonWidget("cancel", centerX + 5, this.field_22790 - 35, 100, 20, "Cancel", -9737365, -7697782, -1);
        cancelBtn.setOnPress(this::method_25419);
        this.addWidget(cancelBtn);
    }

    private void updateEffectList() {
        this.effectList.clearItems();
        for (class_1293 effect : this.customEffects) {
            Optional key = effect.method_5579().method_40230();
            String name = key.isPresent() ? ((class_5321)key.get()).method_29177().method_12832() : "unknown";
            String text = name + " " + (effect.method_5578() + 1) + " (" + effect.method_5584() + "t)";
            this.effectList.addItem(text);
        }
    }

    private void savePotionContents() {
        String colorText;
        class_1844 contents = class_1844.field_49274;
        int selectedIdx = this.potionDropdown.getSelectedIndex();
        if (selectedIdx > 0 && selectedIdx <= this.allPotions.size()) {
            class_6880 potion = class_7923.field_41179.method_47983((Object)this.allPotions.get(selectedIdx - 1));
            contents = new class_1844(Optional.of(potion), contents.comp_2379(), contents.comp_2380(), contents.comp_3209());
        }
        if (!(colorText = this.customColorInput.getValue().trim()).isEmpty()) {
            try {
                int color = Integer.parseInt(colorText, 16);
                contents = new class_1844(contents.comp_2378(), Optional.of(color), contents.comp_2380(), contents.comp_3209());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (!this.customEffects.isEmpty()) {
            contents = new class_1844(contents.comp_2378(), contents.comp_2379(), this.customEffects, contents.comp_3209());
        }
        if (this.onSave != null) {
            this.onSave.accept(contents);
        }
    }
}

