/*
 * Decompiled with CFR 0.152.
 */
package net.jackson.simplegui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jackson.simplegui.widget.GuiWidget;
import net.jackson.simplegui.widget.TextBoxWidget;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class SimpleGuiScreen
extends class_437 {
    private final List<GuiWidget> widgets = new ArrayList<GuiWidget>();
    private final Map<String, GuiWidget> widgetMap = new HashMap<String, GuiWidget>();
    private final Map<String, Consumer<GuiWidget>> buttonActions = new HashMap<String, Consumer<GuiWidget>>();
    private final class_437 parent;
    private int backgroundColorStart = -1072689136;
    private int backgroundColorEnd = -804253680;
    private boolean renderDirtBackground = false;

    public SimpleGuiScreen(class_2561 title, class_437 parent) {
        super(title);
        this.parent = parent;
    }

    public SimpleGuiScreen(String title, class_437 parent) {
        this((class_2561)class_2561.method_43470((String)title), parent);
    }

    protected void method_25426() {
        super.method_25426();
        this.widgets.clear();
        for (GuiWidget widget : this.widgetMap.values()) {
            int offset;
            widget.init(this.field_22787, this);
            int x = widget.getX();
            int y = widget.getY();
            if (x < -999999) {
                offset = x + 1000000;
                x = (this.field_22789 - widget.getWidth()) / 2 + offset;
            }
            if (y < -1999999) {
                offset = y + 2000000;
                y = (this.field_22790 - widget.getHeight()) / 2 + offset;
            }
            widget.setPosition(x, y);
            this.widgets.add(widget);
        }
    }

    public void addWidget(GuiWidget widget) {
        widget.init(this.field_22787, this);
        this.widgets.add(widget);
        if (widget.getId() != null && !widget.getId().isEmpty()) {
            this.widgetMap.put(widget.getId(), widget);
        }
    }

    public GuiWidget getWidget(String id) {
        return this.widgetMap.get(id);
    }

    public class_310 getMinecraft() {
        return this.field_22787;
    }

    public class_746 getPlayer() {
        return this.field_22787 != null ? this.field_22787.field_1724 : null;
    }

    public void registerButtonAction(String buttonId, Consumer<GuiWidget> action) {
        this.buttonActions.put(buttonId, action);
    }

    public void executeButtonAction(String buttonId, GuiWidget widget) {
        Consumer<GuiWidget> action = this.buttonActions.get(buttonId);
        if (action != null) {
            action.accept(widget);
        }
    }

    public void setBackgroundColors(int start, int end) {
        this.backgroundColorStart = start;
        this.backgroundColorEnd = end;
    }

    public void setRenderDirtBackground(boolean render) {
        this.renderDirtBackground = render;
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        if (this.renderDirtBackground) {
            this.method_25420(graphics, mouseX, mouseY, partialTick);
        } else {
            graphics.method_25296(0, 0, this.field_22789, this.field_22790, this.backgroundColorStart, this.backgroundColorEnd);
        }
        for (GuiWidget widget : this.widgets) {
            widget.render(graphics, mouseX, mouseY, partialTick);
        }
        for (GuiWidget widget : this.widgets) {
            if (!widget.hasOverlayActive()) continue;
            widget.renderOverlay(graphics, mouseX, mouseY, partialTick);
        }
        super.method_25394(graphics, mouseX, mouseY, partialTick);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            GuiWidget widget = this.widgets.get(i);
            if (!widget.hasOverlayActive() || !widget.mouseClicked(mouseX, mouseY, button)) continue;
            return true;
        }
        for (GuiWidget widget : this.widgets) {
            if (!widget.mouseClicked(mouseX, mouseY, button)) continue;
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        for (GuiWidget widget : this.widgets) {
            if (!widget.mouseReleased(mouseX, mouseY, button)) continue;
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        for (GuiWidget widget : this.widgets) {
            if (!widget.mouseDragged(mouseX, mouseY, button, dragX, dragY)) continue;
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        for (GuiWidget widget : this.widgets) {
            if (!widget.mouseScrolled(mouseX, mouseY, scrollX, scrollY)) continue;
            return true;
        }
        return super.method_25401(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        for (GuiWidget widget : this.widgets) {
            if (!widget.keyPressed(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char codePoint, int modifiers) {
        for (GuiWidget widget : this.widgets) {
            if (!widget.charTyped(codePoint, modifiers)) continue;
            return true;
        }
        return super.method_25400(codePoint, modifiers);
    }

    public void closeAllOverlays() {
        for (GuiWidget widget : this.widgets) {
            if (!widget.hasOverlayActive()) continue;
            widget.closeOverlay();
        }
    }

    public void method_25419() {
        this.closeAllOverlays();
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    public Map<String, String> getAllTextBoxValues() {
        HashMap<String, String> values = new HashMap<String, String>();
        for (Map.Entry<String, GuiWidget> entry : this.widgetMap.entrySet()) {
            if (!(entry.getValue() instanceof TextBoxWidget)) continue;
            TextBoxWidget textBox = (TextBoxWidget)entry.getValue();
            values.put(entry.getKey(), textBox.getValue());
        }
        return values;
    }

    public class_437 getParent() {
        return this.parent;
    }
}

