/*
 * Decompiled with CFR 0.152.
 */
package net.jackson.simplegui;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jackson.simplegui.SimpleGuiScreen;
import net.jackson.simplegui.widget.ButtonWidget;
import net.jackson.simplegui.widget.DropdownWidget;
import net.jackson.simplegui.widget.LabelWidget;
import net.jackson.simplegui.widget.TextBoxWidget;
import net.minecraft.class_1291;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9298;

@Environment(value=EnvType.CLIENT)
public class StewEffectEditorGui
extends SimpleGuiScreen {
    private final Consumer<class_9298.class_8751> onSave;
    private DropdownWidget effectDropdown;
    private TextBoxWidget durationInput;
    private final List<class_6880<class_1291>> allEffects = new ArrayList<class_6880<class_1291>>();

    public StewEffectEditorGui(class_437 parent, class_9298.class_8751 initial, Consumer<class_9298.class_8751> onSave) {
        super("Stew Effect Editor", parent);
        this.onSave = onSave;
        for (class_1291 effect : class_7923.field_41174) {
            this.allEffects.add((class_6880<class_1291>)class_7923.field_41174.method_47983((Object)effect));
        }
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        int panelWidth = 300;
        int panelX = centerX - panelWidth / 2;
        LabelWidget title = new LabelWidget("title", centerX, 10, "\u00a76\u00a7lStew Effect", -1, true, true);
        this.addWidget(title);
        LabelWidget effectLabel = new LabelWidget("effect_label", panelX, 40, "\u00a7eEffect Type:", -1, false, false);
        this.addWidget(effectLabel);
        this.effectDropdown = new DropdownWidget("effect_dropdown", panelX, 55, panelWidth, 20);
        for (class_6880<class_1291> effect : this.allEffects) {
            Optional key = effect.method_40230();
            String name = key.isPresent() ? ((class_5321)key.get()).method_29177().method_12832().replace("_", " ") : "unknown";
            this.effectDropdown.addOption(name);
        }
        this.addWidget(this.effectDropdown);
        LabelWidget durationLabel = new LabelWidget("duration_label", panelX, 90, "\u00a7eDuration (ticks, 20t = 1s):", -1, false, false);
        this.addWidget(durationLabel);
        this.durationInput = new TextBoxWidget("duration_input", panelX, 105, panelWidth, 20, -14671840, -8355712, -1, -10461088);
        this.durationInput.setValue("100");
        this.durationInput.setMaxLength(6);
        this.durationInput.setHint("100 = 5 seconds");
        this.addWidget(this.durationInput);
        LabelWidget infoLabel = new LabelWidget("info_label", panelX, 140, "\u00a77Suspicious stew effects are brief", -5592406, false, false);
        this.addWidget(infoLabel);
        ButtonWidget saveBtn = new ButtonWidget("save", centerX - 105, this.field_22790 - 35, 100, 20, "Add", -13996502, -13004999, -1);
        saveBtn.setOnPress(() -> {
            this.saveEffect();
            this.method_25419();
        });
        this.addWidget(saveBtn);
        ButtonWidget cancelBtn = new ButtonWidget("cancel", centerX + 5, this.field_22790 - 35, 100, 20, "Cancel", -9737365, -7697782, -1);
        cancelBtn.setOnPress(this::method_25419);
        this.addWidget(cancelBtn);
    }

    private void saveEffect() {
        int effectIdx = this.effectDropdown.getSelectedIndex();
        if (effectIdx < 0 || effectIdx >= this.allEffects.size()) {
            return;
        }
        class_6880<class_1291> effect = this.allEffects.get(effectIdx);
        int duration = 100;
        try {
            duration = Integer.parseInt(this.durationInput.getValue());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        class_9298.class_8751 entry = new class_9298.class_8751(effect, duration);
        if (this.onSave != null) {
            this.onSave.accept(entry);
        }
    }
}

