/*
 * Decompiled with CFR 0.152.
 */
package net.jackson.simplegui;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jackson.simplegui.SimpleGuiScreen;
import net.jackson.simplegui.StewEffectEditorGui;
import net.jackson.simplegui.widget.ButtonWidget;
import net.jackson.simplegui.widget.LabelWidget;
import net.jackson.simplegui.widget.ScrollMenuWidget;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_9298;

@Environment(value=EnvType.CLIENT)
public class SuspiciousStewEditorGui
extends SimpleGuiScreen {
    private final Consumer<class_9298> onSave;
    private ScrollMenuWidget effectList;
    private final List<class_9298.class_8751> entries = new ArrayList<class_9298.class_8751>();

    public SuspiciousStewEditorGui(class_437 parent, class_9298 initial, Consumer<class_9298> onSave) {
        super("Suspicious Stew Effects", parent);
        this.onSave = onSave;
        if (initial != null) {
            this.entries.addAll(initial.comp_2416());
        }
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        int panelWidth = 350;
        int panelX = centerX - panelWidth / 2;
        LabelWidget title = new LabelWidget("title", centerX, 10, "\u00a76\u00a7lSuspicious Stew Effects", -1, true, true);
        this.addWidget(title);
        LabelWidget infoLabel = new LabelWidget("info_label", panelX, 35, "\u00a77Effects for suspicious stew consumption", -5592406, false, false);
        this.addWidget(infoLabel);
        LabelWidget listLabel = new LabelWidget("list_label", panelX, 55, "\u00a7eStew Effects:", -1, false, false);
        this.addWidget(listLabel);
        this.effectList = new ScrollMenuWidget("effect_list", panelX, 70, panelWidth, 150, -15066598, -14013910, -12632257, -1, -10461088);
        this.effectList.setItemHeight(20);
        this.updateEffectList();
        this.addWidget(this.effectList);
        ButtonWidget addBtn = new ButtonWidget("add_effect", panelX, 230, 110, 20, "Add Effect", -13996502, -13004999, -1);
        addBtn.setOnPress(() -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507((class_437)new StewEffectEditorGui(this, null, entry -> {
                    this.entries.add((class_9298.class_8751)entry);
                    this.updateEffectList();
                }));
            }
        });
        this.addWidget(addBtn);
        ButtonWidget removeBtn = new ButtonWidget("remove_effect", panelX + 120, 230, 110, 20, "Remove", -9557462, -7390919, -1);
        removeBtn.setOnPress(() -> {
            int selected = this.effectList.getSelectedIndex();
            if (selected >= 0 && selected < this.entries.size()) {
                this.entries.remove(selected);
                this.updateEffectList();
            }
        });
        this.addWidget(removeBtn);
        ButtonWidget clearBtn = new ButtonWidget("clear_effects", panelX + 240, 230, 110, 20, "Clear All", -9557462, -7390919, -1);
        clearBtn.setOnPress(() -> {
            this.entries.clear();
            this.updateEffectList();
        });
        this.addWidget(clearBtn);
        ButtonWidget saveBtn = new ButtonWidget("save", centerX - 105, this.field_22790 - 35, 100, 20, "Apply", -13996502, -13004999, -1);
        saveBtn.setOnPress(() -> {
            this.saveStewEffects();
            this.method_25419();
        });
        this.addWidget(saveBtn);
        ButtonWidget cancelBtn = new ButtonWidget("cancel", centerX + 5, this.field_22790 - 35, 100, 20, "Cancel", -9737365, -7697782, -1);
        cancelBtn.setOnPress(this::method_25419);
        this.addWidget(cancelBtn);
    }

    private void updateEffectList() {
        this.effectList.clearItems();
        for (class_9298.class_8751 entry : this.entries) {
            Optional key = entry.comp_1838().method_40230();
            String name = key.isPresent() ? ((class_5321)key.get()).method_29177().method_12832() : "unknown";
            this.effectList.addItem(name + " (" + entry.comp_1839() + "t)");
        }
    }

    private void saveStewEffects() {
        class_9298 effects = new class_9298(this.entries);
        if (this.onSave != null) {
            this.onSave.accept(effects);
        }
    }
}

