/*
 * Decompiled with CFR 0.152.
 */
package net.jackson.simplegui.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jackson.simplegui.SimpleGuiScreen;
import net.jackson.simplegui.widget.ButtonWidget;
import net.jackson.simplegui.widget.DropdownWidget;
import net.jackson.simplegui.widget.GuiWidget;
import net.jackson.simplegui.widget.LabelWidget;
import net.jackson.simplegui.widget.ScrollMenuWidget;
import net.jackson.simplegui.widget.TextBoxWidget;
import net.minecraft.class_437;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class GuiJsonParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(GuiJsonParser.class);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static SimpleGuiScreen parseFromFile(Path jsonFile, class_437 parent) {
        try {
            String content = Files.readString(jsonFile);
            return GuiJsonParser.parseFromString(content, parent);
        }
        catch (IOException e) {
            LOGGER.error("Failed to read GUI JSON file: " + String.valueOf(jsonFile), (Throwable)e);
            return null;
        }
    }

    public static SimpleGuiScreen parseFromString(String json, class_437 parent) {
        try {
            JsonObject root = (JsonObject)GSON.fromJson(json, JsonObject.class);
            return GuiJsonParser.parseFromJson(root, parent);
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse GUI JSON", (Throwable)e);
            return null;
        }
    }

    public static SimpleGuiScreen parseFromJson(JsonObject root, class_437 parent) {
        String title = root.has("title") ? root.get("title").getAsString() : "Simple GUI";
        SimpleGuiScreen screen = new SimpleGuiScreen(title, parent);
        if (root.has("background")) {
            JsonObject bg = root.getAsJsonObject("background");
            if (bg.has("type") && bg.get("type").getAsString().equals("dirt")) {
                screen.setRenderDirtBackground(true);
            } else {
                int startColor = GuiJsonParser.parseColor(bg, "startColor", -1072689136);
                int endColor = GuiJsonParser.parseColor(bg, "endColor", -804253680);
                screen.setBackgroundColors(startColor, endColor);
            }
        }
        if (root.has("widgets")) {
            JsonArray widgets = root.getAsJsonArray("widgets");
            for (JsonElement element : widgets) {
                JsonObject widgetJson = element.getAsJsonObject();
                GuiWidget widget = GuiJsonParser.parseWidget(widgetJson, screen);
                if (widget == null) continue;
                screen.addWidget(widget);
            }
        }
        return screen;
    }

    private static GuiWidget parseWidget(JsonObject json, SimpleGuiScreen screen) {
        String type = json.get("type").getAsString();
        String id = json.has("id") ? json.get("id").getAsString() : "";
        JsonObject pos = json.has("position") ? json.getAsJsonObject("position") : new JsonObject();
        int x = GuiJsonParser.calculatePosition(pos, "x", 0, screen);
        int y = GuiJsonParser.calculatePosition(pos, "y", 0, screen);
        JsonObject size = json.has("size") ? json.getAsJsonObject("size") : new JsonObject();
        int width = size.has("width") ? size.get("width").getAsInt() : 200;
        int height = size.has("height") ? size.get("height").getAsInt() : 20;
        GuiWidget widget = null;
        switch (type.toLowerCase()) {
            case "button": {
                widget = GuiJsonParser.parseButton(json, id, x, y, width, height);
                break;
            }
            case "textbox": {
                widget = GuiJsonParser.parseTextBox(json, id, x, y, width, height);
                break;
            }
            case "label": {
                widget = GuiJsonParser.parseLabel(json, id, x, y);
                break;
            }
            case "dropdown": {
                widget = GuiJsonParser.parseDropdown(json, id, x, y, width, height);
                break;
            }
            case "scrollmenu": {
                widget = GuiJsonParser.parseScrollMenu(json, id, x, y, width, height);
                break;
            }
            default: {
                LOGGER.warn("Unknown widget type: " + type);
            }
        }
        if (widget != null) {
            if (json.has("visible")) {
                widget.setVisible(json.get("visible").getAsBoolean());
            }
            if (json.has("enabled")) {
                widget.setEnabled(json.get("enabled").getAsBoolean());
            }
        }
        return widget;
    }

    private static ButtonWidget parseButton(JsonObject json, String id, int x, int y, int width, int height) {
        String text = json.has("text") ? json.get("text").getAsString() : "Button";
        int bgColor = GuiJsonParser.parseColor(json, "backgroundColor", -7631989);
        int hoverColor = GuiJsonParser.parseColor(json, "hoverColor", -6250336);
        int textColor = GuiJsonParser.parseColor(json, "textColor", -1);
        ButtonWidget button = new ButtonWidget(id, x, y, width, height, text, bgColor, hoverColor, textColor);
        if (json.has("action")) {
            String action = json.get("action").getAsString();
            LOGGER.info("Button '{}' has action: {}", (Object)id, (Object)action);
        }
        return button;
    }

    private static TextBoxWidget parseTextBox(JsonObject json, String id, int x, int y, int width, int height) {
        int bgColor = GuiJsonParser.parseColor(json, "backgroundColor", -16777216);
        int borderColor = GuiJsonParser.parseColor(json, "borderColor", -6250336);
        int textColor = GuiJsonParser.parseColor(json, "textColor", -2039584);
        int hintColor = GuiJsonParser.parseColor(json, "hintColor", -9408400);
        TextBoxWidget textBox = new TextBoxWidget(id, x, y, width, height, bgColor, borderColor, textColor, hintColor);
        if (json.has("hint")) {
            textBox.setHint(json.get("hint").getAsString());
        }
        if (json.has("maxLength")) {
            textBox.setMaxLength(json.get("maxLength").getAsInt());
        }
        if (json.has("defaultValue")) {
            textBox.setValue(json.get("defaultValue").getAsString());
        }
        if (json.has("password")) {
            textBox.setPassword(json.get("password").getAsBoolean());
        }
        return textBox;
    }

    private static LabelWidget parseLabel(JsonObject json, String id, int x, int y) {
        String text = json.has("text") ? json.get("text").getAsString() : "";
        int textColor = GuiJsonParser.parseColor(json, "textColor", -1);
        boolean centered = json.has("centered") && json.get("centered").getAsBoolean();
        boolean shadow = !json.has("shadow") || json.get("shadow").getAsBoolean();
        return new LabelWidget(id, x, y, text, textColor, centered, shadow);
    }

    private static DropdownWidget parseDropdown(JsonObject json, String id, int x, int y, int width, int height) {
        int bgColor = GuiJsonParser.parseColor(json, "backgroundColor", -16777216);
        int hoverColor = GuiJsonParser.parseColor(json, "hoverColor", -13619152);
        int textColor = GuiJsonParser.parseColor(json, "textColor", -1);
        DropdownWidget dropdown = new DropdownWidget(id, x, y, width, height, bgColor, hoverColor, textColor);
        if (json.has("options")) {
            JsonArray options = json.getAsJsonArray("options");
            for (JsonElement option : options) {
                dropdown.addOption(option.getAsString());
            }
        }
        if (json.has("selectedIndex")) {
            dropdown.setSelectedIndex(json.get("selectedIndex").getAsInt());
        }
        return dropdown;
    }

    private static ScrollMenuWidget parseScrollMenu(JsonObject json, String id, int x, int y, int width, int height) {
        int bgColor = GuiJsonParser.parseColor(json, "backgroundColor", -16777216);
        int itemColor = GuiJsonParser.parseColor(json, "itemColor", -14671840);
        int hoverColor = GuiJsonParser.parseColor(json, "hoverColor", -12566464);
        int textColor = GuiJsonParser.parseColor(json, "textColor", -1);
        int scrollbarColor = GuiJsonParser.parseColor(json, "scrollbarColor", -8355712);
        ScrollMenuWidget scrollMenu = new ScrollMenuWidget(id, x, y, width, height, bgColor, itemColor, hoverColor, textColor, scrollbarColor);
        if (json.has("items")) {
            JsonArray items = json.getAsJsonArray("items");
            for (JsonElement item : items) {
                scrollMenu.addItem(item.getAsString());
            }
        }
        if (json.has("itemHeight")) {
            scrollMenu.setItemHeight(json.get("itemHeight").getAsInt());
        }
        return scrollMenu;
    }

    private static int calculatePosition(JsonObject pos, String key, int defaultValue, SimpleGuiScreen screen) {
        String value;
        if (!pos.has(key)) {
            return defaultValue;
        }
        JsonElement element = pos.get(key);
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isNumber()) {
            return element.getAsInt();
        }
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString() && (value = element.getAsString()).startsWith("center")) {
            int offset = 0;
            if (value.contains("+")) {
                offset = Integer.parseInt(value.substring(value.indexOf("+") + 1).trim());
            } else if (value.contains("-")) {
                offset = -Integer.parseInt(value.substring(value.indexOf("-") + 1).trim());
            }
            if (key.equals("x")) {
                return -1000000 + offset;
            }
            return -2000000 + offset;
        }
        return defaultValue;
    }

    private static int parseColor(JsonObject json, String key, int defaultValue) {
        if (!json.has(key)) {
            return defaultValue;
        }
        JsonElement element = json.get(key);
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isNumber()) {
            return element.getAsInt();
        }
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
            Object colorStr = element.getAsString();
            if (((String)colorStr).startsWith("#")) {
                colorStr = ((String)colorStr).substring(1);
            }
            if (((String)colorStr).startsWith("0x")) {
                colorStr = ((String)colorStr).substring(2);
            }
            try {
                if (((String)colorStr).length() == 6) {
                    colorStr = "FF" + (String)colorStr;
                }
                return (int)Long.parseLong((String)colorStr, 16);
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Invalid color format: " + (String)colorStr);
            }
        }
        return defaultValue;
    }

    public static String createExampleJson() {
        JsonObject root = new JsonObject();
        root.addProperty("title", "Example GUI");
        JsonObject background = new JsonObject();
        background.addProperty("startColor", "#C0101010");
        background.addProperty("endColor", "#D0101010");
        root.add("background", (JsonElement)background);
        JsonArray widgets = new JsonArray();
        JsonObject titleLabel = new JsonObject();
        titleLabel.addProperty("type", "label");
        titleLabel.addProperty("id", "title");
        titleLabel.addProperty("text", "Example Form");
        JsonObject titlePos = new JsonObject();
        titlePos.addProperty("x", "center");
        titlePos.addProperty("y", (Number)20);
        titleLabel.add("position", (JsonElement)titlePos);
        titleLabel.addProperty("centered", Boolean.valueOf(true));
        widgets.add((JsonElement)titleLabel);
        JsonObject usernameBox = new JsonObject();
        usernameBox.addProperty("type", "textbox");
        usernameBox.addProperty("id", "username");
        usernameBox.addProperty("hint", "Enter username...");
        JsonObject usernamePos = new JsonObject();
        usernamePos.addProperty("x", "center-100");
        usernamePos.addProperty("y", (Number)50);
        usernameBox.add("position", (JsonElement)usernamePos);
        JsonObject usernameSize = new JsonObject();
        usernameSize.addProperty("width", (Number)200);
        usernameSize.addProperty("height", (Number)20);
        usernameBox.add("size", (JsonElement)usernameSize);
        widgets.add((JsonElement)usernameBox);
        JsonObject submitButton = new JsonObject();
        submitButton.addProperty("type", "button");
        submitButton.addProperty("id", "submit");
        submitButton.addProperty("text", "Submit");
        JsonObject submitPos = new JsonObject();
        submitPos.addProperty("x", "center-50");
        submitPos.addProperty("y", (Number)80);
        submitButton.add("position", (JsonElement)submitPos);
        JsonObject submitSize = new JsonObject();
        submitSize.addProperty("width", (Number)100);
        submitSize.addProperty("height", (Number)20);
        submitButton.add("size", (JsonElement)submitSize);
        widgets.add((JsonElement)submitButton);
        root.add("widgets", (JsonElement)widgets);
        return GSON.toJson((JsonElement)root);
    }
}

