/*
 * Decompiled with CFR 0.152.
 */
package net.jackson.simplegui.widget;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jackson.simplegui.widget.GuiWidget;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_490;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class ArmorStandPreviewWidget
extends GuiWidget {
    private final int backgroundColor;
    private class_1531 armorStand;
    private class_1799 helmetStack = class_1799.field_8037;
    private class_1799 chestplateStack = class_1799.field_8037;
    private class_1799 leggingsStack = class_1799.field_8037;
    private class_1799 bootsStack = class_1799.field_8037;

    public ArmorStandPreviewWidget(String id, int x, int y, int width, int height, int backgroundColor) {
        super(id, x, y, width, height);
        this.backgroundColor = backgroundColor;
    }

    @Override
    public void init(class_310 minecraft, class_437 screen) {
        super.init(minecraft, screen);
        this.createArmorStand();
    }

    private void createArmorStand() {
        if (this.minecraft != null && this.minecraft.field_1687 != null) {
            this.armorStand = new class_1531(class_1299.field_6131, (class_1937)this.minecraft.field_1687);
            this.armorStand.method_5875(true);
            this.armorStand.method_5684(true);
            this.armorStand.method_6913(false);
            this.armorStand.method_6907(false);
            this.updateArmorStandEquipment();
        }
    }

    public void setHelmet(class_1799 stack) {
        this.helmetStack = stack;
        this.updateArmorStandEquipment();
    }

    public void setChestplate(class_1799 stack) {
        this.chestplateStack = stack;
        this.updateArmorStandEquipment();
    }

    public void setLeggings(class_1799 stack) {
        this.leggingsStack = stack;
        this.updateArmorStandEquipment();
    }

    public void setBoots(class_1799 stack) {
        this.bootsStack = stack;
        this.updateArmorStandEquipment();
    }

    public void setAllArmor(class_1799 helmet, class_1799 chestplate, class_1799 leggings, class_1799 boots) {
        this.helmetStack = helmet;
        this.chestplateStack = chestplate;
        this.leggingsStack = leggings;
        this.bootsStack = boots;
        this.updateArmorStandEquipment();
    }

    private void updateArmorStandEquipment() {
        if (this.armorStand != null) {
            this.armorStand.method_5673(class_1304.field_6169, this.helmetStack);
            this.armorStand.method_5673(class_1304.field_6174, this.chestplateStack);
            this.armorStand.method_5673(class_1304.field_6172, this.leggingsStack);
            this.armorStand.method_5673(class_1304.field_6166, this.bootsStack);
        }
    }

    @Override
    public void render(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        if (!this.visible) {
            return;
        }
        graphics.method_25294(this.x, this.y, this.x + this.width, this.y + this.height, this.backgroundColor);
        graphics.method_25294(this.x, this.y, this.x + this.width, this.y + 1, -12566464);
        graphics.method_25294(this.x, this.y + this.height - 1, this.x + this.width, this.y + this.height, -12566464);
        graphics.method_25294(this.x, this.y, this.x + 1, this.y + this.height, -12566464);
        graphics.method_25294(this.x + this.width - 1, this.y, this.x + this.width, this.y + this.height, -12566464);
        if (this.armorStand != null && this.minecraft != null) {
            this.renderArmorStandInGui(graphics, this.x + this.width / 2, this.y + this.height - 20, partialTick);
        }
    }

    private void renderArmorStandInGui(class_332 graphics, int posX, int posY, float partialTick) {
        int scale = this.height / 3;
        Quaternionf pose = new Quaternionf().rotateXYZ(0.0f, 0.0f, 0.0f);
        Quaternionf cameraOrientation = new Quaternionf().rotateXYZ((float)Math.toRadians(-10.0), 0.0f, (float)Math.PI);
        this.armorStand.method_36456((float)Math.toDegrees(0.7853981633974483));
        this.armorStand.method_36457(0.0f);
        this.armorStand.field_6283 = (float)Math.toDegrees(0.7853981633974483);
        this.armorStand.field_6241 = (float)Math.toDegrees(0.7853981633974483);
        this.armorStand.field_6259 = (float)Math.toDegrees(0.7853981633974483);
        class_490.method_48472((class_332)graphics, (float)posX, (float)posY, (float)scale, (Vector3f)new Vector3f(0.0f, 0.0f, 0.0f), (Quaternionf)cameraOrientation, (Quaternionf)pose, (class_1309)this.armorStand);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return this.isMouseOver(mouseX, mouseY);
    }

    public void clearArmor() {
        this.helmetStack = class_1799.field_8037;
        this.chestplateStack = class_1799.field_8037;
        this.leggingsStack = class_1799.field_8037;
        this.bootsStack = class_1799.field_8037;
        this.updateArmorStandEquipment();
    }

    public class_1531 getArmorStand() {
        return this.armorStand;
    }
}

