/*
 * Decompiled with CFR 0.152.
 */
package net.jackson.simplegui.widget;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jackson.simplegui.widget.GuiWidget;
import net.minecraft.class_1799;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class DropdownWidget
extends GuiWidget {
    private final List<String> options = new ArrayList<String>();
    private final Map<Integer, class_1799> itemOverlays = new HashMap<Integer, class_1799>();
    private int selectedIndex = 0;
    private boolean expanded = false;
    private final int backgroundColor;
    private final int hoverColor;
    private final int textColor;
    private Consumer<Integer> onChanged;
    private int scrollOffset = 0;

    public DropdownWidget(String id, int x, int y, int width, int height) {
        this(id, x, y, width, height, -16777216, -13619152, -1);
    }

    public DropdownWidget(String id, int x, int y, int width, int height, int backgroundColor, int hoverColor, int textColor) {
        super(id, x, y, width, height);
        this.backgroundColor = backgroundColor;
        this.hoverColor = hoverColor;
        this.textColor = textColor;
    }

    public void addOption(String option) {
        this.options.add(option);
    }

    public void setOptions(List<String> options) {
        this.options.clear();
        this.options.addAll(options);
        if (this.selectedIndex >= this.options.size()) {
            this.selectedIndex = Math.max(0, this.options.size() - 1);
        }
        this.scrollOffset = 0;
    }

    public void setSelectedIndex(int index) {
        if (index >= 0 && index < this.options.size()) {
            this.selectedIndex = index;
            if (this.onChanged != null) {
                this.onChanged.accept(this.selectedIndex);
            }
        }
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public String getSelectedOption() {
        if (this.selectedIndex >= 0 && this.selectedIndex < this.options.size()) {
            return this.options.get(this.selectedIndex);
        }
        return "";
    }

    public List<String> getOptions() {
        return new ArrayList<String>(this.options);
    }

    public void setOnChanged(Consumer<Integer> onChanged) {
        this.onChanged = onChanged;
    }

    public void setItemOverlay(int index, class_1799 itemStack) {
        if (index >= 0 && index < this.options.size()) {
            if (itemStack != null && !itemStack.method_7960()) {
                this.itemOverlays.put(index, itemStack);
            } else {
                this.itemOverlays.remove(index);
            }
        }
    }

    public void setItemOverlays(Map<Integer, class_1799> overlays) {
        this.itemOverlays.clear();
        if (overlays != null) {
            this.itemOverlays.putAll(overlays);
        }
    }

    public void clearItemOverlays() {
        this.itemOverlays.clear();
    }

    public class_1799 getItemOverlay(int index) {
        return this.itemOverlays.get(index);
    }

    @Override
    public void render(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        if (!this.visible) {
            return;
        }
        boolean mainHovered = !this.expanded && this.isMouseOver(mouseX, mouseY);
        int mainColor = mainHovered ? this.hoverColor : this.backgroundColor;
        graphics.method_25294(this.x, this.y, this.x + this.width, this.y + this.height, mainColor);
        graphics.method_25294(this.x, this.y, this.x + this.width, this.y + 1, -1);
        graphics.method_25294(this.x, this.y, this.x + 1, this.y + this.height, -1);
        graphics.method_25294(this.x + this.width - 1, this.y, this.x + this.width, this.y + this.height, -16777216);
        graphics.method_25294(this.x, this.y + this.height - 1, this.x + this.width, this.y + this.height, -16777216);
        String sel = this.getSelectedOption();
        int textX = this.x + 4;
        int textY = this.y + (this.height - 8) / 2;
        graphics.method_51433(this.minecraft.field_1772, sel, textX, textY, this.textColor, false);
    }

    @Override
    public void renderOverlay(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        int optIndex;
        if (!this.visible || !this.expanded) {
            return;
        }
        int itemHeight = this.height;
        int spaceBelow = this.screen.field_22790 - (this.y + this.height) - 6;
        int maxVisible = Math.max(1, spaceBelow / itemHeight);
        int totalItems = this.options.size();
        int visibleItems = Math.min(totalItems, maxVisible);
        int expandedHeight = visibleItems * itemHeight;
        int listTop = this.y + this.height;
        graphics.method_25294(this.x, listTop, this.x + this.width, listTop + expandedHeight, this.backgroundColor);
        graphics.method_25294(this.x, listTop, this.x + this.width, listTop + 1, -1);
        graphics.method_25294(this.x, listTop + expandedHeight - 1, this.x + this.width, listTop + expandedHeight, -16777216);
        graphics.method_44379(this.x + 1, listTop + 1, this.x + this.width - 1, listTop + expandedHeight - 1);
        int hoveredIndex = -1;
        if (mouseX >= this.x && mouseX < this.x + this.width && mouseY >= listTop && mouseY < listTop + expandedHeight) {
            hoveredIndex = (mouseY - listTop) / itemHeight + this.scrollOffset;
        }
        for (int i = 0; i < visibleItems && (optIndex = i + this.scrollOffset) < totalItems; ++i) {
            int rowTop = listTop + i * itemHeight;
            boolean isHovered = optIndex == hoveredIndex;
            int rowColor = isHovered ? this.hoverColor : this.backgroundColor;
            graphics.method_25294(this.x + 1, rowTop, this.x + this.width - 1, rowTop + itemHeight, rowColor);
            String opt = this.options.get(optIndex);
            int rowTextY = rowTop + (itemHeight - 8) / 2;
            graphics.method_51433(this.minecraft.field_1772, opt, this.x + 4, rowTextY, this.textColor, false);
            class_1799 overlay = this.itemOverlays.get(optIndex);
            if (overlay == null) continue;
            graphics.method_51427(overlay, this.x + this.width - 20, rowTop + (itemHeight - 16) / 2);
        }
        graphics.method_44380();
        if (totalItems > visibleItems) {
            int barX = this.x + this.width - 3;
            int barTop = listTop + 2;
            int barBottom = listTop + expandedHeight - 2;
            graphics.method_25294(barX, barTop, barX + 2, barBottom, -13619152);
            int thumbHeight = Math.max(6, expandedHeight * visibleItems / totalItems);
            int thumbTop = barTop + this.scrollOffset * (expandedHeight - thumbHeight) / Math.max(1, totalItems - visibleItems);
            graphics.method_25294(barX, thumbTop, barX + 2, thumbTop + thumbHeight, -8355712);
        }
    }

    @Override
    public boolean hasOverlayActive() {
        return this.expanded && this.visible && this.enabled;
    }

    @Override
    public void closeOverlay() {
        this.expanded = false;
        this.scrollOffset = 0;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.visible || !this.enabled || button != 0) {
            return false;
        }
        if (!this.expanded) {
            if (this.isMouseOver(mouseX, mouseY)) {
                this.expanded = true;
                this.scrollOffset = 0;
                return true;
            }
            return false;
        }
        int itemHeight = this.height;
        int listTop = this.y + this.height;
        int spaceBelow = this.screen.field_22790 - (this.y + this.height) - 6;
        int maxVisible = Math.max(1, spaceBelow / itemHeight);
        int visibleItems = Math.min(this.options.size(), maxVisible);
        int expandedHeight = visibleItems * itemHeight;
        if (mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)listTop && mouseY < (double)(listTop + expandedHeight)) {
            int localRow = (int)((mouseY - (double)listTop) / (double)itemHeight);
            int index = this.scrollOffset + localRow;
            if (index >= 0 && index < this.options.size()) {
                this.setSelectedIndex(index);
            }
            this.expanded = false;
            return true;
        }
        this.expanded = false;
        return true;
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (!this.visible || !this.expanded) {
            return false;
        }
        int itemHeight = this.height;
        int spaceBelow = this.screen.field_22790 - (this.y + this.height) - 6;
        int maxVisible = Math.max(1, spaceBelow / itemHeight);
        int visibleItems = Math.min(this.options.size(), maxVisible);
        if (this.options.size() > visibleItems) {
            int maxOffset = Math.max(0, this.options.size() - visibleItems);
            this.scrollOffset = Math.max(0, Math.min(maxOffset, this.scrollOffset - (int)scrollY));
            return true;
        }
        return false;
    }
}

