/*
 * Decompiled with CFR 0.152.
 */
package net.jackson.simplegui.widget;

import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jackson.simplegui.widget.GuiWidget;
import net.minecraft.class_332;
import net.minecraft.class_3532;

@Environment(value=EnvType.CLIENT)
public class TextBoxWidget
extends GuiWidget {
    private String value = "";
    private String hint = "";
    private int maxLength = 32;
    private boolean focused = false;
    private int cursorPosition = 0;
    private int selectionStart = 0;
    private int selectionEnd = 0;
    private int displayOffset = 0;
    private long lastCursorToggle = 0L;
    private boolean cursorVisible = true;
    private final int backgroundColor;
    private final int borderColor;
    private final int textColor;
    private final int hintColor;
    private Consumer<String> onChanged;
    private boolean isPassword = false;

    public TextBoxWidget(String id, int x, int y, int width, int height) {
        this(id, x, y, width, height, -16777216, -6250336, -2039584, -9408400);
    }

    public TextBoxWidget(String id, int x, int y, int width, int height, int backgroundColor, int borderColor, int textColor, int hintColor) {
        super(id, x, y, width, height);
        this.backgroundColor = backgroundColor;
        this.borderColor = borderColor;
        this.textColor = textColor;
        this.hintColor = hintColor;
    }

    public void setHint(String hint) {
        this.hint = hint;
    }

    public void setValue(String value) {
        this.value = value.substring(0, Math.min(value.length(), this.maxLength));
        this.selectionStart = this.selectionEnd = (this.cursorPosition = class_3532.method_15340((int)this.cursorPosition, (int)0, (int)this.value.length()));
        if (this.onChanged != null) {
            this.onChanged.accept(this.value);
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
        if (this.value.length() > maxLength) {
            this.value = this.value.substring(0, maxLength);
            this.cursorPosition = Math.min(this.cursorPosition, this.value.length());
        }
    }

    public void setOnChanged(Consumer<String> onChanged) {
        this.onChanged = onChanged;
    }

    public void setPassword(boolean isPassword) {
        this.isPassword = isPassword;
    }

    public void setFocused(boolean focused) {
        this.focused = focused;
        if (!focused) {
            this.selectionStart = this.selectionEnd = this.cursorPosition;
        }
    }

    public boolean isFocused() {
        return this.focused;
    }

    @Override
    public void render(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        if (!this.visible) {
            return;
        }
        graphics.method_25294(this.x, this.y, this.x + this.width, this.y + this.height, this.backgroundColor);
        int border = this.focused ? -1 : this.borderColor;
        graphics.method_25294(this.x - 1, this.y - 1, this.x + this.width + 1, this.y, border);
        graphics.method_25294(this.x - 1, this.y + this.height, this.x + this.width + 1, this.y + this.height + 1, border);
        graphics.method_25294(this.x - 1, this.y, this.x, this.y + this.height, border);
        graphics.method_25294(this.x + this.width, this.y, this.x + this.width + 1, this.y + this.height, border);
        String displayText = this.isPassword ? "*".repeat(this.value.length()) : this.value;
        boolean showHint = this.value.isEmpty() && !this.focused && !this.hint.isEmpty();
        String renderText = showHint ? this.hint : displayText;
        int renderColor = showHint ? this.hintColor : this.textColor;
        int textY = this.y + (this.height - 8) / 2;
        int innerWidth = this.width - 8;
        if (!showHint && this.focused) {
            long currentTime;
            String beforeCursor = this.isPassword ? "*".repeat(this.cursorPosition) : this.value.substring(0, this.cursorPosition);
            int cursorX = this.minecraft.field_1772.method_1727(beforeCursor);
            if (cursorX - this.displayOffset < 0) {
                this.displayOffset = cursorX;
            } else if (cursorX - this.displayOffset > innerWidth) {
                this.displayOffset = cursorX - innerWidth;
            }
            if (this.selectionStart != this.selectionEnd) {
                int start = Math.min(this.selectionStart, this.selectionEnd);
                int end = Math.max(this.selectionStart, this.selectionEnd);
                String beforeSelection = this.isPassword ? "*".repeat(start) : this.value.substring(0, start);
                String selection = this.isPassword ? "*".repeat(end - start) : this.value.substring(start, end);
                int selStartX = this.x + 4 + this.minecraft.field_1772.method_1727(beforeSelection) - this.displayOffset;
                int selWidth = this.minecraft.field_1772.method_1727(selection);
                graphics.method_25294(selStartX, this.y + 2, selStartX + selWidth, this.y + this.height - 2, -16776961);
            }
            if ((currentTime = System.currentTimeMillis()) - this.lastCursorToggle > 500L) {
                this.cursorVisible = !this.cursorVisible;
                this.lastCursorToggle = currentTime;
            }
            if (this.cursorVisible) {
                int cursorDrawX = this.x + 4 + cursorX - this.displayOffset;
                graphics.method_25294(cursorDrawX, this.y + 2, cursorDrawX + 1, this.y + this.height - 2, -3092272);
            }
        }
        graphics.method_44379(this.x + 2, this.y + 1, this.x + this.width - 2, this.y + this.height - 1);
        graphics.method_51433(this.minecraft.field_1772, renderText, this.x + 4 - this.displayOffset, textY, renderColor, false);
        graphics.method_44380();
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.visible || !this.enabled) {
            return false;
        }
        boolean wasOver = this.isMouseOver(mouseX, mouseY);
        this.setFocused(wasOver);
        if (wasOver && button == 0) {
            int relativeX = (int)mouseX - this.x - 4 + this.displayOffset;
            int newCursor = 0;
            int currentWidth = 0;
            String displayText = this.isPassword ? "*".repeat(this.value.length()) : this.value;
            for (int i = 0; i <= displayText.length(); ++i) {
                if (i < displayText.length()) {
                    int charWidth = this.minecraft.field_1772.method_1727(String.valueOf(displayText.charAt(i)));
                    if (currentWidth + charWidth / 2 > relativeX) {
                        newCursor = i;
                        break;
                    }
                    currentWidth += charWidth;
                    continue;
                }
                newCursor = i;
            }
            this.selectionStart = this.selectionEnd = (this.cursorPosition = newCursor);
            return true;
        }
        return wasOver;
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        boolean ctrl;
        if (!this.focused || !this.enabled) {
            return false;
        }
        boolean shift = (modifiers & 1) != 0;
        boolean bl = ctrl = (modifiers & 2) != 0;
        if (ctrl) {
            switch (keyCode) {
                case 65: {
                    this.selectionStart = 0;
                    this.selectionEnd = this.value.length();
                    this.cursorPosition = this.value.length();
                    return true;
                }
                case 67: {
                    if (this.selectionStart != this.selectionEnd) {
                        int start = Math.min(this.selectionStart, this.selectionEnd);
                        int end = Math.max(this.selectionStart, this.selectionEnd);
                        this.minecraft.field_1774.method_1455(this.value.substring(start, end));
                    }
                    return true;
                }
                case 88: {
                    if (this.selectionStart != this.selectionEnd) {
                        int start = Math.min(this.selectionStart, this.selectionEnd);
                        int end = Math.max(this.selectionStart, this.selectionEnd);
                        this.minecraft.field_1774.method_1455(this.value.substring(start, end));
                        this.deleteSelection();
                    }
                    return true;
                }
                case 86: {
                    String clipboard = this.minecraft.field_1774.method_1460();
                    this.insertText(clipboard);
                    return true;
                }
            }
        }
        switch (keyCode) {
            case 263: {
                this.moveCursor(-1, shift);
                return true;
            }
            case 262: {
                this.moveCursor(1, shift);
                return true;
            }
            case 268: {
                this.cursorPosition = 0;
                if (!shift) {
                    this.selectionEnd = 0;
                    this.selectionStart = 0;
                } else {
                    this.selectionEnd = this.cursorPosition;
                }
                return true;
            }
            case 269: {
                this.cursorPosition = this.value.length();
                if (!shift) {
                    this.selectionStart = this.selectionEnd = this.value.length();
                } else {
                    this.selectionEnd = this.cursorPosition;
                }
                return true;
            }
            case 259: {
                if (this.selectionStart != this.selectionEnd) {
                    this.deleteSelection();
                } else if (this.cursorPosition > 0) {
                    this.value = this.value.substring(0, this.cursorPosition - 1) + this.value.substring(this.cursorPosition);
                    --this.cursorPosition;
                    this.selectionStart = this.selectionEnd = this.cursorPosition;
                    if (this.onChanged != null) {
                        this.onChanged.accept(this.value);
                    }
                }
                return true;
            }
            case 261: {
                if (this.selectionStart != this.selectionEnd) {
                    this.deleteSelection();
                } else if (this.cursorPosition < this.value.length()) {
                    this.value = this.value.substring(0, this.cursorPosition) + this.value.substring(this.cursorPosition + 1);
                    if (this.onChanged != null) {
                        this.onChanged.accept(this.value);
                    }
                }
                return true;
            }
            case 257: 
            case 335: {
                this.setFocused(false);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean charTyped(char codePoint, int modifiers) {
        if (!this.focused || !this.enabled) {
            return false;
        }
        if (codePoint >= ' ' && codePoint != '\u007f') {
            this.insertText(String.valueOf(codePoint));
            return true;
        }
        return false;
    }

    private void insertText(String text) {
        if (this.selectionStart != this.selectionEnd) {
            this.deleteSelection();
        }
        if (this.value.length() + text.length() <= this.maxLength) {
            this.value = this.value.substring(0, this.cursorPosition) + text + this.value.substring(this.cursorPosition);
            this.cursorPosition += text.length();
            this.selectionStart = this.selectionEnd = this.cursorPosition;
            if (this.onChanged != null) {
                this.onChanged.accept(this.value);
            }
        }
    }

    private void deleteSelection() {
        int start = Math.min(this.selectionStart, this.selectionEnd);
        int end = Math.max(this.selectionStart, this.selectionEnd);
        this.value = this.value.substring(0, start) + this.value.substring(end);
        this.cursorPosition = start;
        this.selectionStart = this.selectionEnd = start;
        if (this.onChanged != null) {
            this.onChanged.accept(this.value);
        }
    }

    private void moveCursor(int direction, boolean selecting) {
        this.cursorPosition = class_3532.method_15340((int)(this.cursorPosition + direction), (int)0, (int)this.value.length());
        if (selecting) {
            this.selectionEnd = this.cursorPosition;
        } else {
            this.selectionStart = this.selectionEnd = this.cursorPosition;
        }
    }
}

