/*
 * Decompiled with CFR 0.152.
 */
package me.eyman.PreventPotions;

import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.NotNull;

public class PreventPotions
extends JavaPlugin
implements Listener {
    private FileConfiguration config;

    public void onEnable() {
        this.saveDefaultConfig();
        this.config = this.getConfig();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("PreventPotions enabled!");
    }

    public void onDisable() {
        this.getLogger().info("PreventPotions disabled!");
    }

    private String msg(String path) {
        Map<String, String> defaults = Map.of("drink", "&cYou cannot drink potions on this server!", "splash", "&cSplash potions are disabled!", "lingering", "&cLingering potions are disabled!", "tipped_arrows", "&cTipped arrows are not allowed!", "beacon", "&cBeacon effects are disabled!", "commands", "&cPotion effects via commands are disabled!");
        String raw = this.config.getString("messages." + path, defaults.getOrDefault(path, "&cThat action is blocked!"));
        return raw.replace("&", "\u00a7");
    }

    @EventHandler
    public void onPotionDrink(PlayerItemConsumeEvent event) {
        ItemStack item = event.getItem();
        if (!(item.getItemMeta() instanceof PotionMeta)) {
            return;
        }
        if (this.config.getBoolean("prevent.drink")) {
            event.setCancelled(true);
            event.getPlayer().sendMessage(this.msg("drink"));
        }
    }

    @EventHandler
    public void onPotionThrow(ProjectileLaunchEvent event) {
        Player player;
        ProjectileSource projectileSource;
        String type = event.getEntity().getType().toString();
        if (type.equals("SPLASH_POTION") && this.config.getBoolean("prevent.splash")) {
            event.setCancelled(true);
            projectileSource = event.getEntity().getShooter();
            if (projectileSource instanceof Player) {
                player = (Player)projectileSource;
                player.sendMessage(this.msg("splash"));
            }
        }
        if (type.equals("LINGERING_POTION") && this.config.getBoolean("prevent.lingering")) {
            event.setCancelled(true);
            projectileSource = event.getEntity().getShooter();
            if (projectileSource instanceof Player) {
                player = (Player)projectileSource;
                player.sendMessage(this.msg("lingering"));
            }
        }
    }

    @EventHandler
    public void onArrowShoot(ProjectileLaunchEvent event) {
        if (event.getEntity().getType().toString().equals("ARROW") && this.config.getBoolean("prevent.tipped_arrows")) {
            event.setCancelled(true);
            ProjectileSource projectileSource = event.getEntity().getShooter();
            if (projectileSource instanceof Player) {
                Player player = (Player)projectileSource;
                player.sendMessage(this.msg("tipped_arrows"));
            }
        }
    }

    @EventHandler
    public void onPotionEffect(EntityPotionEffectEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        switch (event.getCause()) {
            case COMMAND: {
                if (!this.config.getBoolean("prevent.commands")) break;
                event.setCancelled(true);
                player.sendMessage(this.msg("commands"));
                break;
            }
            case BEACON: {
                if (!this.config.getBoolean("prevent.beacon")) break;
                event.setCancelled(true);
                player.sendMessage(this.msg("beacon"));
                break;
            }
        }
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, String label, String @NotNull [] args) {
        if (label.equalsIgnoreCase("preventpotions")) {
            if (args.length > 0 && args[0].equalsIgnoreCase("reload")) {
                this.reloadConfig();
                this.config = this.getConfig();
                sender.sendMessage("\u00a7aPreventPotions config reloaded!");
                return true;
            }
            sender.sendMessage("\u00a7cUsage: /preventpotions reload");
            return true;
        }
        return false;
    }
}

