/*
 * Decompiled with CFR 0.152.
 */
package me.eyman.PreventPotions;

import java.lang.reflect.Method;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.entity.VillagerAcquireTradeEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.NotNull;

public class PreventPotions
extends JavaPlugin
implements Listener {
    private FileConfiguration config;
    private boolean preventionEnabled = true;

    public void onEnable() {
        this.saveDefaultConfig();
        this.config = this.getConfig();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        try {
            Method getCommandMap = Bukkit.class.getMethod("getCommandMap", new Class[0]);
            CommandMap commandMap = (CommandMap)getCommandMap.invoke((Object)Bukkit.getServer(), new Object[0]);
            commandMap.register("preventpotions", (Command)new BukkitCommand("preventpotions"){

                public boolean execute(@NotNull CommandSender sender, @NotNull String label, String[] args) {
                    return PreventPotions.this.handlePreventPotionsCommand(sender, args);
                }
            });
            this.getLogger().info("Command /preventpotions registered via CommandMap (Paper mode).");
        }
        catch (Exception e) {
            this.getLogger().info("Command /preventpotions registered via plugin.yml (Bukkit/Spigot mode).");
        }
        this.getLogger().info("PreventPotions has been enabled.");
    }

    public void onDisable() {
        this.getLogger().info("PreventPotions disabled.");
    }

    private String msg(String path) {
        Map<String, String> defaults = Map.of("drink", "&cYou cannot drink potions on this server!", "splash", "&cSplash potions are disabled!", "lingering", "&cLingering potions are disabled!", "tipped_arrows", "&cTipped arrows are not allowed!", "beacon", "&cBeacon effects are disabled!", "commands", "&cPotion effects via commands are disabled!");
        String raw = this.config.getString("messages." + path, defaults.getOrDefault(path, "&cThat action is blocked!"));
        return raw.replace("&", "\u00a7");
    }

    @EventHandler
    public void onPotionDrink(PlayerItemConsumeEvent event) {
        if (!this.preventionEnabled) {
            return;
        }
        ItemStack item = event.getItem();
        if (!(item.getItemMeta() instanceof PotionMeta)) {
            return;
        }
        if (this.config.getBoolean("prevent.drink")) {
            event.setCancelled(true);
            event.getPlayer().sendMessage(this.msg("drink"));
        }
    }

    @EventHandler
    public void onPotionThrow(ProjectileLaunchEvent event) {
        Player player;
        ProjectileSource projectileSource;
        if (!this.preventionEnabled) {
            return;
        }
        Projectile projectile = event.getEntity();
        if (!(projectile instanceof ThrownPotion)) {
            return;
        }
        ThrownPotion potion = (ThrownPotion)projectile;
        ItemStack item = potion.getItem();
        if (item.getType() == Material.SPLASH_POTION && this.config.getBoolean("prevent.splash")) {
            event.setCancelled(true);
            projectileSource = potion.getShooter();
            if (projectileSource instanceof Player) {
                player = (Player)projectileSource;
                player.sendMessage(this.msg("splash"));
            }
        }
        if (item.getType() == Material.LINGERING_POTION && this.config.getBoolean("prevent.lingering")) {
            event.setCancelled(true);
            projectileSource = potion.getShooter();
            if (projectileSource instanceof Player) {
                player = (Player)projectileSource;
                player.sendMessage(this.msg("lingering"));
            }
        }
    }

    @EventHandler
    public void onArrowShoot(ProjectileLaunchEvent event) {
        Player player;
        ItemStack inHand;
        if (!this.preventionEnabled) {
            return;
        }
        Projectile projectile = event.getEntity();
        if (!(projectile instanceof Arrow)) {
            return;
        }
        Arrow arrow = (Arrow)projectile;
        ProjectileSource projectileSource = arrow.getShooter();
        if (projectileSource instanceof Player && (inHand = (player = (Player)projectileSource).getInventory().getItemInMainHand()).getType() == Material.TIPPED_ARROW && this.config.getBoolean("prevent.tipped_arrows")) {
            event.setCancelled(true);
            player.sendMessage(this.msg("tipped_arrows"));
        }
    }

    @EventHandler
    public void onCraft(PrepareItemCraftEvent event) {
        if (!this.preventionEnabled) {
            return;
        }
        if (!this.config.getBoolean("prevent.tipped_arrows")) {
            return;
        }
        if (event.getRecipe() != null && event.getRecipe().getResult().getType() == Material.TIPPED_ARROW) {
            event.getInventory().setResult(new ItemStack(Material.AIR));
        }
    }

    @EventHandler
    public void onVillagerTrade(VillagerAcquireTradeEvent event) {
        if (!this.preventionEnabled) {
            return;
        }
        if (!this.config.getBoolean("prevent.tipped_arrows")) {
            return;
        }
        if (event.getRecipe().getResult().getType() == Material.TIPPED_ARROW) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPickup(EntityPickupItemEvent event) {
        if (!this.preventionEnabled) {
            return;
        }
        if (!this.config.getBoolean("prevent.tipped_arrows")) {
            return;
        }
        if (event.getItem().getItemStack().getType() == Material.TIPPED_ARROW) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!this.preventionEnabled) {
            return;
        }
        if (!this.config.getBoolean("prevent.tipped_arrows")) {
            return;
        }
        ItemStack current = event.getCurrentItem();
        if (current != null && current.getType() == Material.TIPPED_ARROW) {
            event.setCancelled(true);
            event.setCurrentItem(new ItemStack(Material.AIR));
            HumanEntity humanEntity = event.getWhoClicked();
            if (humanEntity instanceof Player) {
                Player player = (Player)humanEntity;
                player.sendMessage(this.msg("tipped_arrows"));
            }
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        if (!this.preventionEnabled) {
            return;
        }
        if (!this.config.getBoolean("prevent.tipped_arrows")) {
            return;
        }
        Player player = event.getPlayer();
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || item.getType() != Material.TIPPED_ARROW) continue;
            player.getInventory().remove(item);
            player.sendMessage(this.msg("tipped_arrows"));
        }
    }

    @EventHandler
    public void onPotionEffect(EntityPotionEffectEvent event) {
        if (!this.preventionEnabled) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        switch (event.getCause()) {
            case COMMAND: {
                if (!this.config.getBoolean("prevent.commands")) break;
                event.setCancelled(true);
                player.sendMessage(this.msg("commands"));
                break;
            }
            case BEACON: {
                if (!this.config.getBoolean("prevent.beacon")) break;
                event.setCancelled(true);
                player.sendMessage(this.msg("beacon"));
                break;
            }
        }
    }

    private boolean handlePreventPotionsCommand(CommandSender sender, String[] args) {
        if (args.length > 0) {
            if (args[0].equalsIgnoreCase("reload")) {
                this.reloadConfig();
                this.config = this.getConfig();
                sender.sendMessage("\u00a7aPreventPotions config reloaded!");
                return true;
            }
            if (args[0].equalsIgnoreCase("toggle")) {
                this.preventionEnabled = !this.preventionEnabled;
                sender.sendMessage(this.preventionEnabled ? "\u00a7aPotion prevention enabled!" : "\u00a7cPotion prevention disabled!");
                return true;
            }
        }
        sender.sendMessage("\u00a7cUsage: /preventpotions <reload|toggle>");
        return true;
    }

    public boolean onCommand(@NotNull CommandSender sender, Command command, @NotNull String label, @NotNull String[] args) {
        return this.handlePreventPotionsCommand(sender, args);
    }
}

