/*
 * Decompiled with CFR 0.152.
 */
package net.saveloy_master.nafes_end_update.world.entity.monster;

import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.saveloy_master.nafes_end_update.Config;
import net.saveloy_master.nafes_end_update.world.effect.ModMobEffects;

public class EnderManAttackMitingPlayerGoal
extends MeleeAttackGoal {
    private final EnderMan enderman;
    private LivingEntity mitingTarget;

    public EnderManAttackMitingPlayerGoal(EnderMan enderman) {
        super((PathfinderMob)enderman, 1.0, true);
        this.enderman = enderman;
    }

    private boolean isLookingAtEntity(LivingEntity viewer, LivingEntity target) {
        if (target == null) {
            return false;
        }
        Vec3 startVec = viewer.getEyePosition();
        Vec3 endVec = target.getEyePosition();
        ClipContext clipContext = new ClipContext(startVec, endVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)viewer);
        BlockHitResult hitResult = viewer.level().clip(clipContext);
        return hitResult.getType() == HitResult.Type.MISS;
    }

    public boolean canUse() {
        LivingEntity currentSuperTarget;
        if (super.canUse() && (currentSuperTarget = this.mob.getTarget()) != null && currentSuperTarget.hasEffect((Holder)ModMobEffects.MITING.getHolder().orElseThrow())) {
            this.mitingTarget = currentSuperTarget;
            return true;
        }
        double endermanAttackRadius = Config.endermanAttackMitingPlayerRange;
        double endermanAttackRangeMultiplier = Config.endermanAttackMitingPlayerRangeMultipier;
        switch (this.enderman.level().getDifficulty()) {
            case NORMAL: {
                endermanAttackRadius *= endermanAttackRangeMultiplier;
                break;
            }
            case HARD: {
                endermanAttackRadius = endermanAttackRadius * endermanAttackRangeMultiplier * endermanAttackRangeMultiplier;
            }
        }
        Player nearestPlayer = this.enderman.level().getNearestPlayer((Entity)this.enderman, endermanAttackRadius);
        if (nearestPlayer != null && nearestPlayer.hasEffect((Holder)ModMobEffects.MITING.getHolder().orElseThrow()) && nearestPlayer.isAlive() && !nearestPlayer.isCreative() && !nearestPlayer.isSpectator()) {
            this.mitingTarget = nearestPlayer;
            this.mob.setTarget(this.mitingTarget);
            return this.isLookingAtEntity((LivingEntity)this.enderman, this.mitingTarget);
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.mitingTarget != null && this.mitingTarget.isAlive() && this.mitingTarget.hasEffect((Holder)ModMobEffects.MITING.getHolder().orElseThrow()) && this.isLookingAtEntity((LivingEntity)this.enderman, this.mitingTarget) && !this.mitingTarget.isSpectator() && super.canContinueToUse();
    }

    public void start() {
        this.mob.setTarget(this.mitingTarget);
        super.start();
    }

    public void tick() {
        super.tick();
    }

    public void stop() {
        if (this.mob.getTarget() == this.mitingTarget) {
            this.mob.setTarget(null);
        }
        this.mitingTarget = null;
        super.stop();
    }
}

