/*
 * Decompiled with CFR 0.152.
 */
package net.saveloy_master.nafes_end_update.world.item;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.saveloy_master.nafes_end_update.world.item.ModDataComponents;
import net.saveloy_master.nafes_end_update.world.level.block.ModBlocks;

public class TeleporterItem
extends Item {
    private final boolean isCrossDimensional;
    private final String blockPosX = "block_pos_x";
    private final String blockPosY = "block_pos_y";
    private final String blockPosZ = "block_pos_z";
    private final String teleportPosX = "teleport_pos_x";
    private final String teleportPosY = "teleport_pos_y";
    private final String teleportPosZ = "teleport_pos_z";
    private final String dimensionID = "dimension_id";

    public TeleporterItem(Item.Properties pProperties, boolean isCrossDimensional) {
        super(pProperties);
        this.isCrossDimensional = isCrossDimensional;
    }

    public InteractionResult useOn(UseOnContext pContext) {
        ItemStack stack = pContext.getItemInHand();
        CompoundTag NBTData = (CompoundTag)stack.getOrDefault((DataComponentType)ModDataComponents.TELEPORTER_ITEM_COMPOUND_TAG.get(), (Object)new CompoundTag());
        if (pContext.getLevel().isClientSide) {
            return InteractionResult.PASS;
        }
        Optional blockX = NBTData.getInt("block_pos_x");
        Optional blockY = NBTData.getInt("block_pos_y");
        Optional blockZ = NBTData.getInt("block_pos_z");
        if (blockX.isPresent() && blockY.isPresent() && blockZ.isPresent() && pContext.getLevel().getBlockState(new BlockPos(((Integer)blockX.get()).intValue(), ((Integer)blockY.get()).intValue(), ((Integer)blockZ.get()).intValue())).is((Block)ModBlocks.TELEPORTING_ANCHOR.get())) {
            return this.use(pContext.getLevel(), Objects.requireNonNull(pContext.getPlayer()), pContext.getHand());
        }
        BlockPos teleportPos = Objects.requireNonNull(pContext.getPlayer()).getOnPos();
        BlockState clickedBlock = pContext.getLevel().getBlockState(pContext.getClickedPos());
        if (clickedBlock.is((Block)ModBlocks.TELEPORTING_ANCHOR.get())) {
            CompoundTag tag = CompoundTag.builder().putInt("block_pos_x", pContext.getClickedPos().getX()).putInt("block_pos_y", pContext.getClickedPos().getY()).putInt("block_pos_z", pContext.getClickedPos().getZ()).putInt("teleport_pos_x", teleportPos.getX()).putInt("teleport_pos_y", teleportPos.getY()).putInt("teleport_pos_z", teleportPos.getZ()).put("dimension_id", String.valueOf(pContext.getLevel().dimension())).build();
            stack.set((DataComponentType)ModDataComponents.TELEPORTER_ITEM_COMPOUND_TAG.get(), (Object)tag);
            stack.set(DataComponents.BASE_COLOR, (Object)DyeColor.byId((int)Arrays.stream(DyeColor.values()).toList().get(new Random().nextInt(DyeColor.values().length)).getId()));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public InteractionResult use(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack stack = pPlayer.getItemInHand(pHand);
        if (pLevel.isClientSide) {
            return InteractionResult.PASS;
        }
        CompoundTag NBTData = (CompoundTag)stack.getOrDefault((DataComponentType)ModDataComponents.TELEPORTER_ITEM_COMPOUND_TAG.get(), (Object)new CompoundTag());
        Optional blockX = NBTData.getInt("block_pos_x");
        Optional blockY = NBTData.getInt("block_pos_y");
        Optional blockZ = NBTData.getInt("block_pos_z");
        if (blockX.isPresent() && blockY.isPresent() && blockZ.isPresent() && pLevel.getBlockState(new BlockPos(((Integer)blockX.get()).intValue(), ((Integer)blockY.get()).intValue(), ((Integer)blockZ.get()).intValue())).is((Block)ModBlocks.TELEPORTING_ANCHOR.get())) {
            Optional x = NBTData.getInt("teleport_pos_x");
            Optional y = NBTData.getInt("teleport_pos_y");
            Optional z = NBTData.getInt("teleport_pos_z");
            if (!(x.isPresent() && y.isPresent() && z.isPresent())) {
                return InteractionResult.PASS;
            }
            if (this.isCrossDimensional) {
                Optional dimensionID = NBTData.getString(this.dimensionID);
                ResourceKey targetDimensionKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)dimensionID.orElse("0")));
                if (pPlayer.level().dimension().equals((Object)targetDimensionKey)) {
                    pPlayer.teleportTo((double)((Integer)x.get()).intValue() + 0.5, (double)((Integer)y.get()).intValue() + 1.0, (double)((Integer)z.get()).intValue() + 0.5);
                    return InteractionResult.SUCCESS;
                }
                pPlayer.teleportTo(Objects.requireNonNull(Objects.requireNonNull(pLevel.getServer()).getLevel(targetDimensionKey)), (double)((Integer)x.get()).intValue() + 0.5, (double)((Integer)y.get()).intValue() + 1.0, (double)((Integer)z.get()).intValue() + 0.5, Set.of(), 0.0f, 0.0f, false);
                this.sendPortalParticles(pLevel, pPlayer.getOnPos());
                return InteractionResult.SUCCESS;
            }
            pPlayer.teleportTo((double)((Integer)x.get()).intValue() + 0.5, (double)((Integer)y.get()).intValue() + 1.0, (double)((Integer)z.get()).intValue() + 0.5);
            this.sendPortalParticles(pLevel, pPlayer.getOnPos());
            return InteractionResult.SUCCESS;
        }
        ((ServerPlayer)pPlayer).connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"system_message.nafes_end_update.teleporting_anchor_not_found_msg")));
        return InteractionResult.PASS;
    }

    private void sendPortalParticles(Level level, BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            double x = (double)pos.getX() + 0.5;
            double y = pos.getX() + 1;
            double z = (double)pos.getX() + 0.5;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.PORTAL, x, y, z, 20, 0.0, 0.0, 0.0, 1.0);
        }
    }
}

