/*
 * Decompiled with CFR 0.152.
 */
package net.saveloy_master.nafes_end_update.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChorusFlowerBlock;
import net.minecraft.world.level.block.ChorusPlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.saveloy_master.nafes_end_update.world.level.block.ModBlocks;

public class VerdantChorusPlantFeature
extends Feature<NoneFeatureConfiguration> {
    public VerdantChorusPlantFeature(Codec<NoneFeatureConfiguration> pCodec) {
        super(pCodec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> pContext) {
        WorldGenLevel worldGenLevel = pContext.level();
        BlockPos blockPos = pContext.origin();
        RandomSource randomSource = pContext.random();
        if (worldGenLevel.isEmptyBlock(blockPos.above()) && worldGenLevel.getBlockState(blockPos.below()).is(Blocks.END_STONE)) {
            VerdantChorusPlantFeature.generatePlant((LevelAccessor)worldGenLevel, blockPos, randomSource, 8);
            return true;
        }
        return false;
    }

    public static void generatePlant(LevelAccessor pLevel, BlockPos pPos, RandomSource pRandomSource, int pInt) {
        pLevel.setBlock(pPos, ChorusPlantBlock.getStateWithConnections((BlockGetter)pLevel, (BlockPos)pPos, (BlockState)((ChorusFlowerBlock)ModBlocks.VERDANT_CHORUS_FLOWER.get()).defaultBlockState()), 2);
        VerdantChorusPlantFeature.growTreeRecursive(pLevel, pPos, pRandomSource, pPos, pInt, 0);
    }

    private static void growTreeRecursive(LevelAccessor pLevel, BlockPos pPos, RandomSource pRandomSource, BlockPos pNeighbourPos, int pInt, int p_220973_) {
        Block block = (Block)ModBlocks.VERDANT_CHORUS_PLANT.get();
        int i = pRandomSource.nextInt(4) + 1;
        if (p_220973_ == 0) {
            ++i;
        }
        for (int j = 0; j < i; ++j) {
            BlockPos blockpos = pPos.above(j + 1);
            if (!VerdantChorusPlantFeature.allNeighborsEmpty((LevelReader)pLevel, blockpos, null)) {
                return;
            }
            pLevel.setBlock(blockpos, ChorusPlantBlock.getStateWithConnections((BlockGetter)pLevel, (BlockPos)blockpos, (BlockState)block.defaultBlockState()), 2);
            pLevel.setBlock(blockpos.below(), ChorusPlantBlock.getStateWithConnections((BlockGetter)pLevel, (BlockPos)blockpos.below(), (BlockState)block.defaultBlockState()), 2);
        }
        boolean flag = false;
        if (p_220973_ < 4) {
            int l = pRandomSource.nextInt(4);
            if (p_220973_ == 0) {
                ++l;
            }
            for (int k = 0; k < l; ++k) {
                Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(pRandomSource);
                BlockPos blockpos1 = pPos.above(i).relative(direction);
                if (Math.abs(blockpos1.getX() - pPos.getX()) >= pInt || Math.abs(blockpos1.getZ() - pPos.getZ()) >= pInt || !pLevel.isEmptyBlock(blockpos1) || !pLevel.isEmptyBlock(blockpos1.below()) || !VerdantChorusPlantFeature.allNeighborsEmpty((LevelReader)pLevel, blockpos1, direction.getOpposite())) continue;
                flag = true;
                pLevel.setBlock(blockpos1, ChorusPlantBlock.getStateWithConnections((BlockGetter)pLevel, (BlockPos)blockpos1, (BlockState)block.defaultBlockState()), 2);
                pLevel.setBlock(blockpos1.relative(direction.getOpposite()), ChorusPlantBlock.getStateWithConnections((BlockGetter)pLevel, (BlockPos)blockpos1.relative(direction.getOpposite()), (BlockState)block.defaultBlockState()), 2);
                VerdantChorusPlantFeature.growTreeRecursive(pLevel, blockpos1, pRandomSource, pPos, pInt, p_220973_ + 1);
            }
        }
        if (!flag) {
            pLevel.setBlock(pPos.above(i), (BlockState)((ChorusFlowerBlock)ModBlocks.VERDANT_CHORUS_FLOWER.get()).defaultBlockState().setValue((Property)ChorusFlowerBlock.AGE, (Comparable)Integer.valueOf(5)), 2);
        }
    }

    private static boolean allNeighborsEmpty(LevelReader p_51698_, BlockPos p_51699_, @Nullable Direction p_51700_) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (direction == p_51700_ || p_51698_.isEmptyBlock(p_51699_.relative(direction))) continue;
            return false;
        }
        return true;
    }
}

