/*
 * Decompiled with CFR 0.152.
 */
package astrazoey.lenientstacksize;

import astrazoey.lenientstacksize.LenientStackSize;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;

public class StackSizeConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("lenient-stack-size.json");
    private Map<String, Integer> itemStackSizes = new HashMap<String, Integer>();

    public static StackSizeConfig load() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                String json = Files.readString(CONFIG_PATH);
                return (StackSizeConfig)GSON.fromJson(json, StackSizeConfig.class);
            }
            catch (IOException e) {
                LenientStackSize.LOGGER.error("Failed to load config, using defaults", (Throwable)e);
                return StackSizeConfig.createDefault();
            }
        }
        return StackSizeConfig.createDefault();
    }

    private static StackSizeConfig createDefault() {
        StackSizeConfig config = new StackSizeConfig();
        config.itemStackSizes.put("minecraft:ender_pearl", 64);
        config.itemStackSizes.put("minecraft:snowball", 64);
        config.itemStackSizes.put("minecraft:honey_bottle", 16);
        config.itemStackSizes.put("minecraft:armor_stand", 64);
        config.itemStackSizes.put("minecraft:cake", 64);
        config.itemStackSizes.put("minecraft:egg", 64);
        config.itemStackSizes.put("minecraft:brown_egg", 64);
        config.itemStackSizes.put("minecraft:blue_egg", 64);
        config.itemStackSizes.put("minecraft:minecart", 64);
        config.itemStackSizes.put("minecraft:furnace_minecart", 16);
        config.itemStackSizes.put("minecraft:chest_minecart", 16);
        config.itemStackSizes.put("minecraft:tnt_minecart", 16);
        config.itemStackSizes.put("minecraft:hopper_minecart", 16);
        config.itemStackSizes.put("minecraft:bucket", 64);
        config.itemStackSizes.put("minecraft:water_bucket", 16);
        config.itemStackSizes.put("minecraft:lava_bucket", 16);
        config.itemStackSizes.put("minecraft:milk_bucket", 16);
        config.itemStackSizes.put("minecraft:powder_snow_bucket", 16);
        config.itemStackSizes.put("minecraft:potion", 16);
        config.itemStackSizes.put("minecraft:splash_potion", 1);
        config.itemStackSizes.put("minecraft:lingering_potion", 1);
        config.itemStackSizes.put("minecraft:white_bed", 64);
        config.itemStackSizes.put("minecraft:orange_bed", 64);
        config.itemStackSizes.put("minecraft:magenta_bed", 64);
        config.itemStackSizes.put("minecraft:light_blue_bed", 64);
        config.itemStackSizes.put("minecraft:yellow_bed", 64);
        config.itemStackSizes.put("minecraft:lime_bed", 64);
        config.itemStackSizes.put("minecraft:pink_bed", 64);
        config.itemStackSizes.put("minecraft:gray_bed", 64);
        config.itemStackSizes.put("minecraft:light_gray_bed", 64);
        config.itemStackSizes.put("minecraft:cyan_bed", 64);
        config.itemStackSizes.put("minecraft:purple_bed", 64);
        config.itemStackSizes.put("minecraft:blue_bed", 64);
        config.itemStackSizes.put("minecraft:brown_bed", 64);
        config.itemStackSizes.put("minecraft:green_bed", 64);
        config.itemStackSizes.put("minecraft:red_bed", 64);
        config.itemStackSizes.put("minecraft:black_bed", 64);
        config.itemStackSizes.put("minecraft:oak_sign", 64);
        config.itemStackSizes.put("minecraft:spruce_sign", 64);
        config.itemStackSizes.put("minecraft:birch_sign", 64);
        config.itemStackSizes.put("minecraft:jungle_sign", 64);
        config.itemStackSizes.put("minecraft:acacia_sign", 64);
        config.itemStackSizes.put("minecraft:dark_oak_sign", 64);
        config.itemStackSizes.put("minecraft:mangrove_sign", 64);
        config.itemStackSizes.put("minecraft:cherry_sign", 64);
        config.itemStackSizes.put("minecraft:bamboo_sign", 64);
        config.itemStackSizes.put("minecraft:crimson_sign", 64);
        config.itemStackSizes.put("minecraft:warped_sign", 64);
        config.itemStackSizes.put("minecraft:pale_oak_sign", 64);
        config.itemStackSizes.put("minecraft:oak_hanging_sign", 64);
        config.itemStackSizes.put("minecraft:spruce_hanging_sign", 64);
        config.itemStackSizes.put("minecraft:birch_hanging_sign", 64);
        config.itemStackSizes.put("minecraft:jungle_hanging_sign", 64);
        config.itemStackSizes.put("minecraft:acacia_hanging_sign", 64);
        config.itemStackSizes.put("minecraft:dark_oak_hanging_sign", 64);
        config.itemStackSizes.put("minecraft:mangrove_hanging_sign", 64);
        config.itemStackSizes.put("minecraft:cherry_hanging_sign", 64);
        config.itemStackSizes.put("minecraft:bamboo_hanging_sign", 64);
        config.itemStackSizes.put("minecraft:crimson_hanging_sign", 64);
        config.itemStackSizes.put("minecraft:warped_hanging_sign", 64);
        config.itemStackSizes.put("minecraft:pale_oak_hanging_sign", 64);
        config.itemStackSizes.put("minecraft:oak_boat", 64);
        config.itemStackSizes.put("minecraft:spruce_boat", 64);
        config.itemStackSizes.put("minecraft:birch_boat", 64);
        config.itemStackSizes.put("minecraft:jungle_boat", 64);
        config.itemStackSizes.put("minecraft:acacia_boat", 64);
        config.itemStackSizes.put("minecraft:dark_oak_boat", 64);
        config.itemStackSizes.put("minecraft:mangrove_boat", 64);
        config.itemStackSizes.put("minecraft:cherry_boat", 64);
        config.itemStackSizes.put("minecraft:pale_oak_boat", 64);
        config.itemStackSizes.put("minecraft:bamboo_raft", 64);
        config.itemStackSizes.put("minecraft:oak_chest_boat", 64);
        config.itemStackSizes.put("minecraft:spruce_chest_boat", 64);
        config.itemStackSizes.put("minecraft:birch_chest_boat", 64);
        config.itemStackSizes.put("minecraft:jungle_chest_boat", 64);
        config.itemStackSizes.put("minecraft:acacia_chest_boat", 64);
        config.itemStackSizes.put("minecraft:dark_oak_chest_boat", 64);
        config.itemStackSizes.put("minecraft:mangrove_chest_boat", 64);
        config.itemStackSizes.put("minecraft:cherry_chest_boat", 64);
        config.itemStackSizes.put("minecraft:pale_oak_chest_boat", 64);
        config.itemStackSizes.put("minecraft:bamboo_chest_raft", 64);
        config.itemStackSizes.put("minecraft:mushroom_stew", 16);
        config.itemStackSizes.put("minecraft:rabbit_stew", 16);
        config.itemStackSizes.put("minecraft:beetroot_soup", 16);
        config.itemStackSizes.put("minecraft:suspicious_stew", 16);
        config.itemStackSizes.put("minecraft:music_disc_13", 64);
        config.itemStackSizes.put("minecraft:music_disc_cat", 64);
        config.itemStackSizes.put("minecraft:music_disc_blocks", 64);
        config.itemStackSizes.put("minecraft:music_disc_chirp", 64);
        config.itemStackSizes.put("minecraft:music_disc_far", 64);
        config.itemStackSizes.put("minecraft:music_disc_mall", 64);
        config.itemStackSizes.put("minecraft:music_disc_mellohi", 64);
        config.itemStackSizes.put("minecraft:music_disc_stal", 64);
        config.itemStackSizes.put("minecraft:music_disc_strad", 64);
        config.itemStackSizes.put("minecraft:music_disc_ward", 64);
        config.itemStackSizes.put("minecraft:music_disc_11", 64);
        config.itemStackSizes.put("minecraft:music_disc_wait", 64);
        config.itemStackSizes.put("minecraft:music_disc_otherside", 64);
        config.itemStackSizes.put("minecraft:music_disc_5", 64);
        config.itemStackSizes.put("minecraft:music_disc_pigstep", 64);
        config.itemStackSizes.put("minecraft:music_disc_relic", 64);
        config.itemStackSizes.put("minecraft:music_disc_creator", 64);
        config.itemStackSizes.put("minecraft:music_disc_creator_music_box", 64);
        config.itemStackSizes.put("minecraft:music_disc_precipice", 64);
        config.itemStackSizes.put("minecraft:music_disc_lava_chicken", 64);
        config.itemStackSizes.put("minecraft:music_disc_tears", 64);
        config.itemStackSizes.put("minecraft:white_banner", 64);
        config.itemStackSizes.put("minecraft:orange_banner", 64);
        config.itemStackSizes.put("minecraft:magenta_banner", 64);
        config.itemStackSizes.put("minecraft:light_blue_banner", 64);
        config.itemStackSizes.put("minecraft:yellow_banner", 64);
        config.itemStackSizes.put("minecraft:lime_banner", 64);
        config.itemStackSizes.put("minecraft:pink_banner", 64);
        config.itemStackSizes.put("minecraft:gray_banner", 64);
        config.itemStackSizes.put("minecraft:light_gray_banner", 64);
        config.itemStackSizes.put("minecraft:cyan_banner", 64);
        config.itemStackSizes.put("minecraft:purple_banner", 64);
        config.itemStackSizes.put("minecraft:blue_banner", 64);
        config.itemStackSizes.put("minecraft:brown_banner", 64);
        config.itemStackSizes.put("minecraft:green_banner", 64);
        config.itemStackSizes.put("minecraft:red_banner", 64);
        config.itemStackSizes.put("minecraft:black_banner", 64);
        config.save();
        return config;
    }

    public void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            Files.writeString(CONFIG_PATH, (CharSequence)GSON.toJson((Object)this), new OpenOption[0]);
            LenientStackSize.LOGGER.info("Config saved to {}", (Object)CONFIG_PATH);
        }
        catch (IOException e) {
            LenientStackSize.LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    public Integer getStackSize(String itemId) {
        return this.itemStackSizes.get(itemId);
    }

    public Map<String, Integer> getItemStackSizes() {
        return this.itemStackSizes;
    }
}

