/*
 * Decompiled with CFR 0.152.
 */
package me.stokmenn.clickthrough.listeners;

import me.stokmenn.clickthrough.config.Config;
import org.bukkit.Material;
import org.bukkit.Rotation;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ClickThroughItemFrameListener
implements Listener {
    private final JavaPlugin plugin;

    public ClickThroughItemFrameListener(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onClick(PlayerInteractAtEntityEvent event) {
        Entity entity = event.getRightClicked();
        if (!(entity instanceof ItemFrame)) {
            return;
        }
        ItemFrame itemFrame = (ItemFrame)entity;
        if (Config.requiredItemInFrame && itemFrame.getItem().getType() == Material.AIR) {
            return;
        }
        Player player = event.getPlayer();
        if (Config.itemFrameIgnoreWhenPlayerSneaking && player.isSneaking()) {
            return;
        }
        Block block = player.getTargetBlockExact(6);
        if (block == null) {
            return;
        }
        BlockState blockState = block.getState();
        if (blockState instanceof Container) {
            Container container = (Container)blockState;
            player.openInventory(container.getInventory());
        } else if (block.getType() == Material.ENDER_CHEST) {
            player.openInventory(player.getEnderChest());
        } else {
            return;
        }
        Rotation rotation = itemFrame.getRotation();
        event.setCancelled(true);
        itemFrame.getScheduler().run((Plugin)this.plugin, task -> itemFrame.setRotation(rotation), null);
    }
}

