/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.waterbucketmlg.item;

import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.function.Consumer;
import net.mcreator.waterbucketmlg.init.EasyMlgModItems;
import net.mcreator.waterbucketmlg.procedures.FeatherBootsProcedure;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.EquipmentAssets;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public abstract class FeatherArmourItem
extends Item {
    public static ArmorMaterial ARMOR_MATERIAL = new ArmorMaterial(12, Map.of(ArmorType.BOOTS, 2, ArmorType.LEGGINGS, 5, ArmorType.CHESTPLATE, 6, ArmorType.HELMET, 1, ArmorType.BODY, 6), 4, (Holder)DeferredHolder.create((ResourceKey)Registries.SOUND_EVENT, (ResourceLocation)ResourceLocation.parse((String)"item.armor.equip_chain")), 0.1f, 0.0f, TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)"easy_mlg:feather_armour_repair_items")), ResourceKey.create((ResourceKey)EquipmentAssets.ROOT_ID, (ResourceLocation)ResourceLocation.parse((String)"easy_mlg:feather_armour")));

    @SubscribeEvent
    public static void registerItemExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(new IClientItemExtensions(){

            public ResourceLocation getArmorTexture(ItemStack stack, EquipmentClientInfo.LayerType type, EquipmentClientInfo.Layer layer, ResourceLocation _default) {
                return ResourceLocation.parse((String)"easy_mlg:textures/models/armor/featherlike_layer_1.png");
            }
        }, new Item[]{(Item)EasyMlgModItems.FEATHER_ARMOUR_BOOTS.get()});
    }

    private FeatherArmourItem(Item.Properties properties) {
        super(properties);
    }

    public static class Boots
    extends FeatherArmourItem {
        public Boots(Item.Properties properties) {
            super(properties.humanoidArmor(ARMOR_MATERIAL, ArmorType.BOOTS));
        }

        @OnlyIn(value=Dist.CLIENT)
        public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> list, TooltipFlag flag) {
            super.appendHoverText(itemstack, context, display, list, flag);
            list.accept((Component)Component.translatable((String)"item.easy_mlg.feather_armour_boots.description_0"));
        }

        public void inventoryTick(ItemStack itemstack, ServerLevel world, Entity entity, EquipmentSlot slot) {
            Player player;
            super.inventoryTick(itemstack, world, entity, slot);
            if (entity instanceof Player && !Iterables.contains((Iterable)(player = (Player)entity).getInventory().getNonEquipmentItems(), (Object)itemstack)) {
                FeatherBootsProcedure.execute(entity);
            }
        }
    }
}

