/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.infrastructure.fluids.BucketFluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidItemInventory;
import com.zurrtum.create.infrastructure.fluids.FluidItemInventoryWrapper;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class AllFluidItemInventory {
    public static Map<Item, Entry> ALL = new Reference2ObjectArrayMap();

    public static boolean has(ItemStack stack) {
        return ALL.containsKey(stack.getItem());
    }

    public static FluidItemInventory of(ItemStack stack) {
        Entry entry = ALL.get(stack.getItem());
        if (entry == null) {
            return null;
        }
        return entry.of(stack);
    }

    private static void register(Item type, Supplier<FluidItemInventoryWrapper> factory) {
        ALL.put(type, new Entry(factory));
    }

    public static void register() {
        AllFluidItemInventory.register(Items.BUCKET, BucketFluidInventory::new);
        AllFluidItemInventory.register(Items.WATER_BUCKET, BucketFluidInventory::new);
        AllFluidItemInventory.register(Items.LAVA_BUCKET, BucketFluidInventory::new);
        AllFluidItemInventory.register(Items.MILK_BUCKET, BucketFluidInventory::new);
        AllFluidItemInventory.register((Item)AllItems.HONEY_BUCKET, BucketFluidInventory::new);
        AllFluidItemInventory.register((Item)AllItems.CHOCOLATE_BUCKET, BucketFluidInventory::new);
    }

    public static class Entry {
        private final Supplier<FluidItemInventoryWrapper> factory;
        private final Deque<FluidItemInventoryWrapper> pool = new ArrayDeque<FluidItemInventoryWrapper>();

        public Entry(Supplier<FluidItemInventoryWrapper> factory) {
            this.factory = factory;
        }

        public FluidItemInventory of(ItemStack stack) {
            FluidItemInventoryWrapper inventory = this.pool.pollFirst();
            if (inventory == null) {
                inventory = this.factory.get();
                inventory.release = this.pool::addLast;
            }
            inventory.stack = stack;
            return inventory;
        }
    }
}

