/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create;

import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.content.trains.schedule.condition.FluidThresholdCondition;
import com.zurrtum.create.content.trains.schedule.condition.IdleCargoCondition;
import com.zurrtum.create.content.trains.schedule.condition.ItemThresholdCondition;
import com.zurrtum.create.content.trains.schedule.condition.PlayerPassengerCondition;
import com.zurrtum.create.content.trains.schedule.condition.RedstoneLinkCondition;
import com.zurrtum.create.content.trains.schedule.condition.ScheduleWaitCondition;
import com.zurrtum.create.content.trains.schedule.condition.ScheduledDelay;
import com.zurrtum.create.content.trains.schedule.condition.StationPoweredCondition;
import com.zurrtum.create.content.trains.schedule.condition.StationUnloadedCondition;
import com.zurrtum.create.content.trains.schedule.condition.TimeOfDayCondition;
import com.zurrtum.create.content.trains.schedule.destination.ChangeThrottleInstruction;
import com.zurrtum.create.content.trains.schedule.destination.ChangeTitleInstruction;
import com.zurrtum.create.content.trains.schedule.destination.DeliverPackagesInstruction;
import com.zurrtum.create.content.trains.schedule.destination.DestinationInstruction;
import com.zurrtum.create.content.trains.schedule.destination.FetchPackagesInstruction;
import com.zurrtum.create.content.trains.schedule.destination.ScheduleInstruction;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.resources.Identifier;

public class AllSchedules {
    public static List<Pair<Identifier, Function<Identifier, ? extends ScheduleInstruction>>> INSTRUCTION_TYPES = new ArrayList<Pair<Identifier, Function<Identifier, ? extends ScheduleInstruction>>>();
    public static List<Pair<Identifier, Function<Identifier, ? extends ScheduleWaitCondition>>> CONDITION_TYPES = new ArrayList<Pair<Identifier, Function<Identifier, ? extends ScheduleWaitCondition>>>();
    public static final Identifier DESTINATION = AllSchedules.registerInstruction("destination", DestinationInstruction::new);
    public static final Identifier PACKAGE_DELIVERY = AllSchedules.registerInstruction("package_delivery", DeliverPackagesInstruction::new);
    public static final Identifier PACKAGE_RETRIEVAL = AllSchedules.registerInstruction("package_retrieval", FetchPackagesInstruction::new);
    public static final Identifier RENAME = AllSchedules.registerInstruction("rename", ChangeTitleInstruction::new);
    public static final Identifier THROTTLE = AllSchedules.registerInstruction("throttle", ChangeThrottleInstruction::new);
    public static final Identifier DELAY = AllSchedules.registerCondition("delay", ScheduledDelay::new);
    public static final Identifier TIME_OF_DAY = AllSchedules.registerCondition("time_of_day", TimeOfDayCondition::new);
    public static final Identifier FLUID_THRESHOLD = AllSchedules.registerCondition("fluid_threshold", FluidThresholdCondition::new);
    public static final Identifier ITEM_THRESHOLD = AllSchedules.registerCondition("item_threshold", ItemThresholdCondition::new);
    public static final Identifier REDSTONE_LINK = AllSchedules.registerCondition("redstone_link", RedstoneLinkCondition::new);
    public static final Identifier PLAYER_COUNT = AllSchedules.registerCondition("player_count", PlayerPassengerCondition::new);
    public static final Identifier IDLE = AllSchedules.registerCondition("idle", IdleCargoCondition::new);
    public static final Identifier UNLOADED = AllSchedules.registerCondition("unloaded", StationUnloadedCondition::new);
    public static final Identifier POWERED = AllSchedules.registerCondition("powered", StationPoweredCondition::new);

    public static ScheduleInstruction createScheduleInstruction(Identifier location) {
        for (Pair<Identifier, Function<Identifier, ? extends ScheduleInstruction>> type : INSTRUCTION_TYPES) {
            if (!type.getFirst().equals((Object)location)) continue;
            return type.getSecond().apply(location);
        }
        return null;
    }

    public static ScheduleWaitCondition createScheduleWaitCondition(Identifier location) {
        for (Pair<Identifier, Function<Identifier, ? extends ScheduleWaitCondition>> type : CONDITION_TYPES) {
            if (!type.getFirst().equals((Object)location)) continue;
            return type.getSecond().apply(location);
        }
        return null;
    }

    private static Identifier registerInstruction(String name, Function<Identifier, ? extends ScheduleInstruction> factory) {
        Identifier id = Identifier.fromNamespaceAndPath((String)"create", (String)name);
        INSTRUCTION_TYPES.add(Pair.of(id, factory));
        return id;
    }

    private static Identifier registerCondition(String name, Function<Identifier, ? extends ScheduleWaitCondition> factory) {
        Identifier id = Identifier.fromNamespaceAndPath((String)"create", (String)name);
        CONDITION_TYPES.add(Pair.of(id, factory));
        return id;
    }

    public static void register() {
    }
}

