/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.api.contraption.storage.item.simple;

import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllMountedStorageTypes;
import com.zurrtum.create.api.contraption.storage.item.MountedItemStorageType;
import com.zurrtum.create.api.contraption.storage.item.WrapperMountedItemStorage;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class SimpleMountedStorage
extends WrapperMountedItemStorage<ItemStackHandler> {
    public static final MapCodec<SimpleMountedStorage> CODEC = SimpleMountedStorage.codec(SimpleMountedStorage::new);

    public SimpleMountedStorage(MountedItemStorageType<?> type, Container handler) {
        super(type, SimpleMountedStorage.copyToItemStackHandler(handler));
    }

    public SimpleMountedStorage(Container handler) {
        this((MountedItemStorageType<?>)AllMountedStorageTypes.SIMPLE, handler);
    }

    @Override
    public void unmount(Level level, BlockState state, BlockPos pos, @Nullable BlockEntity be) {
        if (be == null) {
            return;
        }
        Container cap = ItemHelper.getInventory(level, pos, state, be, null);
        if (cap != null) {
            this.validate(cap).ifPresent(handler -> {
                int size = handler.getContainerSize();
                for (int i = 0; i < size; ++i) {
                    handler.setItem(i, this.getItem(i));
                }
            });
        }
    }

    protected Optional<Container> validate(Container handler) {
        if (handler.getContainerSize() == this.getContainerSize()) {
            return Optional.of(handler);
        }
        return Optional.empty();
    }

    public static <T extends SimpleMountedStorage> MapCodec<T> codec(Function<Container, T> factory) {
        return CreateCodecs.ITEM_STACK_HANDLER.xmap(factory, storage -> (ItemStackHandler)storage.wrapped).fieldOf("value");
    }
}

