/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.api.registry;

import com.zurrtum.create.impl.registry.SimpleRegistryImpl;
import com.zurrtum.create.impl.registry.TagProviderImpl;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public interface SimpleRegistry<K, V> {
    public static <K, V> SimpleRegistry<K, V> create() {
        return SimpleRegistryImpl.single();
    }

    public void register(K var1, V var2);

    public void registerProvider(Provider<K, V> var1);

    public void invalidate();

    @Nullable
    default public V get(K object, Level world) {
        return this.get(object);
    }

    @Nullable
    public V get(K var1);

    @Nullable
    public V get(StateHolder<K, ?> var1);

    public static interface Multi<K, V>
    extends SimpleRegistry<K, List<V>> {
        public static <K, V> Multi<K, V> create() {
            return SimpleRegistryImpl.multi();
        }

        public void add(K var1, V var2);

        public void addProvider(Provider<K, V> var1);

        @Override
        @NotNull
        public List<V> get(K var1);

        @Override
        @NotNull
        public List<V> get(K var1, Level var2);

        @Override
        @NotNull
        public List<V> get(StateHolder<K, ?> var1);
    }

    @FunctionalInterface
    public static interface Provider<K, V> {
        public static <K, V> Provider<K, V> forTag(TagKey<K> tag, Function<K, Holder<K>> holderGetter, V value) {
            return new TagProviderImpl<K, V>(tag, holderGetter, value);
        }

        public static <V> Provider<Block, V> forBlockTag(TagKey<Block> tag, V value) {
            return new TagProviderImpl<Block, V>(tag, Block::builtInRegistryHolder, value);
        }

        public static <V> Provider<BlockEntityType<?>, V> forBlockEntityTag(TagKey<BlockEntityType<?>> tag, V value) {
            return new TagProviderImpl<BlockEntityType, V>(tag, TagProviderImpl::getBeHolder, value);
        }

        public static <V> Provider<Item, V> forItemTag(TagKey<Item> tag, V value) {
            return new TagProviderImpl<Item, V>(tag, Item::builtInRegistryHolder, value);
        }

        public static <V> Provider<EntityType<?>, V> forEntityTag(TagKey<EntityType<?>> tag, V value) {
            return new TagProviderImpl<EntityType, V>(tag, EntityType::builtInRegistryHolder, value);
        }

        public static <V> Provider<Fluid, V> forFluidTag(TagKey<Fluid> tag, V value) {
            return new TagProviderImpl<Fluid, V>(tag, Fluid::builtInRegistryHolder, value);
        }

        @Nullable
        default public V get(K object, Level world) {
            return this.get(object);
        }

        @Nullable
        public V get(K var1);

        default public void onRegister(Runnable invalidate) {
        }
    }
}

