/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.catnip.codecs;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import org.jetbrains.annotations.Nullable;

public interface CatnipCodecUtils {
    public static <T> Optional<T> decode(Codec<T> codec, Tag tag) {
        return CatnipCodecUtils.decode(codec, NbtOps.INSTANCE, tag);
    }

    public static <T> Optional<T> decode(Codec<T> codec, HolderLookup.Provider registries, Tag tag) {
        return CatnipCodecUtils.decode(codec, RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)registries), tag);
    }

    public static <T, S> Optional<T> decode(Codec<T> codec, DynamicOps<S> ops, S s) {
        return codec.decode(ops, s).result().map(Pair::getFirst);
    }

    @Nullable
    public static <T> T decodeOrNull(Codec<T> codec, Tag tag) {
        return CatnipCodecUtils.decodeOrNull(codec, NbtOps.INSTANCE, tag);
    }

    @Nullable
    public static <T> T decodeOrNull(Codec<T> codec, HolderLookup.Provider registries, Tag tag) {
        return CatnipCodecUtils.decodeOrNull(codec, RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)registries), tag);
    }

    @Nullable
    public static <T, S> T decodeOrNull(Codec<T> codec, DynamicOps<S> ops, S s) {
        return (T)codec.decode(ops, s).mapOrElse(Pair::getFirst, e -> null);
    }

    public static <T> Optional<Tag> encode(Codec<T> codec, T t) {
        return CatnipCodecUtils.encode(codec, NbtOps.INSTANCE, t);
    }

    public static <T> Optional<Tag> encode(Codec<T> codec, HolderLookup.Provider registries, T t) {
        return CatnipCodecUtils.encode(codec, RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)registries), t);
    }

    public static <T, S> Optional<S> encode(Codec<T> codec, DynamicOps<S> ops, T t) {
        return codec.encodeStart(ops, t).result();
    }
}

