/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllEntityTypes;
import com.zurrtum.create.api.behaviour.movement.MovementBehaviour;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.IControlContraption;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.contraptions.TranslatingContraption;
import com.zurrtum.create.content.contraptions.bearing.BearingContraption;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public class ControlledContraptionEntity
extends AbstractContraptionEntity {
    protected BlockPos controllerPos;
    protected Direction.Axis rotationAxis;
    public float prevAngle;
    public float angle;
    protected float angleDelta;

    public ControlledContraptionEntity(EntityType<? extends ControlledContraptionEntity> type, Level world) {
        super(type, world);
    }

    public static ControlledContraptionEntity create(Level world, IControlContraption controller, Contraption contraption) {
        ControlledContraptionEntity entity = new ControlledContraptionEntity((EntityType<? extends ControlledContraptionEntity>)AllEntityTypes.CONTROLLED_CONTRAPTION, world);
        entity.controllerPos = controller.getBlockPosition();
        entity.setContraption(contraption);
        return entity;
    }

    @Override
    public void setPos(double x, double y, double z) {
        super.setPos(x, y, z);
        if (!this.level().isClientSide()) {
            return;
        }
        for (Entity entity : this.getPassengers()) {
            this.positionRider(entity);
        }
    }

    @Override
    public Vec3 getContactPointMotion(Vec3 globalContactPoint) {
        if (this.contraption instanceof TranslatingContraption) {
            return this.getDeltaMovement();
        }
        return super.getContactPointMotion(globalContactPoint);
    }

    @Override
    protected void setContraption(Contraption contraption) {
        super.setContraption(contraption);
        if (contraption instanceof BearingContraption) {
            this.rotationAxis = ((BearingContraption)contraption).getFacing().getAxis();
        }
    }

    @Override
    protected void readAdditional(ValueInput view, boolean spawnPacket) {
        super.readAdditional(view, spawnPacket);
        view.read("ControllerRelative", BlockPos.CODEC).ifPresent(pos -> {
            this.controllerPos = pos.offset((Vec3i)this.blockPosition());
        });
        view.read("Axis", (Codec)Direction.Axis.CODEC).ifPresent(axis -> {
            this.rotationAxis = axis;
        });
        this.angle = view.getFloatOr("Angle", 0.0f);
    }

    @Override
    protected void writeAdditional(ValueOutput view, boolean spawnPacket) {
        super.writeAdditional(view, spawnPacket);
        view.store("ControllerRelative", BlockPos.CODEC, (Object)this.controllerPos.subtract((Vec3i)this.blockPosition()));
        if (this.rotationAxis != null) {
            view.store("Axis", (Codec)Direction.Axis.CODEC, (Object)this.rotationAxis);
        }
        view.putFloat("Angle", this.angle);
    }

    @Override
    public AbstractContraptionEntity.ContraptionRotationState getRotationState() {
        AbstractContraptionEntity.ContraptionRotationState crs = new AbstractContraptionEntity.ContraptionRotationState();
        if (this.rotationAxis == Direction.Axis.X) {
            crs.xRotation = this.angle;
        }
        if (this.rotationAxis == Direction.Axis.Y) {
            crs.yRotation = this.angle;
        }
        if (this.rotationAxis == Direction.Axis.Z) {
            crs.zRotation = this.angle;
        }
        return crs;
    }

    @Override
    public Vec3 applyRotation(Vec3 localPos, float partialTicks) {
        localPos = VecHelper.rotate(localPos, this.getAngle(partialTicks), this.rotationAxis);
        return localPos;
    }

    @Override
    public Vec3 reverseRotation(Vec3 localPos, float partialTicks) {
        localPos = VecHelper.rotate(localPos, -this.getAngle(partialTicks), this.rotationAxis);
        return localPos;
    }

    public void setAngle(float angle) {
        this.angle = angle;
        if (!this.level().isClientSide()) {
            return;
        }
        for (Entity entity : this.getPassengers()) {
            this.positionRider(entity);
        }
    }

    public float getAngle(float partialTicks) {
        return partialTicks == 1.0f ? this.angle : AngleHelper.angleLerp(partialTicks, this.prevAngle, this.angle);
    }

    public void setRotationAxis(Direction.Axis rotationAxis) {
        this.rotationAxis = rotationAxis;
    }

    public Direction.Axis getRotationAxis() {
        return this.rotationAxis;
    }

    public void teleportTo(double p_70634_1_, double p_70634_3_, double p_70634_5_) {
    }

    public void moveOrInterpolateTo(Vec3 pos, float yaw, float pitch) {
    }

    @Override
    protected void tickContraption() {
        this.angleDelta = this.angle - this.prevAngle;
        this.prevAngle = this.angle;
        this.tickActors();
        if (this.controllerPos == null) {
            return;
        }
        if (!this.level().isLoaded(this.controllerPos)) {
            return;
        }
        IControlContraption controller = this.getController();
        if (controller == null) {
            this.discard();
            return;
        }
        if (!controller.isAttachedTo(this)) {
            controller.attach(this);
            if (this.level().isClientSide()) {
                this.setPos(this.getX(), this.getY(), this.getZ());
            }
        }
    }

    @Override
    protected boolean shouldActorTrigger(MovementContext context, StructureTemplate.StructureBlockInfo blockInfo, MovementBehaviour actor, Vec3 actorPosition, BlockPos gridPosition) {
        if (super.shouldActorTrigger(context, blockInfo, actor, actorPosition, gridPosition)) {
            return true;
        }
        Contraption contraption = this.contraption;
        if (!(contraption instanceof BearingContraption)) {
            return false;
        }
        BearingContraption bc = (BearingContraption)contraption;
        Direction facing = bc.getFacing();
        Vec3 activeAreaOffset = actor.getActiveAreaOffset(context);
        if (!activeAreaOffset.multiply(VecHelper.axisAlingedPlaneOf(Vec3.atLowerCornerOf((Vec3i)facing.getUnitVec3i()))).equals((Object)Vec3.ZERO)) {
            return false;
        }
        if (!VecHelper.onSameAxis(blockInfo.pos(), BlockPos.ZERO, facing.getAxis())) {
            return false;
        }
        context.relativeMotion = context.motion = Vec3.atLowerCornerOf((Vec3i)facing.getUnitVec3i()).scale((double)this.angleDelta / 360.0);
        int timer = context.data.getIntOr("StationaryTimer", 0);
        if (timer > 0) {
            context.data.putInt("StationaryTimer", timer - 1);
            return false;
        }
        context.data.putInt("StationaryTimer", 20);
        return true;
    }

    protected IControlContraption getController() {
        if (this.controllerPos == null) {
            return null;
        }
        if (!this.level().isLoaded(this.controllerPos)) {
            return null;
        }
        BlockEntity be = this.level().getBlockEntity(this.controllerPos);
        if (!(be instanceof IControlContraption)) {
            return null;
        }
        return (IControlContraption)be;
    }

    @Override
    protected StructureTransform makeStructureTransform() {
        BlockPos offset = BlockPos.containing((Position)this.getAnchorVec().add(0.5, 0.5, 0.5));
        float xRot = this.rotationAxis == Direction.Axis.X ? this.angle : 0.0f;
        float yRot = this.rotationAxis == Direction.Axis.Y ? this.angle : 0.0f;
        float zRot = this.rotationAxis == Direction.Axis.Z ? this.angle : 0.0f;
        return new StructureTransform(offset, xRot, yRot, zRot);
    }

    @Override
    protected void onContraptionStalled() {
        IControlContraption controller = this.getController();
        if (controller != null) {
            controller.onStall();
        }
        super.onContraptionStalled();
    }

    @Override
    protected float getStalledAngle() {
        return this.angle;
    }

    @Override
    public void handleStallInformation(double x, double y, double z, float angle) {
        this.setPosRaw(x, y, z);
        this.angle = this.prevAngle = angle;
    }
}

