/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.ListBuilder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.zurrtum.create.AllMountedItemStorageTypeTags;
import com.zurrtum.create.Create;
import com.zurrtum.create.api.contraption.storage.SyncedMountedStorage;
import com.zurrtum.create.api.contraption.storage.fluid.MountedFluidStorage;
import com.zurrtum.create.api.contraption.storage.fluid.MountedFluidStorageType;
import com.zurrtum.create.api.contraption.storage.fluid.MountedFluidStorageWrapper;
import com.zurrtum.create.api.contraption.storage.item.MountedItemStorage;
import com.zurrtum.create.api.contraption.storage.item.MountedItemStorageType;
import com.zurrtum.create.api.contraption.storage.item.MountedItemStorageWrapper;
import com.zurrtum.create.catnip.nbt.NBTHelper;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.infrastructure.items.CombinedInvWrapper;
import com.zurrtum.create.infrastructure.packet.s2c.MountedStorageSyncPacket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;

public class MountedStorageManager {
    private Map<BlockPos, MountedItemStorage> itemsBuilder;
    private Map<BlockPos, MountedFluidStorage> fluidsBuilder;
    private Map<BlockPos, SyncedMountedStorage> syncedItemsBuilder;
    private Map<BlockPos, SyncedMountedStorage> syncedFluidsBuilder;
    private ImmutableMap<BlockPos, MountedItemStorage> allItemStorages;
    protected MountedItemStorageWrapper items;
    @Nullable
    protected MountedItemStorageWrapper fuelItems;
    protected MountedFluidStorageWrapper fluids;
    private ImmutableMap<BlockPos, SyncedMountedStorage> syncedItems;
    private ImmutableMap<BlockPos, SyncedMountedStorage> syncedFluids;
    private List<Container> externalHandlers;
    protected CombinedInvWrapper allItems;
    private int syncCooldown;
    private Set<BlockPos> interactablePositions;

    public MountedStorageManager() {
        this.reset();
    }

    public void initialize() {
        if (this.isInitialized()) {
            return;
        }
        this.allItemStorages = ImmutableMap.copyOf(this.itemsBuilder);
        this.items = new MountedItemStorageWrapper(MountedStorageManager.subMap(this.allItemStorages, this::isExposed));
        this.allItems = this.items;
        this.itemsBuilder = null;
        ImmutableMap<BlockPos, MountedItemStorage> fuelMap = MountedStorageManager.subMap(this.allItemStorages, this::canUseForFuel);
        this.fuelItems = fuelMap.isEmpty() ? null : new MountedItemStorageWrapper(fuelMap);
        ImmutableMap fluids = ImmutableMap.copyOf(this.fluidsBuilder);
        this.fluids = new MountedFluidStorageWrapper((ImmutableMap<BlockPos, MountedFluidStorage>)fluids);
        this.fluidsBuilder = null;
        this.syncedItems = ImmutableMap.copyOf(this.syncedItemsBuilder);
        this.syncedItemsBuilder = null;
        this.syncedFluids = ImmutableMap.copyOf(this.syncedFluidsBuilder);
        this.syncedFluidsBuilder = null;
    }

    private boolean isExposed(MountedItemStorage storage) {
        return !storage.type.is(AllMountedItemStorageTypeTags.INTERNAL);
    }

    private boolean canUseForFuel(MountedItemStorage storage) {
        return this.isExposed(storage) && !storage.type.is(AllMountedItemStorageTypeTags.FUEL_BLACKLIST);
    }

    private boolean isInitialized() {
        return this.itemsBuilder == null;
    }

    private void assertInitialized() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("MountedStorageManager is uninitialized");
        }
    }

    protected void reset() {
        this.allItemStorages = null;
        this.items = null;
        this.fuelItems = null;
        this.fluids = null;
        this.externalHandlers = new ArrayList<Container>();
        this.allItems = null;
        this.itemsBuilder = new HashMap<BlockPos, MountedItemStorage>();
        this.fluidsBuilder = new HashMap<BlockPos, MountedFluidStorage>();
        this.syncedItemsBuilder = new HashMap<BlockPos, SyncedMountedStorage>();
        this.syncedFluidsBuilder = new HashMap<BlockPos, SyncedMountedStorage>();
    }

    public void addBlock(Level level, BlockState state, BlockPos globalPos, BlockPos localPos, @Nullable BlockEntity be) {
        Object storage;
        MountedFluidStorageType<?> fluidType;
        Object storage2;
        MountedItemStorageType<?> itemType = MountedItemStorageType.REGISTRY.get(state.getBlock());
        if (itemType != null && (storage2 = itemType.mount(level, state, globalPos, be)) != null) {
            this.addStorage((MountedItemStorage)storage2, localPos);
        }
        if ((fluidType = MountedFluidStorageType.REGISTRY.get(state.getBlock())) != null && (storage = fluidType.mount(level, state, globalPos, be)) != null) {
            this.addStorage((MountedFluidStorage)storage, localPos);
        }
    }

    public void unmount(Level level, StructureTemplate.StructureBlockInfo info, BlockPos globalPos, @Nullable BlockEntity be) {
        MountedFluidStorageType<?> expectedType;
        MountedFluidStorage fluidStorage;
        MountedItemStorageType<?> expectedType2;
        BlockPos localPos = info.pos();
        BlockState state = info.state();
        MountedItemStorage itemStorage = (MountedItemStorage)this.getAllItemStorages().get((Object)localPos);
        if (itemStorage != null && itemStorage.type == (expectedType2 = MountedItemStorageType.REGISTRY.get(state.getBlock()))) {
            itemStorage.unmount(level, state, globalPos, be);
        }
        if ((fluidStorage = (MountedFluidStorage)this.getFluids().storages.get((Object)localPos)) != null && fluidStorage.type == (expectedType = MountedFluidStorageType.REGISTRY.get(state.getBlock()))) {
            fluidStorage.unmount(level, state, globalPos, be);
        }
    }

    public void tick(AbstractContraptionEntity entity) {
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
            return;
        }
        HashMap<BlockPos, MountedItemStorage> items = new HashMap<BlockPos, MountedItemStorage>();
        HashMap<BlockPos, MountedFluidStorage> fluids = new HashMap<BlockPos, MountedFluidStorage>();
        this.syncedItems.forEach((pos, storage) -> {
            if (storage.isDirty()) {
                items.put((BlockPos)pos, (MountedItemStorage)((Object)storage));
                storage.markClean();
            }
        });
        this.syncedFluids.forEach((pos, storage) -> {
            if (storage.isDirty()) {
                fluids.put((BlockPos)pos, (MountedFluidStorage)((Object)storage));
                storage.markClean();
            }
        });
        if (!items.isEmpty() || !fluids.isEmpty()) {
            MountedStorageSyncPacket packet = new MountedStorageSyncPacket(entity.getId(), items, fluids);
            ((ServerChunkCache)entity.level().getChunkSource()).sendToTrackingPlayers((Entity)entity, (Packet)packet);
            this.syncCooldown = 8;
        }
    }

    public void handleSync(MountedStorageSyncPacket packet, AbstractContraptionEntity entity) {
        ImmutableMap<BlockPos, MountedItemStorage> items = this.getAllItemStorages();
        MountedFluidStorageWrapper fluids = this.getFluids();
        this.reset();
        IdentityHashMap<SyncedMountedStorage, BlockPos> syncedStorages = new IdentityHashMap<SyncedMountedStorage, BlockPos>();
        try {
            this.itemsBuilder.putAll((Map<BlockPos, MountedItemStorage>)items);
            this.fluidsBuilder.putAll((Map<BlockPos, MountedFluidStorage>)fluids.storages);
            packet.items().forEach((pos, storage) -> {
                this.itemsBuilder.put((BlockPos)pos, (MountedItemStorage)storage);
                syncedStorages.put((SyncedMountedStorage)((Object)storage), (BlockPos)pos);
            });
            packet.fluids().forEach((pos, storage) -> {
                this.fluidsBuilder.put((BlockPos)pos, (MountedFluidStorage)storage);
                syncedStorages.put((SyncedMountedStorage)((Object)storage), (BlockPos)pos);
            });
        }
        catch (Throwable t) {
            Create.LOGGER.error("An error occurred while syncing a MountedStorageManager", t);
        }
        this.initialize();
        Contraption contraption = entity.getContraption();
        syncedStorages.forEach((storage, pos) -> storage.afterSync(contraption, (BlockPos)pos));
    }

    public void read(ValueInput view, boolean clientPacket, @Nullable Contraption contraption) {
        this.reset();
        try {
            view.childrenListOrEmpty("items").forEach(item -> {
                BlockPos pos = (BlockPos)item.read("pos", BlockPos.CODEC).orElseThrow();
                MountedItemStorage storage = (MountedItemStorage)item.read("storage", MountedItemStorage.CODEC).orElseThrow();
                this.addStorage(storage, pos);
            });
            view.childrenListOrEmpty("fluids").forEach(fluid -> {
                BlockPos pos = (BlockPos)fluid.read("pos", BlockPos.CODEC).orElseThrow();
                MountedFluidStorage storage = (MountedFluidStorage)fluid.read("storage", MountedFluidStorage.CODEC).orElseThrow();
                this.addStorage(storage, pos);
            });
            view.read("interactable_positions", CreateCodecs.BLOCK_POS_LIST_CODEC).ifPresent(list -> {
                this.interactablePositions = new HashSet<BlockPos>((Collection<BlockPos>)list);
            });
        }
        catch (Throwable t) {
            Create.LOGGER.error("Error deserializing mounted storage", t);
        }
        this.initialize();
        this.afterSync(clientPacket, contraption);
    }

    public <T> void read(DynamicOps<T> ops, MapLike<T> map, boolean clientPacket, @Nullable Contraption contraption) {
        this.reset();
        try {
            ((Consumer)ops.getList(map.get("items")).getOrThrow()).accept(item -> {
                MapLike data = (MapLike)ops.getMap(item).getOrThrow();
                BlockPos pos = (BlockPos)BlockPos.CODEC.parse(ops, data.get("pos")).getOrThrow();
                MountedItemStorage storage = (MountedItemStorage)MountedItemStorage.CODEC.parse(ops, data.get("storage")).getOrThrow();
                this.addStorage(storage, pos);
            });
            ((Consumer)ops.getList(map.get("fluids")).getOrThrow()).accept(fluid -> {
                MapLike data = (MapLike)ops.getMap(fluid).getOrThrow();
                BlockPos pos = (BlockPos)BlockPos.CODEC.parse(ops, data.get("pos")).getOrThrow();
                MountedFluidStorage storage = (MountedFluidStorage)MountedFluidStorage.CODEC.parse(ops, data.get("storage")).getOrThrow();
                this.addStorage(storage, pos);
            });
            CreateCodecs.BLOCK_POS_LIST_CODEC.parse(ops, map.get("interactable_positions")).ifSuccess(list -> {
                this.interactablePositions = new HashSet<BlockPos>((Collection<BlockPos>)list);
            });
        }
        catch (Throwable t) {
            Create.LOGGER.error("Error deserializing mounted storage", t);
        }
        this.initialize();
        this.afterSync(clientPacket, contraption);
    }

    private void afterSync(boolean clientPacket, @Nullable Contraption contraption) {
        if (!clientPacket || contraption == null) {
            return;
        }
        this.getAllItemStorages().forEach((pos, storage) -> {
            if (storage instanceof SyncedMountedStorage) {
                SyncedMountedStorage synced = (SyncedMountedStorage)((Object)storage);
                synced.afterSync(contraption, (BlockPos)pos);
            }
        });
        this.getFluids().storages.forEach((pos, storage) -> {
            if (storage instanceof SyncedMountedStorage) {
                SyncedMountedStorage synced = (SyncedMountedStorage)((Object)storage);
                synced.afterSync(contraption, (BlockPos)pos);
            }
        });
    }

    public void write(ValueOutput view, boolean clientPacket) {
        ValueOutput.ValueOutputList items = view.childrenList("items");
        this.getAllItemStorages().forEach((pos, storage) -> {
            if (!clientPacket || storage instanceof SyncedMountedStorage) {
                ValueOutput item = items.addChild();
                item.store("pos", BlockPos.CODEC, pos);
                item.store("storage", MountedItemStorage.CODEC, storage);
            }
        });
        ValueOutput.ValueOutputList fluids = view.childrenList("fluids");
        this.getFluids().storages.forEach((pos, storage) -> {
            if (!clientPacket || storage instanceof SyncedMountedStorage) {
                ValueOutput fluid = fluids.addChild();
                fluid.store("pos", BlockPos.CODEC, pos);
                fluid.store("storage", MountedFluidStorage.CODEC, storage);
            }
        });
        if (clientPacket) {
            List list = Sets.union((Set)this.getAllItemStorages().keySet(), (Set)this.getFluids().storages.keySet()).stream().toList();
            view.store("interactable_positions", CreateCodecs.BLOCK_POS_LIST_CODEC, list);
        }
    }

    public <T> void write(DynamicOps<T> ops, T empty, RecordBuilder<T> map, boolean clientPacket) {
        ListBuilder items = ops.listBuilder();
        this.getAllItemStorages().forEach((pos, storage) -> {
            if (!clientPacket || storage instanceof SyncedMountedStorage) {
                RecordBuilder item = ops.mapBuilder();
                item.add("pos", pos, (Encoder)BlockPos.CODEC);
                item.add("storage", storage, MountedItemStorage.CODEC);
                items.add(item.build(empty));
            }
        });
        map.add("items", items.build(empty));
        ListBuilder fluids = ops.listBuilder();
        this.getFluids().storages.forEach((pos, storage) -> {
            if (!clientPacket || storage instanceof SyncedMountedStorage) {
                RecordBuilder fluid = ops.mapBuilder();
                fluid.add("pos", pos, (Encoder)BlockPos.CODEC);
                fluid.add("storage", storage, MountedFluidStorage.CODEC);
                fluids.add(fluid.build(empty));
            }
        });
        map.add("fluids", fluids.build(empty));
        if (clientPacket) {
            List list = Sets.union((Set)this.getAllItemStorages().keySet(), (Set)this.getFluids().storages.keySet()).stream().toList();
            map.add("interactable_positions", list, CreateCodecs.BLOCK_POS_LIST_CODEC);
        }
    }

    public void attachExternal(Container externalStorage) {
        this.externalHandlers.add(externalStorage);
        int size = this.externalHandlers.size();
        Container[] all = new Container[size + 1];
        all[0] = this.items;
        for (int i = 0; i < size; ++i) {
            all[i + 1] = this.externalHandlers.get(i);
        }
        this.allItems = new CombinedInvWrapper(all);
    }

    public CombinedInvWrapper getAllItems() {
        this.assertInitialized();
        return this.allItems;
    }

    public ImmutableMap<BlockPos, MountedItemStorage> getAllItemStorages() {
        this.assertInitialized();
        return this.allItemStorages;
    }

    public MountedItemStorageWrapper getMountedItems() {
        this.assertInitialized();
        return this.items;
    }

    @Nullable
    public MountedItemStorageWrapper getFuelItems() {
        this.assertInitialized();
        return this.fuelItems;
    }

    public MountedFluidStorageWrapper getFluids() {
        this.assertInitialized();
        return this.fluids;
    }

    public boolean handlePlayerStorageInteraction(Contraption contraption, Player player, BlockPos localPos) {
        if (!(player instanceof ServerPlayer)) {
            return this.interactablePositions != null && this.interactablePositions.contains(localPos);
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        StructureTemplate.StructureBlockInfo info = contraption.getBlocks().get(localPos);
        if (info == null) {
            return false;
        }
        MountedStorageManager storageManager = contraption.getStorage();
        MountedItemStorage storage = (MountedItemStorage)storageManager.getAllItemStorages().get((Object)localPos);
        if (storage != null) {
            return storage.handleInteraction(serverPlayer, contraption, info);
        }
        return false;
    }

    private void readLegacy(HolderLookup.Provider registries, CompoundTag nbt) {
        NBTHelper.iterateCompoundList(nbt.getListOrEmpty("Storage"), tag -> {
            BlockPos pos = NBTHelper.readBlockPos(tag, "Pos");
            CompoundTag data = tag.getCompoundOrEmpty("Data");
        });
        NBTHelper.iterateCompoundList(nbt.getListOrEmpty("FluidStorage"), tag -> {
            BlockPos pos = NBTHelper.readBlockPos(tag, "Pos");
            CompoundTag data = tag.getCompoundOrEmpty("Data");
        });
    }

    private void addStorage(MountedItemStorage storage, BlockPos pos) {
        this.itemsBuilder.put(pos, storage);
        if (storage instanceof SyncedMountedStorage) {
            SyncedMountedStorage synced = (SyncedMountedStorage)((Object)storage);
            this.syncedItemsBuilder.put(pos, synced);
        }
    }

    private void addStorage(MountedFluidStorage storage, BlockPos pos) {
        this.fluidsBuilder.put(pos, storage);
        if (storage instanceof SyncedMountedStorage) {
            SyncedMountedStorage synced = (SyncedMountedStorage)((Object)storage);
            this.syncedFluidsBuilder.put(pos, synced);
        }
    }

    private static <K, V> ImmutableMap<K, V> subMap(Map<K, V> map, Predicate<V> predicate) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        map.forEach((key, value) -> {
            if (predicate.test(value)) {
                builder.put(key, value);
            }
        });
        return builder.build();
    }
}

