/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.mounted;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.Create;
import com.zurrtum.create.api.behaviour.movement.MovementBehaviour;
import com.zurrtum.create.api.contraption.ContraptionMovementSetting;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.OrientedContraptionEntity;
import com.zurrtum.create.content.contraptions.actors.psi.PortableStorageInterfaceMovement;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.contraptions.data.ContraptionPickupLimiting;
import com.zurrtum.create.content.kinetics.deployer.DeployerPlayer;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.minecart.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.MutablePair;
import org.jetbrains.annotations.Nullable;

public class MinecartContraptionItem
extends Item {
    private final EntityType<? extends AbstractMinecart> minecartType;
    private static final DispenseItemBehavior DISPENSER_BEHAVIOR = new DefaultDispenseItemBehavior(){
        private final DefaultDispenseItemBehavior behaviourDefaultDispenseItem = new DefaultDispenseItemBehavior();

        public ItemStack execute(BlockSource source, ItemStack stack) {
            double d3;
            RailShape railshape;
            Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
            ServerLevel world = source.level();
            Vec3 vec3 = source.center();
            double d0 = vec3.x() + (double)direction.getStepX() * 1.125;
            double d1 = Math.floor(vec3.y()) + (double)direction.getStepY();
            double d2 = vec3.z() + (double)direction.getStepZ() * 1.125;
            BlockPos blockpos = source.pos().relative(direction);
            BlockState blockstate = world.getBlockState(blockpos);
            Block block = blockstate.getBlock();
            if (block instanceof BaseRailBlock) {
                BaseRailBlock abstractRailBlock = (BaseRailBlock)block;
                v0 = (RailShape)blockstate.getValue(abstractRailBlock.getShapeProperty());
            } else {
                v0 = railshape = RailShape.NORTH_SOUTH;
            }
            if (blockstate.is(BlockTags.RAILS)) {
                d3 = railshape.isSlope() ? 0.6 : 0.1;
            } else {
                RailShape railShape;
                if (!blockstate.isAir() || !world.getBlockState(blockpos.below()).is(BlockTags.RAILS)) {
                    return this.behaviourDefaultDispenseItem.dispense(source, stack);
                }
                BlockState blockstate1 = world.getBlockState(blockpos.below());
                Block block2 = blockstate1.getBlock();
                if (block2 instanceof BaseRailBlock) {
                    BaseRailBlock abstractRailBlock = (BaseRailBlock)block2;
                    railShape = (RailShape)blockstate1.getValue(abstractRailBlock.getShapeProperty());
                } else {
                    railShape = RailShape.NORTH_SOUTH;
                }
                RailShape railshape1 = railShape;
                d3 = direction != Direction.DOWN && railshape1.isSlope() ? -0.4 : -0.9;
            }
            AbstractMinecart abstractminecartentity = AbstractMinecart.createMinecart((Level)world, (double)d0, (double)(d1 + d3), (double)d2, ((MinecartContraptionItem)stack.getItem()).minecartType, (EntitySpawnReason)EntitySpawnReason.SPAWN_ITEM_USE, (ItemStack)stack, null);
            if (stack.has(DataComponents.CUSTOM_NAME)) {
                abstractminecartentity.setCustomName(stack.getHoverName());
            }
            world.addFreshEntity((Entity)abstractminecartentity);
            MinecartContraptionItem.addContraptionToMinecart((Level)world, stack, abstractminecartentity, direction);
            stack.shrink(1);
            return stack;
        }

        protected void playSound(BlockSource source) {
            source.level().levelEvent(1000, source.pos(), 0);
        }
    };

    public static MinecartContraptionItem rideable(Item.Properties builder) {
        return new MinecartContraptionItem((EntityType<? extends AbstractMinecart>)EntityType.MINECART, builder);
    }

    public static MinecartContraptionItem furnace(Item.Properties builder) {
        return new MinecartContraptionItem((EntityType<? extends AbstractMinecart>)EntityType.FURNACE_MINECART, builder);
    }

    public static MinecartContraptionItem chest(Item.Properties builder) {
        return new MinecartContraptionItem((EntityType<? extends AbstractMinecart>)EntityType.CHEST_MINECART, builder);
    }

    public boolean canFitInsideContainerItems() {
        return (Boolean)AllConfigs.server().kinetics.minecartContraptionInContainers.get();
    }

    private MinecartContraptionItem(EntityType<? extends AbstractMinecart> minecartTypeIn, Item.Properties builder) {
        super(builder);
        this.minecartType = minecartTypeIn;
        DispenserBlock.registerBehavior((ItemLike)this, (DispenseItemBehavior)DISPENSER_BEHAVIOR);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos blockpos;
        Level world = context.getLevel();
        BlockState blockstate = world.getBlockState(blockpos = context.getClickedPos());
        if (!blockstate.is(BlockTags.RAILS)) {
            return InteractionResult.FAIL;
        }
        ItemStack itemstack = context.getItemInHand();
        if (world instanceof ServerLevel) {
            RailShape railShape;
            ServerLevel serverlevel = (ServerLevel)world;
            Block block = blockstate.getBlock();
            if (block instanceof BaseRailBlock) {
                BaseRailBlock abstractRailBlock = (BaseRailBlock)block;
                railShape = (RailShape)blockstate.getValue(abstractRailBlock.getShapeProperty());
            } else {
                railShape = RailShape.NORTH_SOUTH;
            }
            RailShape railshape = railShape;
            double d0 = 0.0;
            if (railshape.isSlope()) {
                d0 = 0.5;
            }
            AbstractMinecart abstractminecartentity = AbstractMinecart.createMinecart((Level)serverlevel, (double)((double)blockpos.getX() + 0.5), (double)((double)blockpos.getY() + 0.0625 + d0), (double)((double)blockpos.getZ() + 0.5), this.minecartType, (EntitySpawnReason)EntitySpawnReason.SPAWN_ITEM_USE, (ItemStack)itemstack, null);
            if (itemstack.has(DataComponents.CUSTOM_NAME)) {
                abstractminecartentity.setCustomName(itemstack.getHoverName());
            }
            Player player = context.getPlayer();
            world.addFreshEntity((Entity)abstractminecartentity);
            MinecartContraptionItem.addContraptionToMinecart(world, itemstack, abstractminecartentity, player == null ? null : player.getDirection());
        }
        itemstack.shrink(1);
        return InteractionResult.SUCCESS;
    }

    public static void addContraptionToMinecart(Level world, ItemStack itemstack, AbstractMinecart cart, @Nullable Direction newFacing) {
        if (itemstack.has(AllDataComponents.MINECRAFT_CONTRAPTION_DATA)) {
            CompoundTag contraptionTag = (CompoundTag)itemstack.get(AllDataComponents.MINECRAFT_CONTRAPTION_DATA);
            Direction intialOrientation = contraptionTag.read("InitialOrientation", (Codec)Direction.CODEC).orElse(Direction.DOWN);
            try (ProblemReporter.ScopedCollector logging = new ProblemReporter.ScopedCollector(cart.problemPath(), Create.LOGGER);){
                Contraption mountedContraption = Contraption.fromData(world, TagValueInput.create((ProblemReporter)logging, (HolderLookup.Provider)world.registryAccess(), (CompoundTag)contraptionTag), false);
                OrientedContraptionEntity contraptionEntity = newFacing == null ? OrientedContraptionEntity.create(world, mountedContraption, intialOrientation) : OrientedContraptionEntity.createAtYaw(world, mountedContraption, intialOrientation, newFacing.toYRot());
                contraptionEntity.startRiding((Entity)cart);
                contraptionEntity.setPos(cart.getX(), cart.getY(), cart.getZ());
                world.addFreshEntity((Entity)contraptionEntity);
            }
        }
    }

    public static InteractionResult wrenchCanBeUsedToPickUpMinecartContraptions(Player player, InteractionHand hand, Entity entity) {
        Optional result;
        Object e;
        DeployerPlayer dfp;
        if (player == null || entity == null) {
            return null;
        }
        if (!((Boolean)AllConfigs.server().kinetics.survivalContraptionPickup.get()).booleanValue() && !player.isCreative()) {
            return null;
        }
        ItemStack wrench = player.getItemInHand(hand);
        if (!wrench.is((Item)AllItems.WRENCH)) {
            return null;
        }
        if (entity instanceof AbstractContraptionEntity) {
            entity = entity.getVehicle();
        }
        if (!(entity instanceof AbstractMinecart)) {
            return null;
        }
        AbstractMinecart cart = (AbstractMinecart)entity;
        if (!entity.isAlive()) {
            return null;
        }
        if (player instanceof DeployerPlayer && (dfp = (DeployerPlayer)player).isOnMinecartContraption()) {
            return null;
        }
        EntityType type = cart.getType();
        if (type != EntityType.MINECART && type != EntityType.FURNACE_MINECART && type != EntityType.CHEST_MINECART) {
            return null;
        }
        List passengers = cart.getPassengers();
        if (passengers.isEmpty() || !((e = passengers.getFirst()) instanceof OrientedContraptionEntity)) {
            return null;
        }
        OrientedContraptionEntity oce = (OrientedContraptionEntity)((Object)e);
        Contraption contraption = oce.getContraption();
        if (ContraptionMovementSetting.isNoPickup(contraption.getBlocks().values())) {
            player.displayClientMessage((Component)Component.translatable((String)"create.contraption.minecart_contraption_illegal_pickup").withStyle(ChatFormatting.RED), true);
            return null;
        }
        Level world = player.level();
        if (world.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        contraption.stop(world);
        for (MutablePair<StructureTemplate.StructureBlockInfo, MovementContext> pair : contraption.getActors()) {
            MovementBehaviour movementBehaviour = MovementBehaviour.REGISTRY.get((StateHolder<Block, ?>)((StructureTemplate.StructureBlockInfo)pair.left).state());
            if (!(movementBehaviour instanceof PortableStorageInterfaceMovement)) continue;
            PortableStorageInterfaceMovement psim = (PortableStorageInterfaceMovement)movementBehaviour;
            psim.reset((MovementContext)pair.right);
        }
        ItemStack generatedStack = MinecartContraptionItem.create(type, oce);
        generatedStack.set(DataComponents.CUSTOM_NAME, (Object)entity.getCustomName());
        if (!generatedStack.isEmpty() && (result = ItemStack.CODEC.encodeStart((DynamicOps)world.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)generatedStack).result()).isPresent() && ContraptionPickupLimiting.isTooLargeForPickup((Tag)result.get())) {
            player.displayClientMessage((Component)Component.translatable((String)"create.contraption.minecart_contraption_too_big").withStyle(ChatFormatting.RED), true);
            return null;
        }
        if (contraption.getBlocks().size() > 200 && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            AllAdvancements.CART_PICKUP.trigger(serverPlayer);
        }
        player.getInventory().placeItemBackInInventory(generatedStack);
        oce.discard();
        entity.discard();
        return InteractionResult.SUCCESS;
    }

    public static ItemStack create(EntityType<?> type, OrientedContraptionEntity entity) {
        ItemStack stack = ItemStack.EMPTY;
        if (type == EntityType.MINECART) {
            stack = AllItems.MINECART_CONTRAPTION.getDefaultInstance();
        } else if (type == EntityType.FURNACE_MINECART) {
            stack = AllItems.FURNACE_MINECART_CONTRAPTION.getDefaultInstance();
        } else if (type == EntityType.CHEST_MINECART) {
            stack = AllItems.CHEST_MINECART_CONTRAPTION.getDefaultInstance();
        }
        if (stack.isEmpty()) {
            return stack;
        }
        try (ProblemReporter.ScopedCollector logging = new ProblemReporter.ScopedCollector(entity.problemPath(), Create.LOGGER);){
            TagValueOutput view = TagValueOutput.createWithContext((ProblemReporter)logging, (HolderLookup.Provider)entity.registryAccess());
            entity.getContraption().write((ValueOutput)view, false);
            view.discard("UUID");
            view.discard("Pos");
            view.discard("Motion");
            view.store("InitialOrientation", (Codec)Direction.CODEC, (Object)entity.getInitialOrientation());
            stack.set(AllDataComponents.MINECRAFT_CONTRAPTION_DATA, (Object)view.buildResult());
        }
        return stack;
    }
}

