/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.decoration.girder;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.placement.IPlacementHelper;
import com.zurrtum.create.content.decoration.girder.GirderBlock;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class GirderWrenchBehavior {
    @Nullable
    public static Pair<Direction, Action> getDirectionAndAction(BlockHitResult result, Level world, BlockPos pos) {
        List<Pair<Direction, Action>> validDirections = GirderWrenchBehavior.getValidDirections((BlockGetter)world, pos);
        if (validDirections.isEmpty()) {
            return null;
        }
        List<Direction> directions = IPlacementHelper.orderedByDistance(pos, result.getLocation(), validDirections.stream().map(Pair::getFirst).toList());
        if (directions.isEmpty()) {
            return null;
        }
        Direction dir = directions.getFirst();
        return validDirections.stream().filter(pair -> pair.getFirst() == dir).findFirst().orElseGet(() -> Pair.of(dir, Action.SINGLE));
    }

    public static List<Pair<Direction, Action>> getValidDirections(BlockGetter level, BlockPos pos) {
        BlockState blockState = level.getBlockState(pos);
        if (!blockState.is((Block)AllBlocks.METAL_GIRDER)) {
            return Collections.emptyList();
        }
        return Arrays.stream(Iterate.directions).mapMulti((direction, consumer) -> {
            BlockState other = level.getBlockState(pos.relative(direction));
            if (!((Boolean)blockState.getValue((Property)GirderBlock.X)).booleanValue() && !((Boolean)blockState.getValue((Property)GirderBlock.Z)).booleanValue()) {
                return;
            }
            if (direction.getAxis() == Direction.Axis.Y) {
                if (!other.is((Block)AllBlocks.METAL_GIRDER)) {
                    if ((Boolean)blockState.getValue((Property)GirderBlock.X) == false ^ (Boolean)blockState.getValue((Property)GirderBlock.Z) == false) {
                        consumer.accept(Pair.of(direction, Action.SINGLE));
                    }
                    return;
                }
                if (blockState.getValue((Property)GirderBlock.X) == blockState.getValue((Property)GirderBlock.Z)) {
                    return;
                }
                if (other.getValue((Property)GirderBlock.X) == other.getValue((Property)GirderBlock.Z)) {
                    return;
                }
                consumer.accept(Pair.of(direction, Action.PAIR));
                return;
            }
        }).toList();
    }

    public static boolean handleClick(Level level, BlockPos pos, BlockState state, BlockHitResult result) {
        Pair<Direction, Action> dirPair = GirderWrenchBehavior.getDirectionAndAction(result, level, pos);
        if (dirPair == null) {
            return false;
        }
        if (level.isClientSide()) {
            return true;
        }
        if (!((Boolean)state.getValue((Property)GirderBlock.X)).booleanValue() && !((Boolean)state.getValue((Property)GirderBlock.Z)).booleanValue()) {
            return false;
        }
        Direction dir = dirPair.getFirst();
        BlockPos otherPos = pos.relative(dir);
        BlockState other = level.getBlockState(otherPos);
        if (dir == Direction.UP) {
            level.setBlock(pos, GirderWrenchBehavior.postProcess((BlockState)state.cycle((Property)GirderBlock.TOP)), 18);
            if (dirPair.getSecond() == Action.PAIR && other.is((Block)AllBlocks.METAL_GIRDER)) {
                level.setBlock(otherPos, GirderWrenchBehavior.postProcess((BlockState)other.cycle((Property)GirderBlock.BOTTOM)), 18);
            }
            return true;
        }
        if (dir == Direction.DOWN) {
            level.setBlock(pos, GirderWrenchBehavior.postProcess((BlockState)state.cycle((Property)GirderBlock.BOTTOM)), 18);
            if (dirPair.getSecond() == Action.PAIR && other.is((Block)AllBlocks.METAL_GIRDER)) {
                level.setBlock(otherPos, GirderWrenchBehavior.postProcess((BlockState)other.cycle((Property)GirderBlock.TOP)), 18);
            }
            return true;
        }
        return true;
    }

    private static BlockState postProcess(BlockState newState) {
        if (((Boolean)newState.getValue((Property)GirderBlock.TOP)).booleanValue() && ((Boolean)newState.getValue((Property)GirderBlock.BOTTOM)).booleanValue()) {
            return newState;
        }
        if (newState.getValue(GirderBlock.AXIS) != Direction.Axis.Y) {
            return newState;
        }
        return (BlockState)newState.setValue(GirderBlock.AXIS, (Comparable)((Boolean)newState.getValue((Property)GirderBlock.X) != false ? Direction.Axis.X : Direction.Axis.Z));
    }

    public static enum Action {
        SINGLE,
        PAIR,
        HORIZONTAL;

    }
}

