/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.equipment.blueprint;

import com.zurrtum.create.content.equipment.blueprint.BlueprintEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.TypedEntityData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class BlueprintItem
extends Item {
    public BlueprintItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext ctx) {
        Direction face = ctx.getClickedFace();
        Player player = ctx.getPlayer();
        ItemStack stack = ctx.getItemInHand();
        BlockPos pos = ctx.getClickedPos().relative(face);
        if (player != null && !player.mayUseItemAt(pos, face, stack)) {
            return InteractionResult.FAIL;
        }
        Level world = ctx.getLevel();
        BlueprintEntity hangingentity = new BlueprintEntity(world, pos, face, face.getAxis().isHorizontal() ? Direction.DOWN : ctx.getHorizontalDirection());
        CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (customData != null) {
            EntityType.updateCustomEntityTag((Level)world, (LivingEntity)player, (Entity)hangingentity, (TypedEntityData)TypedEntityData.of((Object)hangingentity.getType(), (CompoundTag)customData.copyTag()));
        }
        if (!hangingentity.survives()) {
            return InteractionResult.CONSUME;
        }
        if (!world.isClientSide()) {
            hangingentity.playPlacementSound();
            world.addFreshEntity((Entity)hangingentity);
        }
        stack.shrink(1);
        return InteractionResult.SUCCESS;
    }
}

